/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;

public class GlobalCloudConnectorOAuthBuilder
extends GlobalCloudConnectorTypeBuilder {
    OAuth2Component oAuth2Component;

    public GlobalCloudConnectorOAuthBuilder(Context context, Module module, OAuth2Component oAuth2Component, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.oAuth2Component = oAuth2Component;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        this.setConnectivityTestingAttribute(globalCloudConnector, (Optional<Method>)this.oAuth2Component.testConnectivityMethod());
    }

    @Override
    protected void buildMetaDataAttr(GlobalType globalCloudConnector, boolean dynamicMetadata) {
        super.buildMetaDataAttr(globalCloudConnector, false);
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.oAuth2Component.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module).concat(": ").concat(this.oAuth2Component.friendlyName());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List configurableFields = this.oAuth2Component.getConfigurableFields();
        configurableFields.removeAll(this.getOAuthConfigurableFields());
        configurableFields.addAll(this.module.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + this.oAuth2Component.friendlyName() + " configuration information.";
        javaDocSummary = javaDocSummary + (this.oAuth2Component.getJavaDocSummary() != null ? " " + this.oAuth2Component.getJavaDocSummary() : "");
        return this.helper.formatDescription(javaDocSummary);
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod() {
        throw new RuntimeException("This should have not happen, as this module was not initialized for a managed connection management but rather an OAuth component scenario");
    }

    @Override
    protected void createOAuthConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        this.buildOAuthConfig(groupsByName, attributeCategoriesByName);
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return this.getConnectionAttributes(this.getOAuthConfigurableFields());
    }

    @Override
    protected void createMetaDataAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    private List<Field> getOAuthConfigurableFields() {
        ArrayList<Field> oauthFields = new ArrayList<Field>();
        oauthFields.add(this.oAuth2Component.getConsumerKeyField());
        oauthFields.add(this.oAuth2Component.getConsumerSecretField());
        if (this.oAuth2Component.getScopeField() != null) {
            oauthFields.add(this.oAuth2Component.getScopeField());
        }
        return oauthFields;
    }
}

