/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.WordUtils;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.display.Path;
import org.mule.api.annotations.display.Summary;
import org.mule.api.annotations.param.Default;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.ClassType;
import org.mule.devkit.model.studio.EncodingType;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.FlowRefType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.IntegerType;
import org.mule.devkit.model.studio.MetaDataType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.PasswordType;
import org.mule.devkit.model.studio.PathType;
import org.mule.devkit.model.studio.QueryType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.TextType;
import org.mule.devkit.model.studio.UrlType;
import org.mule.devkit.model.studio.collection.ListOfMapAttributeType;
import org.mule.devkit.model.studio.collection.ListOfMapNoExpressionType;
import org.mule.devkit.model.studio.collection.ObjectListAttributeType;
import org.mule.devkit.model.studio.collection.ObjectListNoExpressionType;
import org.mule.devkit.model.studio.collection.StringListAttributeType;
import org.mule.devkit.model.studio.collection.StringListNoExpressionType;
import org.mule.devkit.model.studio.collection.StringMapAttributeType;
import org.mule.devkit.model.studio.collection.StringMapNoExpressionType;
import org.mule.devkit.model.studio.metadata.MultiTypeChooserType;
import org.mule.devkit.model.studio.metadata.TypeChooserType;
import org.mule.devkit.utils.NameUtils;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.util.StringUtils;

public class MuleStudioUtils {
    public static final String LIGHT_THEME_FOLDER = "theme.light/";
    public static final String CLASSIC_THEME_FOLDER = "theme.classic/";
    private static final String DEST_ICONS_FOLDER = "icons/";
    public static final String ICONS_FOLDER = "../../../icons/";
    private static final String LARGE = "large";
    private static final String SMALL = "small";
    private static final String PNG_EXTENSION = ".png";
    private static final String CONNECTOR = "%s-connector-";
    private static final String ENDPOINT = "%s-endpoint-";
    private static final String CONTAINER = "%s-container-";
    private static final String TRANSFORMER = "%s-transformer-";
    private static final String FLOW = "%s-flow-";
    public static final String SUFFIX_CONNECTOR_SMALL_PNG = "%s-connector-small.png";
    public static final String SUFFIX_CONNECTOR_LARGE_PNG = "%s-connector-large.png";
    public static final String SUFFIX_TRANSFORMER_SMALL_PNG = "%s-transformer-small.png";
    public static final String SUFFIX_TRANSFORMER_LARGE_PNG = "%s-transformer-large.png";
    public static final String SUFFIX_ENDPOINT_SMALL_PNG = "%s-endpoint-small.png";
    public static final String SUFFIX_ENDPOINT_LARGE_PNG = "%s-endpoint-large.png";
    public static final String SUFFIX_CONTAINER_SMALL_PNG = "%s-container-small.png";
    public static final String SUFFIX_CONTAINER_LARGE_PNG = "%s-container-large.png";
    public static final String SUFFIX_FLOW_SMALL_PNG = "%s-flow-small.png";
    public static final String SUFFIX_FLOW_LARGE_PNG = "%s-flow-large.png";
    public static final String GENERIC_CLOUD_CONNECTOR_SMALL = "../../../icons/%s-connector-small.png";
    public static final String GENERIC_CLOUD_CONNECTOR_LARGE = "../../../icons/%s-connector-large.png";
    public static final String GENERIC_TRANSFORMER_SMALL = "../../../icons/%s-transformer-small.png";
    public static final String GENERIC_TRANSFORMER_LARGE = "../../../icons/%s-transformer-large.png";
    public static final String GENERIC_ENDPOINT_SMALL = "../../../icons/%s-endpoint-small.png";
    public static final String GENERIC_ENDPOINT_LARGE = "../../../icons/%s-endpoint-large.png";
    public static final String GENERIC_CONTAINER_SMALL = "../../../icons/%s-container-small.png";
    public static final String GENERIC_CONTAINER_LARGE = "../../../icons/%s-container-large.png";
    public static final String GENERIC_FLOW_SMALL = "../../../icons/%s-flow-small.png";
    public static final String GENERIC_FLOW_LARGE = "../../../icons/%s-flow-large.png";

    public String formatCaption(String caption) {
        return WordUtils.capitalizeFully((String)caption);
    }

    public String formatDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            if (Character.isLowerCase(description.charAt(0))) {
                description = StringUtils.capitalize((String)description);
            }
            if (!description.endsWith(".")) {
                description = description + '.';
            }
        } else {
            description = "";
        }
        return description.replaceAll("\\<.*?\\>", "");
    }

    public String getConnectorImage(Module module) {
        return this.getImage(module, GENERIC_CLOUD_CONNECTOR_LARGE, "icons/theme.classic/");
    }

    public String getConnectorIcon(Module module) {
        return this.getImage(module, GENERIC_CLOUD_CONNECTOR_SMALL, "icons/theme.classic/");
    }

    public String getEndpointImage(Module module) {
        return this.getImage(module, GENERIC_ENDPOINT_LARGE, "icons/theme.classic/");
    }

    public String getEndpointIcon(Module module) {
        return this.getImage(module, GENERIC_ENDPOINT_SMALL, "icons/theme.classic/");
    }

    public String getTransformerImage(Module module) {
        return this.getImage(module, GENERIC_TRANSFORMER_LARGE, "icons/theme.classic/");
    }

    public String getTransformerIcon(Module module) {
        return this.getImage(module, GENERIC_TRANSFORMER_SMALL, "icons/theme.classic/");
    }

    public String getContainerImage(Module module) {
        return this.getImage(module, GENERIC_CONTAINER_LARGE, "icons/theme.classic/");
    }

    public String getContainerIcon(Module module) {
        return this.getImage(module, GENERIC_CONTAINER_SMALL, "icons/theme.classic/");
    }

    public String getFlowImage(Module module) {
        return this.getImage(module, GENERIC_FLOW_LARGE, "icons/theme.classic/");
    }

    public String getFlowIcon(Module module) {
        return this.getImage(module, GENERIC_FLOW_SMALL, "icons/theme.classic/");
    }

    public String getImage(Module module, String path, String prefix) {
        String image = String.format(path, module.getModuleName());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return prefix + image;
    }

    public String getGlobalRefId(String moduleName) {
        return "abstract" + StringUtils.capitalize((String)moduleName) + "ConnectorGeneric";
    }

    public List<JAXBElement<? extends AttributeType>> createJAXBElements(List<AttributeType> attributeTypes) {
        ArrayList<JAXBElement<? extends AttributeType>> jaxbElements = new ArrayList<JAXBElement<? extends AttributeType>>();
        for (AttributeType attributeType : attributeTypes) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJAXBElement(attributeType);
            if (jaxbElement == null) continue;
            jaxbElements.add(jaxbElement);
        }
        return jaxbElements;
    }

    public JAXBElement<? extends AttributeType> createJAXBElement(AttributeType attributeType) {
        ObjectFactory objectFactory = new ObjectFactory();
        if (attributeType instanceof PasswordType) {
            return objectFactory.createGroupPassword((PasswordType)attributeType);
        }
        if (attributeType instanceof PathType) {
            return objectFactory.createGroupFile(attributeType);
        }
        if (attributeType instanceof UrlType) {
            return objectFactory.createGroupUrl((UrlType)attributeType);
        }
        if (attributeType instanceof StringAttributeType) {
            return objectFactory.createGroupString((StringAttributeType)attributeType);
        }
        if (attributeType instanceof IntegerType) {
            return objectFactory.createGroupInteger((IntegerType)attributeType);
        }
        if (attributeType instanceof EnumType) {
            return objectFactory.createGroupEnum((EnumType)attributeType);
        }
        if (attributeType instanceof Booleantype) {
            return objectFactory.createGroupBoolean((Booleantype)attributeType);
        }
        if (attributeType instanceof TextType) {
            return objectFactory.createGroupText((TextType)attributeType);
        }
        if (attributeType instanceof FlowRefType) {
            return objectFactory.createGroupFlowRef((FlowRefType)attributeType);
        }
        if (attributeType instanceof EncodingType) {
            return objectFactory.createGroupEncoding((EncodingType)attributeType);
        }
        if (attributeType instanceof NestedElementReference) {
            return objectFactory.createNestedElementTypeChildElement((NestedElementReference)attributeType);
        }
        if (attributeType instanceof ListOfMapNoExpressionType) {
            return objectFactory.createGroupObjectList((ListOfMapNoExpressionType)attributeType);
        }
        if (attributeType instanceof ObjectListNoExpressionType) {
            return objectFactory.createGroupObjectList((ObjectListNoExpressionType)attributeType);
        }
        if (attributeType instanceof StringMapNoExpressionType) {
            return objectFactory.createGroupObjectList((StringMapNoExpressionType)attributeType);
        }
        if (attributeType instanceof StringListNoExpressionType) {
            return objectFactory.createGroupObjectList((StringListNoExpressionType)attributeType);
        }
        if (attributeType instanceof ListOfMapAttributeType) {
            return objectFactory.createGroupObjectList((ListOfMapAttributeType)attributeType);
        }
        if (attributeType instanceof ObjectListAttributeType) {
            return objectFactory.createGroupObjectList((ObjectListAttributeType)attributeType);
        }
        if (attributeType instanceof StringMapAttributeType) {
            return objectFactory.createGroupObjectList((StringMapAttributeType)attributeType);
        }
        if (attributeType instanceof StringListAttributeType) {
            return objectFactory.createGroupObjectList((StringListAttributeType)attributeType);
        }
        if (attributeType instanceof MultiTypeChooserType) {
            return objectFactory.createMultiTypeChooser((MultiTypeChooserType)attributeType);
        }
        if (attributeType instanceof TypeChooserType) {
            return objectFactory.createTypeChooser((TypeChooserType)attributeType);
        }
        if (attributeType instanceof MetaDataType) {
            return objectFactory.createMetaDataType((MetaDataType)attributeType);
        }
        if (attributeType instanceof QueryType) {
            return objectFactory.createQueryType((QueryType)attributeType);
        }
        return null;
    }

    public AttributeType createAttributeTypeIgnoreEnumsAndCollections(Variable element) {
        if (this.skipAttributeTypeGeneration((Identifiable)element)) {
            return null;
        }
        if (SchemaTypeConversion.isSupported((String)element.getJavaType())) {
            return this.createAttributeTypeOfSupportedType(element);
        }
        if (element.asType().isHttpCallback()) {
            FlowRefType flowRefType = new FlowRefType();
            flowRefType.setSupportFlow(Boolean.valueOf(true));
            flowRefType.setSupportSubflow(Boolean.valueOf(true));
            return flowRefType;
        }
        return new StringAttributeType();
    }

    private boolean skipAttributeTypeGeneration(Identifiable element) {
        return (element.asType().isCollection() || element.asType().isEnum() || element instanceof Parameter && ((Parameter)element).shouldBeIgnored()) && !((Parameter)element).isRefOnly();
    }

    private AttributeType createAttributeTypeOfSupportedType(Variable element) {
        if (element.getAnnotation(Password.class) != null) {
            return new PasswordType();
        }
        if (element.getAnnotation(Path.class) != null) {
            return new PathType();
        }
        Type elementType = element.asType();
        if (elementType.isString() || elementType.isDate() || elementType.isChar() || elementType.isFloat() || elementType.isDouble() || elementType.isCalendar()) {
            return new StringAttributeType();
        }
        if (elementType.isBoolean()) {
            Booleantype booleantype = new Booleantype();
            booleantype.setSupportsExpressions(Boolean.valueOf(true));
            return booleantype;
        }
        if (element.getJavaType().equals("java.lang.Class") || element.getJavaType().startsWith("java.lang.Class<")) {
            return new ClassType();
        }
        if (elementType.isInteger() || elementType.isLong() || elementType.isBigDecimal() || elementType.isBigInteger() || elementType.isShort() || elementType.isByte()) {
            IntegerType integerType = new IntegerType();
            integerType.setMin(0);
            integerType.setStep(1);
            return integerType;
        }
        if (elementType.isURL()) {
            return new UrlType();
        }
        throw new RuntimeException("Failed to create Studio XML, type not recognized: type=" + element.asTypeMirror().toString() + " name=" + element.getName());
    }

    public void setAttributeTypeInfo(Variable variable, AttributeType attributeType) {
        String parameterName = variable.getName();
        attributeType.setCaption(this.getFormattedCaption(variable));
        attributeType.setDescription(this.getFormattedDescription(variable));
        if (attributeType instanceof StringAttributeType && !SchemaTypeConversion.isSupported((String)variable.getJavaType())) {
            attributeType.setName(parameterName + "-ref");
        } else if (attributeType instanceof FlowRefType) {
            attributeType.setName(NameUtils.uncamel((String)parameterName) + "-flow-ref");
        } else {
            attributeType.setName(parameterName);
        }
        attributeType.setRequired(Boolean.valueOf(!variable.isOptional()));
        attributeType.setJavaType(variable.getJavaType());
        this.setDefaultValueIfAvailable(variable, attributeType);
    }

    public void setDefaultValueIfAvailable(Variable variable, AttributeType parameter) {
        Default annotation = (Default)variable.getAnnotation(Default.class);
        if (annotation != null) {
            if (parameter instanceof Booleantype) {
                ((Booleantype)parameter).setDefaultValue(Boolean.valueOf(annotation.value()));
            } else if (parameter instanceof IntegerType) {
                ((IntegerType)parameter).setDefaultValue(Integer.valueOf(annotation.value()));
            } else if (parameter instanceof StringAttributeType) {
                ((StringAttributeType)parameter).setDefaultValue(annotation.value());
            } else if (parameter instanceof EnumType) {
                ((EnumType)parameter).setDefaultValue(annotation.value());
            }
        }
    }

    public String getLocalId(Method executableElement, Variable variable) {
        if (executableElement != null) {
            return NameUtils.uncamel((String)executableElement.getName()) + '-' + NameUtils.uncamel((String)variable.getName());
        }
        return "configurable-" + NameUtils.uncamel((String)variable.getName());
    }

    public String getLocalId(Method executableElement) {
        return executableElement.xsdName();
    }

    public String getFormattedDescription(Variable element) {
        Summary description = (Summary)element.getAnnotation(Summary.class);
        if (description != null && StringUtils.isNotBlank((String)description.value())) {
            return this.formatDescription(description.value());
        }
        if (element instanceof Parameter) {
            return this.formatDescription(element.parent().getJavaDocParameterSummary(element.getName()));
        }
        return this.formatDescription(element.getJavaDocSummary());
    }

    public String getFormattedDescription(Module module) {
        if (StringUtils.isNotBlank((String)module.getDescription())) {
            return module.getDescription();
        }
        return this.formatDescription(module.getJavaDocSummary());
    }

    public String getFormattedCaption(Module module) {
        if (StringUtils.isNotBlank((String)module.getFriendlyName())) {
            return module.getFriendlyName();
        }
        return this.formatCaption(module.getModuleName().replaceAll("-", " "));
    }

    public String getFormattedCaption(Method element) {
        return this.formatCaption(this.getFriendlyName(element));
    }

    public String getFormattedCaption(Variable element) {
        FriendlyName caption = (FriendlyName)element.getAnnotation(FriendlyName.class);
        if (caption != null && StringUtils.isNotBlank((String)caption.value())) {
            return caption.value();
        }
        String friendlyName = NameUtils.friendlyNameFromCamelCase((String)element.getName());
        if (element.asType().isHttpCallback()) {
            return this.formatCaption(friendlyName + " Flow");
        }
        if (!this.isKnownType(element) || element.isRefOnly()) {
            return this.formatCaption(friendlyName + " Reference");
        }
        return this.formatCaption(friendlyName);
    }

    public String getFriendlyName(Method element) {
        return element.friendlyName();
    }

    public boolean isKnownType(Variable variable) {
        return variable.asType().isString() || variable.asType().isChar() || variable.asType().isDate() || variable.asType().isDouble() || variable.asType().isFloat() || variable.asType().isLong() || variable.asType().isHttpCallback() || variable.asType().isInteger() || variable.asType().isBigDecimal() || variable.asType().isBigInteger() || variable.asType().isBoolean() || variable.asType().isEnum() || variable.asType().isCollection() || variable.asType().isURL() || variable.asType().inheritsFrom(HttpRequesterConfig.class);
    }

    public String getUrl(Module module) {
        return "http://www.mulesoft.org/schema/mule/" + module.getModuleName() + '/';
    }

    public StringAttributeType createStringAttributeType(String caption, String description, String name) {
        StringAttributeType stringAttributeType = new StringAttributeType();
        stringAttributeType.setCaption(this.formatCaption(caption));
        stringAttributeType.setDescription(this.formatDescription(description));
        stringAttributeType.setName(name);
        return stringAttributeType;
    }

    public Group createGroup(String id, String caption) {
        Group group = new Group();
        group.setId(id);
        group.setCaption(this.formatCaption(caption));
        return group;
    }

    public String getPagedReturnType(Method method) {
        String returnType = List.class.getCanonicalName();
        if (!method.getReturnGenericType().getGenericTypeArguments().isEmpty()) {
            returnType = returnType + "<";
            returnType = returnType + ((GenericType)method.getReturnGenericType().getGenericTypeArguments().get(0)).getType().toString();
            returnType = returnType + ">";
        }
        return returnType;
    }

    public Optional<ProcessorMethod> getProcessorMethod(Module module, Method method) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!StringUtils.equals((String)processorMethod.getName(), (String)method.getName())) continue;
            return Optional.of((Object)processorMethod);
        }
        return Optional.absent();
    }

    public boolean isCollection(Variable parameter) {
        return this.isListOfMaps(parameter) || this.isSimpleList(parameter) || this.isSimpleMap(parameter) || this.isSimpleSet(parameter);
    }

    public boolean isListOfMaps(Variable parameter) {
        return parameter.asType().isArrayOrList() && !parameter.getTypeArguments().isEmpty() && ((Type)parameter.getTypeArguments().get(0)).isMap();
    }

    public boolean isSimpleMap(Variable parameter) {
        return parameter.asType().isMap() && (parameter.getTypeArguments().isEmpty() || !((Type)parameter.getTypeArguments().get(1)).isCollection());
    }

    public boolean isSimpleList(Variable parameter) {
        return parameter.asType().isArrayOrList() && (parameter.getTypeArguments().isEmpty() || !((Type)parameter.getTypeArguments().get(0)).isCollection());
    }

    public boolean isSimpleSet(Variable parameter) {
        return parameter.asType().isSet() && (parameter.getTypeArguments().isEmpty() || !((Type)parameter.getTypeArguments().get(0)).isCollection());
    }
}

