/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;

public class GlobalCloudConnectorModuleBuilder
extends GlobalCloudConnectorTypeBuilder {
    public GlobalCloudConnectorModuleBuilder(Context context, Module module, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        this.setConnectivityTestingAttribute(globalCloudConnector, (Optional<Method>)this.module.testConnectivityMethod());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List configurableFields = this.module.getConfigurableFields();
        if (this.isOAuthModule()) {
            configurableFields.removeAll(this.getOAuthConfigurableFields());
        }
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return this.module.getConfigElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module);
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global " + this.helper.getFormattedCaption(this.module) + " configuration information");
    }

    @Override
    protected boolean hasConnectionMethod() {
        return this.module instanceof ManagedConnectionModule;
    }

    @Override
    protected ConnectMethod connectMethod() {
        if (!(this.module instanceof ManagedConnectionModule)) {
            throw new RuntimeException("This should have not happen, as this module was not initialized for a managed connection management");
        }
        return ((ConnectionManagementCapability)this.module).getConnectMethod();
    }

    @Override
    protected void createOAuthConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof OAuthModule) {
            this.buildOAuthConfig(groupsByName, attributeCategoriesByName);
        }
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        if (this.hasConnectionMethod()) {
            return this.getConnectionAttributes((ConnectionManagementCapability)this.module);
        }
        if (this.isOAuthModule()) {
            return this.getConnectionAttributes(this.getOAuthConfigurableFields());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void setRequiredConnectionParameter(AttributeType attributeType, Variable variable) {
        if (this.hasConnectionMethod()) {
            attributeType.setRequired(Boolean.valueOf(false));
        } else {
            super.setRequiredConnectionParameter(attributeType, variable);
        }
    }

    private List<Field> getOAuthConfigurableFields() {
        if (!this.isOAuthModule()) {
            throw new RuntimeException("This should have not happen, as this module was not initialized for a OAuth2 type");
        }
        OAuthModule oAuthModule = (OAuthModule)this.module;
        ArrayList<Field> oauthFields = new ArrayList<Field>();
        oauthFields.add(oAuthModule.getConsumerKeyField());
        oauthFields.add(oAuthModule.getConsumerSecretField());
        if (oAuthModule.getScopeField() != null) {
            oauthFields.add(oAuthModule.getScopeField());
        }
        return oauthFields;
    }

    private boolean isOAuthModule() {
        return this.module instanceof OAuthModule;
    }
}

