/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.verifiers.util.MulePathResolver;

public class MultiModuleStudioPackageVerifier
implements MultiModuleAnnotationVerifier {
    public boolean shouldVerify(List<Module> modules) {
        return true;
    }

    public List<Module> processableModules(List<Module> modules) {
        return modules;
    }

    public void verify(List<Module> modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (!this.hasConnectorOrModule(modules)) {
            gatherer.error((Identifiable)modules.get(0), (DevkitNotification)Message.DEVKIT_PACKAGE_PROPERTY_REQUIRES_AT_LEAST_ONE_MODULE, new Object[0]);
        } else {
            this.verifyModules(modules, gatherer);
        }
    }

    private void verifyModules(List<Module> modules, NotificationGatherer gatherer) {
        List<Module> modulesToBeValidated = this.getModuleByKind(modules, Arrays.asList(ModuleKind.CONNECTOR, ModuleKind.GENERIC));
        for (Module module : modulesToBeValidated) {
            this.verifyIcon(module, gatherer);
        }
    }

    private void verifyIcon(Module module, NotificationGatherer gatherer) {
        if (module.hasProcessors() || this.hasWsdlComponent(module)) {
            this.checkIcon(String.format("../../../icons/%s-connector-48x32.png", module.getModuleName()), module, gatherer);
            this.checkIcon(String.format("../../../icons/%s-connector-48x32.png", module.getModuleName()), module, gatherer);
        }
        if (module.hasSources()) {
            this.checkIcon(String.format("../../../icons/%s-endpoint-48x32.png", module.getModuleName()), module, gatherer);
            this.checkIcon(String.format("../../../icons/%s-endpoint-24x16.png", module.getModuleName()), module, gatherer);
        }
        if (module.hasTransformers()) {
            this.checkIcon(String.format("../../../icons/%s-transformer-48x32.png", module.getModuleName()), module, gatherer);
            this.checkIcon(String.format("../../../icons/%s-transformer-24x16.png", module.getModuleName()), module, gatherer);
        }
        if (this.hasContainer(module)) {
            this.checkIcon(String.format("../../../icons/%s-container-48x32.png", module.getModuleName()), module, gatherer);
            this.checkIcon(String.format("../../../icons/%s-container-24x16.png", module.getModuleName()), module, gatherer);
        }
        if (this.hasContainerList(module)) {
            this.checkIcon(String.format("../../../icons/%s-flow-48x32.png", module.getModuleName()), module, gatherer);
            this.checkIcon(String.format("../../../icons/%s-flow-24x16.png", module.getModuleName()), module, gatherer);
        }
    }

    private void checkIcon(String fileName, Module module, NotificationGatherer gatherer) {
        File fileToCopy = MulePathResolver.getFileResolvingPackages((Module)module, (String)fileName);
        if (!fileToCopy.exists()) {
            gatherer.warn((Identifiable)module, (DevkitNotification)Message.MISSING_ICON, new Object[]{module.getModuleName(), fileToCopy.getAbsolutePath()});
        }
    }

    private List<Module> getModuleByKind(List<Module> modules, List<ModuleKind> kinds) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!kinds.contains(module.getKind())) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    private boolean hasConnectorOrModule(List<Module> modules) {
        boolean hasConnectorOrModule = false;
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            hasConnectorOrModule = true;
        }
        return hasConnectorOrModule;
    }

    private boolean hasWsdlComponent(Module module) {
        return module.manager().wsdlProviderComponent().size() > 0;
    }

    private boolean hasContainer(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainer()) continue;
            return true;
        }
        return false;
    }

    private boolean hasContainerList(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainerList()) continue;
            return true;
        }
        return false;
    }
}

