/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import sun.security.tools.JarSigner;

public class SignComponent {
    private String keystorePath;
    private final String storepass;
    private final String keypass;
    private final String alias;
    private final String tsaUrl;

    public SignComponent(String keystorePath, String storepass, String keypass, String alias, String tsaUrl) {
        this.keystorePath = keystorePath;
        this.storepass = storepass;
        this.keypass = keypass;
        this.alias = alias;
        this.tsaUrl = tsaUrl;
    }

    private List<String> buildOptions(String path) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-keystore");
        options.add(this.keystorePath);
        if (this.storepass != null) {
            options.add("-storepass");
            options.add(this.storepass);
        }
        if (this.keypass != null) {
            options.add("-keypass");
            options.add(this.keypass);
        }
        if (this.tsaUrl != null) {
            options.add("-tsa");
            options.add(this.tsaUrl);
        }
        options.add("-verbose");
        options.add(path);
        options.add(this.alias);
        return options;
    }

    public void sign(File pluginOrFeature) {
        if (this.keystorePath != null && new File(this.keystorePath).exists()) {
            JarSigner jarsigner = new JarSigner();
            List<String> pluginOrFeatureOptions = this.buildOptions(pluginOrFeature.getPath());
            jarsigner.run(pluginOrFeatureOptions.toArray(new String[0]));
        }
    }
}

