/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.api.ConnectorCategory;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.utils.MuleStudioPathResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MuleStudioPluginXmlGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private static final String PLUGIN_XML_FILE_NAME = "plugin.xml";
    public static final String CORE_CONTRIBUTION = "org.mule.tooling.core.contribution";
    public static final String MAVEN_POPULATE = "org.mule.tooling.maven.populate";
    public static final String CONTRIBUTION_JAR_TAG = "contribution-jar";
    public static final String EXTERNAL_CONTRIBUTION_TAG = "externalContribution";
    private static List<Product> CONSUMES = Arrays.asList(Product.STUDIO_EDITOR_XML);
    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_PLUGIN_XML);
    private static final String PROPERTIES_RELATIVE_PATH = "../../../META-INF/studio.properties";
    private Document pluginDoc;

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        try {
            this.createPluginDocument();
            Element pluginElement = this.pluginDoc.createElement("plugin");
            this.pluginDoc.appendChild(pluginElement);
            Element coreContributionExtension = this.createExtensionPoint(CORE_CONTRIBUTION);
            pluginElement.appendChild(coreContributionExtension);
            this.addExternalContribution(module, coreContributionExtension);
            if (!StringUtils.equalsIgnoreCase((String)this.ctx().getMavenInformation().getCategory(), (String)ConnectorCategory.COMMUNITY.name())) {
                this.addMavenPopulateExtensionPoint(pluginElement);
            }
            ModuleRelativePathBuilder relativePath = this.exportDoc(module);
            this.ctx().registerProduct(Product.STUDIO_PLUGIN_XML, (Identifiable)module, (Object)relativePath);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", (Throwable)e);
        }
    }

    private void addMavenPopulateExtensionPoint(Element pluginElement) {
        Element mavenPopulateExtension = this.createExtensionPoint(MAVEN_POPULATE);
        pluginElement.appendChild(mavenPopulateExtension);
        this.addJarContribution(mavenPopulateExtension);
    }

    private void addJarContribution(Element extensionElement) {
        Element contributionElement = this.pluginDoc.createElement(CONTRIBUTION_JAR_TAG);
        contributionElement.setAttribute("jar", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + ".jar");
        extensionElement.appendChild(contributionElement);
    }

    private ModuleRelativePathBuilder exportDoc(Module module) throws IOException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.pluginDoc);
        ModuleRelativePathBuilder relativePath = new ModuleRelativePathBuilder(PLUGIN_XML_FILE_NAME);
        StreamResult result = new StreamResult(this.ctx().getCodeModel().getCodeWriter().openBinary(null, relativePath.build(module).getFullPath()));
        transformer.transform(source, result);
        return relativePath;
    }

    private void addExternalContribution(Module module, Element extensionElement) throws IOException {
        Element externalContributionElement = this.pluginDoc.createElement(EXTERNAL_CONTRIBUTION_TAG);
        externalContributionElement.setAttribute("contributionJar", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + ".jar");
        externalContributionElement.setAttribute("contributionLibPathInMule", "/plugins");
        externalContributionElement.setAttribute("contributionLibs", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + ".zip");
        externalContributionElement.setAttribute("contributionSources", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + "-sources.jar");
        externalContributionElement.setAttribute("contributionJavaDocs", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + "-javadoc.jar");
        externalContributionElement.setAttribute("contributionNamespace", module.getXmlNamespace());
        externalContributionElement.setAttribute("contributionNamespaceFile", module.getCurrentSchemaLocation());
        externalContributionElement.setAttribute("contributionNamespacePrefix", module.getModuleName());
        externalContributionElement.setAttribute("contributionType", "cloud-connector");
        externalContributionElement.setAttribute("path", ((ModuleRelativePathBuilder)this.ctx().getProduct(Product.STUDIO_EDITOR_XML, (Identifiable)module)).build(module).getRelativeToModulePath());
        externalContributionElement.setAttribute("version", this.ctx().getMavenInformation().getVersion());
        externalContributionElement.setAttribute("name", module.getFriendlyName());
        externalContributionElement.setAttribute("minimumVersion", module.getMinMuleVersion().toString());
        externalContributionElement.setAttribute("contributionVersion", this.ctx().getMavenInformation().getVersion());
        this.lookUpPropertiesFile(module, extensionElement, externalContributionElement);
        extensionElement.appendChild(externalContributionElement);
    }

    private void createPluginDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.pluginDoc = documentBuilder.newDocument();
    }

    private void lookUpPropertiesFile(Module module, Element extensionElement, Element externalContributionElement) throws IOException {
        File propertiesFile = MuleStudioPathResolver.getFileResolvingPackages(module, PROPERTIES_RELATIVE_PATH);
        if (propertiesFile.exists()) {
            this.ctx().note("Properties file found in [" + propertiesFile.getCanonicalPath() + "]. Keep in mind that, if any property is overlapped against the default one, the customized one will overwrite the default one.");
            FileInputStream fileInputStream = new FileInputStream(propertiesFile);
            Properties connectorProperties = new Properties();
            connectorProperties.load(fileInputStream);
            for (String propertyName : connectorProperties.stringPropertyNames()) {
                String propertyValue = connectorProperties.getProperty(propertyName);
                if (externalContributionElement.hasAttribute(propertyName)) {
                    this.ctx().warn("The property [" + propertyName + "] was overwritten, new value is [" + propertyValue + "] (instead of default one [" + extensionElement.getAttribute(propertyName) + "])");
                }
                externalContributionElement.setAttribute(propertyName, propertyValue);
            }
        }
    }

    private Element createExtensionPoint(String point) {
        Element extensionElement = this.pluginDoc.createElement("extension");
        extensionElement.setAttribute("point", point);
        return extensionElement;
    }
}

