/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.annotations.display.Icons;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.utils.MuleStudioPathResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.util.IOUtils;

public class MuleStudioIconsGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_ICONS);
    private ArrayList<ModuleRelativePathBuilder> iconsFileName;

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        this.iconsFileName = new ArrayList();
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String connectorSmall = String.format("../../../icons/%s-connector-24x16.png", module.getModuleName());
        String connectorLarge = String.format("../../../icons/%s-connector-48x32.png", module.getModuleName());
        String transformerSmall = String.format("../../../icons/%s-transformer-24x16.png", module.getModuleName());
        String transformerLarge = String.format("../../../icons/%s-transformer-48x32.png", module.getModuleName());
        String endpointSmall = String.format("../../../icons/%s-endpoint-24x16.png", module.getModuleName());
        String endpointLarge = String.format("../../../icons/%s-endpoint-48x32.png", module.getModuleName());
        if (icons != null) {
            connectorSmall = icons.connectorSmall();
            connectorLarge = icons.connectorLarge();
            transformerSmall = icons.transformerSmall();
            transformerLarge = icons.transformerLarge();
            endpointSmall = icons.endpointSmall();
            endpointLarge = icons.endpointLarge();
        }
        this.copyFile(connectorSmall, "icons/small", module, "%s-connector-24x16.png");
        this.copyFile(connectorLarge, "icons/large", module, "%s-connector-48x32.png");
        if (module.hasTransformers()) {
            this.copyFile(transformerSmall, "icons/small", module, "%s-transformer-24x16.png");
            this.copyFile(transformerLarge, "icons/large", module, "%s-transformer-48x32.png");
        }
        if (module.hasSources()) {
            this.copyFile(endpointSmall, "icons/small", module, "%s-endpoint-24x16.png");
            this.copyFile(endpointLarge, "icons/large", module, "%s-endpoint-48x32.png");
        }
        this.ctx().registerProduct(Product.STUDIO_ICONS, (Identifiable)module, this.iconsFileName);
    }

    private void copyFile(String fileName, String folder, Module module, String sufix) throws GenerationException {
        InputStream iconStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = this.createFile(module, folder, fileName);
            File fileToCopy = MuleStudioPathResolver.getFileResolvingPackages(module, fileName);
            if (fileToCopy.exists()) {
                iconStream = new FileInputStream(fileToCopy);
            } else {
                String fileIconPath = String.format(sufix, "generic");
                iconStream = MuleStudioIconsGenerator.class.getClassLoader().getResourceAsStream(fileIconPath);
            }
            IOUtils.copy((InputStream)iconStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new GenerationException("Error copying icons to output folder: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(iconStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)iconStream);
    }

    private OutputStream createFile(Module module, String folder, String fileName) throws GenerationException {
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        try {
            ModuleRelativePathBuilder pathBuilder = new ModuleRelativePathBuilder(folder + "/" + fileName);
            String fullIconPath = pathBuilder.build(module).getFullPath();
            this.iconsFileName.add(pathBuilder);
            return this.ctx().getCodeModel().getCodeWriter().openBinary(null, fullIconPath);
        }
        catch (IOException e) {
            throw new GenerationException("Could not create file or folder " + fileName + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

