/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.display.Placement;
import org.mule.devkit.model.Variable;

public class VariableComparator
implements Comparator<Variable> {
    private static final int VARIABLE1_FIRST = -1;
    private static final int VARIABLE2_FIRST = 1;

    @Override
    public int compare(Variable variable1, Variable variable2) {
        Placement placementVar2;
        Placement placementVar1 = (Placement)variable1.getAnnotation(Placement.class);
        if (!this.sameGroup(placementVar1, placementVar2 = (Placement)variable2.getAnnotation(Placement.class))) {
            return 0;
        }
        if (placementVar1 != null && placementVar2 != null) {
            return new Integer(placementVar1.order()).compareTo(placementVar2.order());
        }
        if (placementVar1 != null) {
            return new Integer(placementVar1.order()).compareTo(1);
        }
        if (placementVar2 != null) {
            return new Integer(1).compareTo(placementVar2.order());
        }
        if (this.bothOfSameType(variable1, variable2)) {
            return this.compareByName(variable1, variable2);
        }
        if (variable1.asType().isCollection()) {
            return 1;
        }
        if (variable2.asType().isCollection()) {
            return -1;
        }
        if (variable1.asType().isBoolean()) {
            return 1;
        }
        if (variable2.asType().isBoolean()) {
            return -1;
        }
        if (variable1.asType().isEnum()) {
            return 1;
        }
        if (variable2.asType().isEnum()) {
            return -1;
        }
        return 0;
    }

    private boolean sameGroup(Placement placementVar1, Placement placementVar2) {
        String group1 = this.extractGroup(placementVar1);
        String group2 = this.extractGroup(placementVar2);
        return group1.equals(group2);
    }

    private String extractGroup(Placement placement) {
        if (placement != null && StringUtils.isNotBlank((String)placement.group())) {
            return placement.group();
        }
        return "General";
    }

    private boolean bothOfSameType(Variable variable1, Variable variable2) {
        return variable1.asType().isString() && variable2.asType().isString() || variable1.asType().isInteger() && variable2.asType().isInteger() || variable1.asType().isEnum() && variable2.asType().isEnum() || variable1.asType().isBoolean() && variable2.asType().isBoolean() || variable1.asType().isCollection() && variable2.asType().isCollection();
    }

    private int compareByName(Variable variable1, Variable variable2) {
        String name1 = this.extractName(variable1);
        String name2 = this.extractName(variable2);
        return name1.compareTo(name2);
    }

    private String extractName(Variable variable) {
        if (variable.getAnnotation(FriendlyName.class) != null) {
            return ((FriendlyName)variable.getAnnotation(FriendlyName.class)).value();
        }
        return variable.getName();
    }
}

