/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.utils.MuleStudioPathResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleStudioPluginXmlGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private static final String PLUGIN_XML_FILE_NAME = "plugin.xml";
    private static List<Product> CONSUMES = Arrays.asList(Product.STUDIO_EDITOR_XML);
    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_PLUGIN_XML);
    private static final String PROPERTIES_RELATIVE_PATH = "../../../META-INF/studio.properties";

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element pluginElement = document.createElement("plugin");
            document.appendChild(pluginElement);
            Element extensionElement = document.createElement("extension");
            extensionElement.setAttribute("point", "org.mule.tooling.core.contribution");
            pluginElement.appendChild(extensionElement);
            Element externalContributionElement = document.createElement("externalContribution");
            externalContributionElement.setAttribute("contributionJar", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + ".jar");
            externalContributionElement.setAttribute("contributionLibPathInMule", "/plugins");
            externalContributionElement.setAttribute("contributionLibs", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + ".zip");
            externalContributionElement.setAttribute("contributionSources", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + "-sources.jar");
            externalContributionElement.setAttribute("contributionJavaDocs", this.ctx().getMavenInformation().getArtifactId() + "-" + this.ctx().getMavenInformation().getVersion() + "-javadoc.jar");
            externalContributionElement.setAttribute("contributionNamespace", module.getXmlNamespace());
            externalContributionElement.setAttribute("contributionNamespaceFile", module.getCurrentSchemaLocation());
            externalContributionElement.setAttribute("contributionNamespacePrefix", module.getModuleName());
            externalContributionElement.setAttribute("contributionType", "cloud-connector");
            externalContributionElement.setAttribute("path", ((ModuleRelativePathBuilder)this.ctx().getProduct(Product.STUDIO_EDITOR_XML, (Identifiable)module)).build(module).getRelativeToModulePath());
            externalContributionElement.setAttribute("version", this.ctx().getMavenInformation().getVersion());
            externalContributionElement.setAttribute("name", module.getFriendlyName());
            externalContributionElement.setAttribute("minimumVersion", module.getMinMuleVersion().toString());
            externalContributionElement.setAttribute("contributionVersion", this.ctx().getMavenInformation().getVersion());
            this.lookUpPropertiesFile(module, extensionElement, externalContributionElement);
            extensionElement.appendChild(externalContributionElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            ModuleRelativePathBuilder relativePath = new ModuleRelativePathBuilder(PLUGIN_XML_FILE_NAME);
            StreamResult result = new StreamResult(this.ctx().getCodeModel().getCodeWriter().openBinary(null, relativePath.build(module).getFullPath()));
            transformer.transform(source, result);
            this.ctx().registerProduct(Product.STUDIO_PLUGIN_XML, (Identifiable)module, (Object)relativePath);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", (Throwable)e);
        }
    }

    private void lookUpPropertiesFile(Module module, Element extensionElement, Element externalContributionElement) throws IOException {
        File propertiesFile = MuleStudioPathResolver.getFileResolvingPackages(module, PROPERTIES_RELATIVE_PATH);
        if (propertiesFile.exists()) {
            this.ctx().note("Properties file found in [" + propertiesFile.getCanonicalPath() + "]. Keep in mind that, if any property is overlapped against the default one, the customized one will overwrite the default one.");
            FileInputStream fileInputStream = new FileInputStream(propertiesFile);
            Properties connectorProperties = new Properties();
            connectorProperties.load(fileInputStream);
            for (String propertyName : connectorProperties.stringPropertyNames()) {
                String propertyValue = connectorProperties.getProperty(propertyName);
                if (externalContributionElement.hasAttribute(propertyName)) {
                    this.ctx().warn("The property [" + propertyName + "] was overwritten, new value is [" + propertyValue + "] (instead of default one [" + extensionElement.getAttribute(propertyName) + "])");
                }
                externalContributionElement.setAttribute(propertyName, propertyValue);
            }
        }
    }
}

