/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.WordUtils;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.display.Icons;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.display.Path;
import org.mule.api.annotations.display.Summary;
import org.mule.api.annotations.param.Default;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.ClassType;
import org.mule.devkit.model.studio.EncodingType;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.FlowRefType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.IntegerType;
import org.mule.devkit.model.studio.ListOfMapAttributeType;
import org.mule.devkit.model.studio.MetaDataType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.ObjectListAttributeType;
import org.mule.devkit.model.studio.PasswordType;
import org.mule.devkit.model.studio.PathType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.StringListAttributeType;
import org.mule.devkit.model.studio.StringMapAttributeType;
import org.mule.devkit.model.studio.TextType;
import org.mule.devkit.model.studio.TypeChooserType;
import org.mule.devkit.model.studio.UrlType;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleStudioUtils {
    private static final String IMAGE_PREFIX = "icons/large/";
    private static final String ICON_PREFIX = "icons/small/";

    public String formatCaption(String caption) {
        return WordUtils.capitalizeFully((String)caption);
    }

    public String formatDescription(String description) {
        if (description != null) {
            if (Character.isLowerCase(description.charAt(0))) {
                description = StringUtils.capitalize((String)description);
            }
            if (!description.endsWith(".")) {
                description = description + '.';
            }
        } else {
            description = "";
        }
        return description.replaceAll("\\<.*?\\>", "");
    }

    public String getConnectorImage(Module module) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String image = icons != null ? icons.connectorLarge() : String.format("../../../icons/%s-connector-48x32.png", module.getModuleName());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return IMAGE_PREFIX + image;
    }

    public String getConnectorIcon(Module module) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String icon = icons != null ? icons.connectorSmall() : String.format("../../../icons/%s-connector-24x16.png", module.getModuleName());
        if (icon.contains("/")) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
        }
        return ICON_PREFIX + icon;
    }

    public String getEndpointImage(Module module) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String image = icons != null ? icons.endpointLarge() : String.format("../../../icons/%s-endpoint-48x32.png", module.getModuleName());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return IMAGE_PREFIX + image;
    }

    public String getEndpointIcon(Module module) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String icon = icons != null ? icons.endpointSmall() : String.format("../../../icons/%s-endpoint-24x16.png", module.getModuleName());
        if (icon.contains("/")) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
        }
        return ICON_PREFIX + icon;
    }

    public String getTransformerImage(Module module) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String image = icons != null ? icons.transformerLarge() : String.format("../../../icons/%s-transformer-48x32.png", module.getModuleName());
        if (image.contains("/")) {
            image = image.substring(image.lastIndexOf("/") + 1);
        }
        return IMAGE_PREFIX + image;
    }

    public String getTransformerIcon(Module module) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String icon = icons != null ? icons.transformerSmall() : String.format("../../../icons/%s-transformer-24x16.png", module.getModuleName());
        if (icon.contains("/")) {
            icon = icon.substring(icon.lastIndexOf("/") + 1);
        }
        return ICON_PREFIX + icon;
    }

    public String getGlobalRefId(String moduleName) {
        return "abstract" + StringUtils.capitalize((String)moduleName) + "ConnectorGeneric";
    }

    public List<JAXBElement<? extends AttributeType>> createJAXBElements(List<AttributeType> attributeTypes) {
        ArrayList<JAXBElement<? extends AttributeType>> jaxbElements = new ArrayList<JAXBElement<? extends AttributeType>>();
        for (AttributeType attributeType : attributeTypes) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJAXBElement(attributeType);
            if (jaxbElement == null) continue;
            jaxbElements.add(jaxbElement);
        }
        return jaxbElements;
    }

    public JAXBElement<? extends AttributeType> createJAXBElement(AttributeType attributeType) {
        ObjectFactory objectFactory = new ObjectFactory();
        if (attributeType instanceof PasswordType) {
            return objectFactory.createGroupPassword((PasswordType)attributeType);
        }
        if (attributeType instanceof PathType) {
            return objectFactory.createGroupFile(attributeType);
        }
        if (attributeType instanceof UrlType) {
            return objectFactory.createGroupUrl((UrlType)attributeType);
        }
        if (attributeType instanceof StringAttributeType) {
            return objectFactory.createGroupString((StringAttributeType)attributeType);
        }
        if (attributeType instanceof IntegerType) {
            return objectFactory.createGroupInteger((IntegerType)attributeType);
        }
        if (attributeType instanceof EnumType) {
            return objectFactory.createGroupEnum((EnumType)attributeType);
        }
        if (attributeType instanceof Booleantype) {
            return objectFactory.createGroupBoolean((Booleantype)attributeType);
        }
        if (attributeType instanceof TextType) {
            return objectFactory.createGroupText((TextType)attributeType);
        }
        if (attributeType instanceof FlowRefType) {
            return objectFactory.createGroupFlowRef((FlowRefType)attributeType);
        }
        if (attributeType instanceof EncodingType) {
            return objectFactory.createGroupEncoding((EncodingType)attributeType);
        }
        if (attributeType instanceof NestedElementReference) {
            return objectFactory.createNestedElementTypeChildElement((NestedElementReference)attributeType);
        }
        if (attributeType instanceof ListOfMapAttributeType) {
            return objectFactory.createGroupObjectList((ListOfMapAttributeType)attributeType);
        }
        if (attributeType instanceof ObjectListAttributeType) {
            return objectFactory.createGroupObjectList((ObjectListAttributeType)attributeType);
        }
        if (attributeType instanceof StringMapAttributeType) {
            return objectFactory.createGroupObjectList((StringMapAttributeType)attributeType);
        }
        if (attributeType instanceof StringListAttributeType) {
            return objectFactory.createGroupObjectList((StringListAttributeType)attributeType);
        }
        if (attributeType instanceof TypeChooserType) {
            return objectFactory.createTypeChooser((TypeChooserType)attributeType);
        }
        if (attributeType instanceof MetaDataType) {
            return objectFactory.createMetaDataType((MetaDataType)attributeType);
        }
        return null;
    }

    public AttributeType createAttributeTypeIgnoreEnumsAndCollections(Variable element) {
        if (this.skipAttributeTypeGeneration((Identifiable)element)) {
            return null;
        }
        if (SchemaTypeConversion.isSupported((String)element.getJavaType())) {
            return this.createAttributeTypeOfSupportedType(element);
        }
        if (element.asType().isHttpCallback()) {
            FlowRefType flowRefType = new FlowRefType();
            flowRefType.setSupportFlow(Boolean.valueOf(true));
            flowRefType.setSupportSubflow(Boolean.valueOf(true));
            return flowRefType;
        }
        return new StringAttributeType();
    }

    private boolean skipAttributeTypeGeneration(Identifiable element) {
        return element.asType().isCollection() || element.asType().isEnum() || element instanceof Parameter && ((Parameter)element).shouldBeIgnored();
    }

    private AttributeType createAttributeTypeOfSupportedType(Variable element) {
        if (element.getAnnotation(Password.class) != null) {
            return new PasswordType();
        }
        if (element.getAnnotation(Path.class) != null) {
            return new PathType();
        }
        if (element.asType().isString() || element.asType().isDate() || element.asType().isChar() || element.asType().isFloat() || element.asType().isDouble() || element.asType().isCalendar()) {
            return new StringAttributeType();
        }
        if (element.asType().isBoolean()) {
            Booleantype booleantype = new Booleantype();
            booleantype.setSupportsExpressions(Boolean.valueOf(true));
            return booleantype;
        }
        if (element.getJavaType().equals("java.lang.Class") || element.getJavaType().startsWith("java.lang.Class<")) {
            return new ClassType();
        }
        if (element.asType().isInteger() || element.asType().isLong() || element.asType().isBigDecimal() || element.asType().isBigInteger()) {
            IntegerType integerType = new IntegerType();
            integerType.setMin(0);
            integerType.setStep(1);
            return integerType;
        }
        if (element.asType().isURL()) {
            return new UrlType();
        }
        throw new RuntimeException("Failed to create Studio XML, type not recognized: type=" + ((Object)element.asTypeMirror()).toString() + " name=" + element.getName());
    }

    public void setAttributeTypeInfo(Variable variable, AttributeType attributeType) {
        String parameterName = variable.getName();
        attributeType.setCaption(this.getFormattedCaption(variable));
        attributeType.setDescription(this.getFormattedDescription(variable));
        if (attributeType instanceof StringAttributeType && !SchemaTypeConversion.isSupported((String)variable.getJavaType())) {
            attributeType.setName(parameterName + "-ref");
        } else if (attributeType instanceof FlowRefType) {
            attributeType.setName(NameUtils.uncamel((String)parameterName) + "-flow-ref");
        } else {
            attributeType.setName(parameterName);
        }
        attributeType.setRequired(Boolean.valueOf(!variable.isOptional()));
        attributeType.setJavaType(variable.getJavaType());
        this.setDefaultValueIfAvailable(variable, attributeType);
    }

    public void setDefaultValueIfAvailable(Variable variable, AttributeType parameter) {
        Default annotation = (Default)variable.getAnnotation(Default.class);
        if (annotation != null) {
            if (parameter instanceof Booleantype) {
                ((Booleantype)parameter).setDefaultValue(Boolean.valueOf(annotation.value()));
            } else if (parameter instanceof IntegerType) {
                ((IntegerType)parameter).setDefaultValue(Integer.valueOf(annotation.value()));
            } else if (parameter instanceof StringAttributeType) {
                ((StringAttributeType)parameter).setDefaultValue(annotation.value());
            } else if (parameter instanceof EnumType) {
                ((EnumType)parameter).setDefaultValue(annotation.value());
            }
        }
    }

    public String getLocalId(Method executableElement, Variable variable) {
        if (executableElement != null) {
            return NameUtils.uncamel((String)executableElement.getName()) + '-' + NameUtils.uncamel((String)variable.getName());
        }
        return "configurable-" + NameUtils.uncamel((String)variable.getName());
    }

    public String getLocalId(Method executableElement) {
        Processor processor = (Processor)executableElement.getAnnotation(Processor.class);
        String localId = processor != null && StringUtils.isNotBlank((String)processor.name()) ? processor.name() : executableElement.getName();
        return NameUtils.uncamel((String)localId);
    }

    public String getFormattedDescription(Variable element) {
        Summary description = (Summary)element.getAnnotation(Summary.class);
        if (description != null && StringUtils.isNotBlank((String)description.value())) {
            return this.formatDescription(description.value());
        }
        if (element instanceof Parameter) {
            return this.formatDescription(element.parent().getJavaDocParameterSummary(element.getName()));
        }
        return this.formatDescription(element.getJavaDocSummary());
    }

    public String getFormattedDescription(Module module) {
        if (StringUtils.isNotBlank((String)module.getDescription())) {
            return module.getDescription();
        }
        return this.formatDescription(module.getJavaDocSummary());
    }

    public String getFormattedCaption(Module module) {
        if (StringUtils.isNotBlank((String)module.getFriendlyName())) {
            return module.getFriendlyName();
        }
        return this.formatCaption(module.getModuleName().replaceAll("-", " "));
    }

    public String getFormattedCaption(Method element) {
        return this.formatCaption(this.getFriendlyName(element));
    }

    public String getFormattedCaption(Variable element) {
        FriendlyName caption = (FriendlyName)element.getAnnotation(FriendlyName.class);
        if (caption != null && StringUtils.isNotBlank((String)caption.value())) {
            return caption.value();
        }
        String friendlyName = NameUtils.friendlyNameFromCamelCase((String)element.getName());
        if (element.asType().isHttpCallback()) {
            return this.formatCaption(friendlyName + " Flow");
        }
        if (!this.isKnownType(element)) {
            return this.formatCaption(friendlyName + " Reference");
        }
        return this.formatCaption(friendlyName);
    }

    public String getFriendlyName(Method element) {
        Processor processor = (Processor)element.getAnnotation(Processor.class);
        if (processor != null && StringUtils.isNotBlank((String)processor.friendlyName())) {
            return processor.friendlyName();
        }
        Source source = (Source)element.getAnnotation(Source.class);
        if (source != null && StringUtils.isNotBlank((String)source.friendlyName())) {
            return source.friendlyName();
        }
        return NameUtils.friendlyNameFromCamelCase((String)element.getName());
    }

    public boolean isKnownType(Variable variable) {
        return variable.asType().isString() || variable.asType().isChar() || variable.asType().isDate() || variable.asType().isDouble() || variable.asType().isFloat() || variable.asType().isLong() || variable.asType().isHttpCallback() || variable.asType().isInteger() || variable.asType().isBigDecimal() || variable.asType().isBigInteger() || variable.asType().isBoolean() || variable.asType().isEnum() || variable.asType().isCollection() || variable.asType().isURL();
    }

    public String getUrl(Module module) {
        return "http://www.mulesoft.org/schema/mule/" + module.getModuleName() + '/';
    }

    public StringAttributeType createStringAttributeType(String caption, String description, String name) {
        StringAttributeType stringAttributeType = new StringAttributeType();
        stringAttributeType.setCaption(this.formatCaption(caption));
        stringAttributeType.setDescription(this.formatDescription(description));
        stringAttributeType.setName(name);
        return stringAttributeType;
    }

    public Group createGroup(String id, String caption) {
        Group group = new Group();
        group.setId(id);
        group.setCaption(this.formatCaption(caption));
        return group;
    }
}

