/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.param.Default;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.EnumElementComparator;
import org.mule.devkit.generation.studio.editor.MuleStudioUtils;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.CollectionAttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.ModeElementType;
import org.mule.devkit.model.studio.ModeType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.ObjectListAttributeType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.StringListAttributeType;
import org.mule.devkit.model.studio.StringMapAttributeType;
import org.mule.devkit.model.studio.TypeChooserType;
import org.mule.util.StringUtils;

public abstract class BaseStudioXmlBuilder {
    public static final String GENERAL_GROUP_NAME = "General";
    public static final String CONNECTION_GROUP_NAME = "Connection";
    public static final String CONNECTION_GROUP_LABEL = "Use these fields to override the credentials defined in the %s connector.";
    protected ObjectFactory objectFactory;
    protected MuleStudioUtils helper;
    protected Module module;
    protected Method method;
    protected String moduleName;
    protected Context context;

    protected BaseStudioXmlBuilder(Context context) {
        this.context = context;
        this.helper = new MuleStudioUtils();
        this.objectFactory = new ObjectFactory();
    }

    protected BaseStudioXmlBuilder(Context context, Module module) {
        this(context);
        this.module = module;
        this.moduleName = module.getModuleName();
    }

    protected Group createGroupWithModeSwitch(List<? extends Method> methods) {
        ModeType modeSwitch = new ModeType();
        modeSwitch.getMode().addAll(this.getModes(methods));
        modeSwitch.setCaption(this.helper.formatCaption("Operation"));
        modeSwitch.setName(StringUtils.capitalize((String)this.moduleName) + " operations to execute");
        modeSwitch.setDescription(this.helper.formatDescription("Operation"));
        modeSwitch.setAlwaysCombo(Boolean.valueOf(true));
        Group group = new Group();
        group.setId(this.module.getModuleName() + "ConnectorGeneric");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupModeSwitch(modeSwitch));
        group.setCaption(this.helper.formatCaption("Generic"));
        return group;
    }

    protected List<ModeElementType> getModes(List<? extends Method> methods) {
        ArrayList<ModeElementType> modes = new ArrayList<ModeElementType>();
        for (Method method : methods) {
            ModeElementType mode = new ModeElementType();
            mode.setModeId("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getLocalId(method));
            mode.setModeLabel(StringUtils.capitalize((String)this.helper.getFriendlyName(method)));
            modes.add(mode);
        }
        return modes;
    }

    protected BaseStudioXmlBuilder(Context context, Method method, Module module) {
        this(context, module);
        this.method = method;
    }

    protected List<AttributeCategory> processMethodParameters() {
        Map<String, AttributeCategory> attributeCategoriesByName = this.processVariableElements(this.getParametersSorted());
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>(attributeCategoriesByName.values());
        if (this.method instanceof ProcessorMethod && ((ProcessorMethod)this.method).canBeUsedInOAuthManagement() && ((ProcessorMethod)this.method).getOAuthModule().getUserIdentifierMethod() != null && ((ProcessorMethod)this.method).isOAuthProtected()) {
            StringAttributeType accessTokenId = new StringAttributeType();
            accessTokenId.setName("accessTokenId");
            accessTokenId.setRequired(Boolean.valueOf(false));
            accessTokenId.setCaption(this.helper.formatCaption("Access Token Id"));
            accessTokenId.setDescription(this.helper.formatDescription("The id of the access token that will be used to authenticate the call"));
            accessTokenId.setJavaType("java.lang.String");
            AttributeCategory attributeCategory = this.getOrCreateAttributeCategory(attributeCategoriesByName, null);
            Group group = this.getGroup(attributeCategory, CONNECTION_GROUP_NAME);
            if (group == null) {
                group = new Group();
                group.setCaption(this.helper.formatCaption(CONNECTION_GROUP_NAME));
                group.setId(StringUtils.uncapitalize((String)CONNECTION_GROUP_NAME));
                attributeCategory.getGroup().add(group);
            }
            group.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)accessTokenId));
        }
        return attributeCategories;
    }

    private Group getDefaultGroup(AttributeCategory attributeCategory) {
        return this.getGroup(attributeCategory, GENERAL_GROUP_NAME);
    }

    private Group getGroup(AttributeCategory attributeCategory, String groupName) {
        if (attributeCategory != null) {
            for (Group group : attributeCategory.getGroup()) {
                if (!StringUtils.uncapitalize((String)groupName).equalsIgnoreCase(group.getId())) continue;
                return group;
            }
        }
        return null;
    }

    protected List<AttributeCategory> processConfigurableFields(Group defaultGroup) {
        Map<String, AttributeCategory> attributeCategoriesByName = this.processVariableElements(this.getConfigurableFieldsSorted());
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>(attributeCategoriesByName.values());
        AttributeCategory attributeCategory = attributeCategoriesByName.get(GENERAL_GROUP_NAME);
        if (attributeCategory != null) {
            attributeCategory.setDescription(this.helper.formatDescription(this.module.getModuleName() + " configuration properties"));
            List groups = attributeCategory.getGroup();
            if (groups.isEmpty()) {
                groups.add(defaultGroup);
            } else {
                groups.add(0, defaultGroup);
            }
        } else {
            attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.getFormattedCaption(this.module));
            attributeCategory.setDescription(this.helper.formatDescription(this.module.getModuleName() + " configuration properties"));
            attributeCategory.getGroup().add(defaultGroup);
            attributeCategories.add(attributeCategory);
        }
        return attributeCategories;
    }

    private Map<String, AttributeCategory> processVariableElements(List<? extends Variable> variableElements) {
        LinkedHashMap<String, Group> groupsByName = new LinkedHashMap<String, Group>();
        LinkedHashMap<String, AttributeCategory> attributeCategoriesByName = new LinkedHashMap<String, AttributeCategory>();
        this.getOrCreateDefaultAttributeCategory(attributeCategoriesByName);
        this.createMetaDataAttributes(groupsByName, attributeCategoriesByName);
        this.processConnectionAttributes(groupsByName, attributeCategoriesByName);
        this.createPoolingProfileAttributes(groupsByName, attributeCategoriesByName);
        this.createReconnectionAttributes(groupsByName, attributeCategoriesByName);
        this.createOAuthConfig(attributeCategoriesByName);
        for (Variable variable : variableElements) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJaxbElement(variable);
            AttributeCategory attributeCategory = this.getOrCreateAttributeCategory(attributeCategoriesByName, (Placement)variable.getAnnotation(Placement.class));
            Group group = this.getOrCreateGroup(groupsByName, variable);
            group.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            if (attributeCategory.getGroup().contains(group)) continue;
            attributeCategory.getGroup().add(group);
        }
        return attributeCategoriesByName;
    }

    protected void createMetaDataAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createReconnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createPoolingProfileAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createOAuthConfig(Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    private AttributeCategory getOrCreateDefaultAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName) {
        return this.getOrCreateAttributeCategory(attributeCategoriesByName, null);
    }

    private AttributeCategory getOrCreateAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName, Placement placement) {
        if (placement == null || StringUtils.isBlank((String)placement.tab())) {
            if (!attributeCategoriesByName.containsKey(GENERAL_GROUP_NAME)) {
                AttributeCategory attributeCategoryGeneral = new AttributeCategory();
                attributeCategoryGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                attributeCategoryGeneral.setDescription(this.helper.formatDescription(GENERAL_GROUP_NAME));
                attributeCategoriesByName.put(GENERAL_GROUP_NAME, attributeCategoryGeneral);
            }
            return attributeCategoriesByName.get(GENERAL_GROUP_NAME);
        }
        String attributeCategoryName = StringUtils.isNotBlank((String)placement.tab()) ? placement.tab() : GENERAL_GROUP_NAME;
        if (!attributeCategoriesByName.containsKey(attributeCategoryName)) {
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.formatCaption(attributeCategoryName));
            attributeCategory.setDescription(this.helper.formatDescription(attributeCategoryName));
            attributeCategoriesByName.put(attributeCategoryName, attributeCategory);
        }
        return attributeCategoriesByName.get(attributeCategoryName);
    }

    private Group getOrCreateGroup(Map<String, Group> groupsByName, Variable parameter) {
        Placement placement;
        Placement placement2 = placement = parameter != null ? (Placement)parameter.getAnnotation(Placement.class) : null;
        if (placement == null || StringUtils.isBlank((String)placement.group())) {
            if (!groupsByName.containsKey(GENERAL_GROUP_NAME)) {
                Group groupGeneral = new Group();
                groupGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                groupGeneral.setId(StringUtils.uncapitalize((String)GENERAL_GROUP_NAME));
                groupsByName.put(GENERAL_GROUP_NAME, groupGeneral);
            }
            return groupsByName.get(GENERAL_GROUP_NAME);
        }
        String groupName = placement.group();
        if (!groupsByName.containsKey(groupName)) {
            Group group = new Group();
            group.setCaption(groupName);
            group.setId(StringUtils.uncapitalize((String)groupName));
            groupsByName.put(groupName, group);
        }
        return groupsByName.get(groupName);
    }

    protected JAXBElement<? extends AttributeType> createJaxbElement(Variable<?> variable) {
        AttributeType attributeType;
        if (variable.isMetaDataKey()) {
            attributeType = this.createTypeChooserType(variable);
        } else if (variable.asType().isEnum()) {
            attributeType = this.createEnumType(variable);
        } else if (this.isListOfMaps(variable) || this.isSimpleList(variable) || this.isSimpleMap(variable) || this.isSimpleSet(variable)) {
            attributeType = this.handleCollectionVariable(variable);
        } else {
            if (variable.asType().isComplexType() && !variable.isRefOnly()) {
                NestedElementReference complexTypeNestedElementReference = this.createNestedElementReference(variable);
                return this.objectFactory.createGroupChildElement(complexTypeNestedElementReference);
            }
            attributeType = this.createAttributeType(variable);
        }
        return this.helper.createJAXBElement(attributeType);
    }

    private AttributeType createTypeChooserType(Variable<?> variable) {
        TypeChooserType type = new TypeChooserType();
        type.setSupportsExpressions(Boolean.valueOf(true));
        type.setAssociatedConfig("config-ref");
        this.helper.setAttributeTypeInfo(variable, (AttributeType)type);
        return type;
    }

    private NestedElementReference createNestedElementReference(Variable parameter) {
        NestedElementReference childElement = new NestedElementReference();
        childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + '/' + NameUtils.uncamel((String)parameter.getName()));
        childElement.setCaption(this.helper.getFormattedCaption(parameter));
        childElement.setAllowMultiple(Boolean.valueOf(false));
        childElement.setInplace(Boolean.valueOf(true));
        childElement.setJavaType(parameter.getJavaType());
        childElement.setRequired(Boolean.valueOf(!parameter.isOptional()));
        return childElement;
    }

    private AttributeType handleCollectionVariable(Variable parameter) {
        StringListAttributeType attributeType;
        if (this.isListOfMaps(parameter)) {
            ObjectListAttributeType objectListAttributeType = new ObjectListAttributeType();
            objectListAttributeType.setRequired(Boolean.valueOf(!parameter.isOptional()));
            objectListAttributeType.setListName(NameUtils.uncamel((String)parameter.getName()));
            objectListAttributeType.setInnerName(NameUtils.uncamel((String)("inner-" + NameUtils.singularize((String)parameter.getName()))));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)objectListAttributeType);
            attributeType = objectListAttributeType;
        } else if (this.isSimpleList(parameter) || this.isSimpleSet(parameter)) {
            StringListAttributeType stringListAttributeTyper = new StringListAttributeType();
            stringListAttributeTyper.setListName(NameUtils.uncamel((String)parameter.getName()));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)stringListAttributeTyper);
            attributeType = stringListAttributeTyper;
        } else {
            StringMapAttributeType stringMapAttributeType = new StringMapAttributeType();
            stringMapAttributeType.setMapName(NameUtils.uncamel((String)parameter.getName()));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)stringMapAttributeType);
            attributeType = stringMapAttributeType;
        }
        attributeType.setRequired(Boolean.valueOf(!parameter.isOptional()));
        return attributeType;
    }

    private void setCommonCollectionAttributes(Variable parameter, CollectionAttributeType collectionAttributeType) {
        collectionAttributeType.setItemName(NameUtils.uncamel((String)NameUtils.singularize((String)parameter.getName())));
        collectionAttributeType.setLocalName(this.helper.getLocalId(this.method, parameter));
        collectionAttributeType.setCaption(this.helper.getFormattedCaption(parameter));
        collectionAttributeType.setJavaType(parameter.getJavaType());
        Default annotation = (Default)parameter.getAnnotation(Default.class);
        if (annotation != null) {
            collectionAttributeType.setDefaultValue(annotation.value());
        }
        if (this.method != null) {
            collectionAttributeType.setDescription(this.helper.formatDescription(this.method.getJavaDocParameterSummary(parameter.getName())));
        } else {
            collectionAttributeType.setDescription(this.helper.formatDescription(parameter.getJavaDocSummary()));
        }
    }

    private boolean isListOfMaps(Variable parameter) {
        return parameter.asType().isArrayOrList() && !parameter.getTypeArguments().isEmpty() && ((Type)parameter.getTypeArguments().get(0)).isMap();
    }

    private boolean isSimpleMap(Variable parameter) {
        return parameter.asType().isMap() && (parameter.getTypeArguments().isEmpty() || !((Type)parameter.getTypeArguments().get(1)).isCollection());
    }

    private boolean isSimpleList(Variable parameter) {
        return parameter.asType().isArrayOrList() && (parameter.getTypeArguments().isEmpty() || !((Type)parameter.getTypeArguments().get(0)).isCollection());
    }

    private boolean isSimpleSet(Variable parameter) {
        return parameter.asType().isSet() && (parameter.getTypeArguments().isEmpty() || !((Type)parameter.getTypeArguments().get(0)).isCollection());
    }

    private List<Parameter> getParametersSorted() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.method.getParameters());
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            if (!((Parameter)iterator.next()).shouldBeIgnored()) continue;
            iterator.remove();
        }
        Collections.sort(parameters, new VariableComparator());
        return parameters;
    }

    private AttributeType createAttributeType(Variable parameter) {
        AttributeType attributeType = this.helper.createAttributeTypeIgnoreEnumsAndCollections(parameter);
        if (attributeType != null) {
            this.helper.setAttributeTypeInfo(parameter, attributeType);
        }
        return attributeType;
    }

    protected List<AttributeType> getConnectionAttributes(ManagedConnectionModule module) {
        ArrayList<AttributeType> parameters = new ArrayList<AttributeType>();
        for (Parameter connectAttributeType : module.getConnectMethod().getParameters()) {
            AttributeType parameter = this.helper.createAttributeTypeIgnoreEnumsAndCollections((Variable)connectAttributeType);
            this.helper.setAttributeTypeInfo((Variable)connectAttributeType, parameter);
            parameter.setRequired(Boolean.valueOf(false));
            parameters.add(parameter);
        }
        return parameters;
    }

    private EnumType createEnumType(Variable<?> variable) {
        EnumType enumType = new EnumType();
        enumType.setSupportsExpressions(Boolean.valueOf(true));
        enumType.setAllowsCustom(Boolean.valueOf(true));
        this.helper.setAttributeTypeInfo(variable, (AttributeType)enumType);
        for (Identifiable enumMember : ((org.mule.devkit.model.EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            EnumElement enumElement = new EnumElement();
            enumElement.setValue(enumConstant);
            enumType.getOption().add(enumElement);
        }
        Collections.sort(enumType.getOption(), new EnumElementComparator());
        return enumType;
    }

    private List<Field> getConfigurableFieldsSorted() {
        List configurableFields = this.module.getConfigurableFields();
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }
}

