/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StudioSiteXmlGenerator
extends AbstractMuleStudioGenerator
implements MultiModuleGenerator {
    private static final String CATEGORY_XML = "category.xml";
    public static final String STUDIO_PREFIX = "org.mule.tooling.ui.extension.";
    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_SITE_XML, Product.STUDIO_FEATURE_NAME);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> module) {
        return true;
    }

    public void generate(List<Module> module) throws GenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element site = document.createElement("site");
            document.appendChild(site);
            Element feature = document.createElement("feature");
            String featureId = STUDIO_PREFIX + this.removeMuleModulePrefix(this.ctx().getMavenInformation().getArtifactId());
            feature.setAttribute("id", featureId);
            this.ctx().registerProduct(Product.STUDIO_FEATURE_NAME, (Object)featureId);
            String category1 = this.ctx().getMavenInformation().getCategory();
            String categoryAsString = this.getCategoryAsString(module.get(0), category1);
            Element category = document.createElement("category");
            category.setAttribute("name", this.ctx().getMavenInformation().getGroupId());
            feature.appendChild(category);
            Element categoryDef = document.createElement("category-def");
            categoryDef.setAttribute("name", this.ctx().getMavenInformation().getGroupId());
            categoryDef.setAttribute("label", categoryAsString);
            site.appendChild(feature);
            site.appendChild(categoryDef);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            String featureFile = CATEGORY_XML;
            StreamResult result = new StreamResult(this.ctx().getCodeModel().getCodeWriter().openBinary(null, featureFile));
            transformer.transform(source, result);
            this.ctx().registerProduct(Product.STUDIO_SITE_XML, (Object)featureFile);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", (Throwable)e);
        }
    }

    private String getCategoryAsString(Module module, String category1) {
        String categoryAsString = category1 == null ? (module instanceof ManagedConnectionModule || module instanceof OAuthModule ? "Mule Cloud Connectors" : "Mule Modules") : category1;
        return categoryAsString;
    }

    private String removeMuleModulePrefix(String artifactId) {
        String muleModulePrefix = "mule-module-";
        if (artifactId.startsWith(muleModulePrefix)) {
            return artifactId.substring(muleModulePrefix.length());
        }
        return artifactId;
    }
}

