/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.config;

import java.util.Arrays;
import java.util.List;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.security.oauth.callback.DefaultSaveAccessTokenCallback;

@JustOnce
public class DefaultSaveAccessTokenCallbackFactoryGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Object[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK_FACTORY);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion().equals((Object)OAuthVersion.V10A);
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass factory = this.getDefaultSaveAccessTokenCallbackFactoryClass(module);
        GeneratedMethod getObjectType = factory.method(1, (Type)this.ref(Class.class), "getObjectType");
        getObjectType.body()._return(this.ref(DefaultSaveAccessTokenCallback.class).dotclass());
        GeneratedMethod getObject = factory.method(1, (Type)this.ref(Object.class), "getObject");
        getObject._throws(this.ref(Exception.class));
        GeneratedVariable callbackVariable = getObject.body().decl((Type)this.ref(DefaultSaveAccessTokenCallback.class), "callback", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultSaveAccessTokenCallback.class)));
        getObject.body().add((Statement)callbackVariable.invoke("setMessageProcessor").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (GeneratedExpression)ExpressionFactory._super().invoke("getObject"))));
        getObject.body()._return((GeneratedExpression)callbackVariable);
    }

    private GeneratedClass getDefaultSaveAccessTokenCallbackFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".config");
        GeneratedClass clazz = pkg._class("SaveAccessTokenCallbackFactoryBean");
        clazz._extends(this.ref(MessageProcessorChainFactoryBean.class));
        this.ctx().registerProduct(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK_FACTORY, (Object)clazz);
        return clazz;
    }
}

