/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.adapter;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.common.security.oauth.AuthorizationParameter;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireAccessTokenException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.utils.NameUtils;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;

public class OAuth2ClientAdapterGenerator
extends AbstractOAuthAdapterGenerator {
    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthAdapter = this.getOAuthAdapterClass(module, "OAuth2Adapter", this.ref(OAuth2Adapter.class));
        oauthAdapter._implements(OAuth2Adapter.class);
        Object oAuthCapability = module.manager().oauth2Component().isPresent() ? (OAuthCapability)module.manager().oauth2Component().get() : (OAuthModule)module;
        GeneratedClass oauthManagerClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedField oauthManager = oauthAdapter.field(4, (Type)this.ref(OAuth2Manager.class).narrow(OAuth2Adapter.class), "oauthManager");
        this.generateConstructor(module, oauthAdapter, oauthManager, OAuth2Manager.class, OAuth2Adapter.class);
        this.accessTokenPatternConstant(oauthAdapter, (OAuthCapability)oAuthCapability);
        this.refreshTokenPatternConstant(oauthAdapter, (OAuthCapability)oAuthCapability);
        this.expirationPatternConstant(oauthAdapter, (OAuthCapability)oAuthCapability);
        GeneratedField name = oauthAdapter.field(4, (Type)this.ref(String.class), "name");
        oauthAdapter.getter(name);
        oauthAdapter.setterOverride(name);
        this.generateOnNoTokenPolicyField(oauthAdapter);
        this.authorizationCodeField(oauthAdapter);
        this.refreshTokenField(oauthAdapter);
        GeneratedField redirectUri = oauthAdapter.field(1, (Type)this.ref(String.class), "redirectUri");
        GeneratedField authorizationUrl = this.generateAuthorizationUrlField(oauthAdapter);
        GeneratedField accessTokenUrl = this.generateAccessTokenUrlField(oauthAdapter);
        this.expirationField(oauthAdapter, (OAuthCapability)oAuthCapability);
        this.generateInitialiseMethod(oauthAdapter);
        GeneratedField logger = FieldBuilder.newLoggerField((GeneratedClass)oauthAdapter);
        this.generateOAuth2AuthorizeMethod(oauthAdapter, oauthManager);
        this.generateFetchAccessTokenMethod(oauthAdapter, oauthManager);
        this.generateRefreshAccessTokenMethod(oauthAdapter, oauthManager);
        this.generateHasTokenExpiredMethod(oauthAdapter, (OAuthCapability)oAuthCapability);
        this.generateResetMethod((OAuthCapability)oAuthCapability, oauthAdapter);
        this.generateHasBeenAuthorizedMethod((OAuthCapability)oAuthCapability, oauthAdapter);
        this.generateRegexpGetters(oauthAdapter);
        this.generateOAuth2ConnectorInterfaceImpl(module, (OAuthCapability)oAuthCapability, oauthAdapter);
        this.generateGetProcessTemplateMethod(oauthAdapter, (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module), oauthManager);
    }

    protected void generateConstructor(Module module, GeneratedClass oauthAdapter, GeneratedField oauthManager, Class OAuthManager, Class OAuthAdapter) {
        GeneratedMethod constructor = oauthAdapter.constructor(1);
        GeneratedVariable oauthManagerParam = constructor.param((Type)this.ref(OAuthManager).narrow(this.ref(OAuthAdapter)), "oauthManager");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)oauthManager), (GeneratedExpression)oauthManagerParam);
        if (OAuth2StrategyUtilsResolver.hasOAuth2Component((Module)module)) {
            constructor.body().invoke(NameUtils.buildSetter((String)((Field)module.getConnectionStrategy().get()).getName())).arg((GeneratedExpression)ExpressionFactory._new((Type)this.ref(((OAuth2Component)module.manager().oauth2Component().get()).asTypeMirror())));
        }
    }

    protected void generateHasBeenAuthorizedMethod(OAuthCapability oAuthCapability, GeneratedClass oauthAdapter) {
        GeneratedMethod hasBeenAuthorized = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "hasBeenAuthorized");
        hasBeenAuthorized._throws(this.ref(NotAuthorizedException.class));
        GeneratedBlock ifAccessTokenIsNull = hasBeenAuthorized.body()._if(ExpressionFactory.invoke((String)"getAccessToken").isNull())._then();
        GeneratedInvocation newNotAuthorizedException = ExpressionFactory._new((TypeReference)this.ref(NotAuthorizedException.class));
        newNotAuthorizedException.arg("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        ifAccessTokenIsNull._throw((GeneratedExpression)newNotAuthorizedException);
    }

    private void generateOAuth2ConnectorInterfaceImpl(Module module, OAuthCapability oAuthModule, GeneratedClass oauthAdapter) {
        GeneratedMethod getAuthorizationParameters = oauthAdapter.method(1, (Type)this.ref(Set.class).narrow(this.ref(AuthorizationParameter.class).narrow(this.ctx().getCodeModel().wildcard())), "getAuthorizationParameters");
        getAuthorizationParameters.annotate(Override.class);
        ArrayList<GeneratedVariable> generatedVariableList = new ArrayList<GeneratedVariable>();
        for (OAuthAuthorizationParameter parameter : oAuthModule.getAuthorizationParameters()) {
            GeneratedVariable param = getAuthorizationParameters.body().decl((Type)this.ref(AuthorizationParameter.class).narrow(String.class), parameter.getName(), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(AuthorizationParameter.class).narrow(String.class)).arg(ExpressionFactory.lit((String)parameter.getName())).arg(ExpressionFactory.lit((String)parameter.getDescription())).arg(ExpressionFactory.lit((boolean)parameter.isOptional())).arg(ExpressionFactory.lit((String)parameter.getDefaultValue())).arg(this.ref(parameter.getType().asTypeMirror()).dotclass()));
            generatedVariableList.add(param);
        }
        GeneratedVariable result = getAuthorizationParameters.body().decl((Type)this.ref(Set.class).narrow(this.ref(AuthorizationParameter.class).narrow(this.ctx().getCodeModel().wildcard())), "result", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashSet.class).narrow(this.ref(AuthorizationParameter.class).narrow(this.ctx().getCodeModel().wildcard()))));
        for (GeneratedVariable param : generatedVariableList) {
            getAuthorizationParameters.body().add((Statement)result.invoke("add").arg((GeneratedExpression)param));
        }
        getAuthorizationParameters.body()._return((GeneratedExpression)result);
        GeneratedMethod getConsumerKeyMethod = oauthAdapter.method(1, (Type)this.ref(String.class), "getConsumerKey");
        getConsumerKeyMethod.annotate(Override.class);
        GeneratedExpression oauth2ComponentReference = OAuth2StrategyUtilsResolver.getOAuthConcreteComponent((Module)module, (GeneratedExpression)ExpressionFactory._super(), (Context)this.ctx());
        getConsumerKeyMethod.body()._return((GeneratedExpression)oauth2ComponentReference.invoke(oAuthModule.getConsumerKeyField().getGetter().getName()));
        GeneratedMethod setConsumerKey = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setConsumerKey");
        GeneratedVariable valueCK = setConsumerKey.param((Type)this.ref(String.class), "value");
        setConsumerKey.annotate(Override.class);
        setConsumerKey.body().add((Statement)oauth2ComponentReference.invoke(oAuthModule.getConsumerKeyField().getSetter().getName()).arg((GeneratedExpression)valueCK));
        GeneratedMethod getConsumerSecret = oauthAdapter.method(1, (Type)this.ref(String.class), "getConsumerSecret");
        getConsumerSecret.annotate(Override.class);
        getConsumerSecret.body()._return((GeneratedExpression)oauth2ComponentReference.invoke(oAuthModule.getConsumerSecretField().getGetter().getName()));
        GeneratedMethod setConsumerSecret = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setConsumerSecret");
        GeneratedVariable valueCS = setConsumerSecret.param((Type)this.ref(String.class), "value");
        setConsumerSecret.annotate(Override.class);
        setConsumerSecret.body().add((Statement)oauth2ComponentReference.invoke(oAuthModule.getConsumerSecretField().getSetter().getName()).arg((GeneratedExpression)valueCS));
        GeneratedMethod getAccessToken = oauthAdapter.method(1, (Type)this.ref(String.class), "getAccessToken");
        getAccessToken.annotate(Override.class);
        getAccessToken.body()._return((GeneratedExpression)oauth2ComponentReference.invoke(oAuthModule.getAccessTokenField().getGetter().getName()));
        GeneratedMethod setAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setAccessToken");
        GeneratedVariable valueAT = setAccessToken.param((Type)this.ref(String.class), "value");
        setAccessToken.annotate(Override.class);
        setAccessToken.body().add((Statement)oauth2ComponentReference.invoke(oAuthModule.getAccessTokenField().getSetter().getName()).arg((GeneratedExpression)valueAT));
        GeneratedMethod getScope = oauthAdapter.method(1, (Type)this.ref(String.class), "getScope");
        getScope.annotate(Override.class);
        if (oAuthModule.getScopeField() != null) {
            getScope.body()._return((GeneratedExpression)oauth2ComponentReference.invoke(oAuthModule.getScopeField().getGetter().getName()));
        } else {
            getScope.body()._return(ExpressionFactory.lit((String)""));
        }
        if (oAuthModule.getScopeField() != null) {
            GeneratedMethod setScope = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setScope");
            GeneratedVariable valueS = setScope.param((Type)this.ref(String.class), "value");
            setScope.body().add((Statement)oauth2ComponentReference.invoke(oAuthModule.getScopeField().getSetter().getName()).arg((GeneratedExpression)valueS));
        }
        GeneratedMethod postAuth = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "postAuth");
        postAuth.annotate(Override.class);
        if (oAuthModule.getPostAuthorizationMethod() != null) {
            postAuth._throws(Exception.class);
            postAuth.body().add((Statement)oauth2ComponentReference.invoke(oAuthModule.getPostAuthorizationMethod().getName()));
        }
    }

    private void generateRegexpGetters(GeneratedClass oauthAdapter) {
        oauthAdapter.direct("@Override\n    public String getAccessTokenRegex() {\n        return ACCESS_CODE_PATTERN.pattern();\n    }\n\n    @Override\n    public String getExpirationRegex() {\n        return EXPIRATION_TIME_PATTERN.pattern();\n    }\n\n    @Override\n    public String getRefreshTokenRegex() {\n        return REFRESH_TOKEN_PATTERN.pattern();\n    }\n\n    @Override\n    public String getVerifierRegex() {\n        return oauthVerifier;\n    }");
    }

    protected GeneratedField refreshTokenField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("refreshToken").getterAndSetter().build();
    }

    private void accessTokenPatternConstant(GeneratedClass oauthAdapter, OAuthCapability oAuthCapability) {
        GeneratedField accessTokenPattern = new FieldBuilder(oauthAdapter).type(Pattern.class).name("ACCESS_CODE_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(oAuthCapability.getAccessTokenRegex())).build();
        GeneratedMethod getter = oauthAdapter.getter(accessTokenPattern);
        getter.name("getAccessCodePattern");
        getter.annotate(Override.class);
    }

    private void refreshTokenPatternConstant(GeneratedClass oauthAdapter, OAuthCapability oAuthCapability) {
        GeneratedField refreshTokenPattern = new FieldBuilder(oauthAdapter).type(Pattern.class).name("REFRESH_TOKEN_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(oAuthCapability.getRefreshTokenRegex())).build();
        GeneratedMethod getter = oauthAdapter.getter(refreshTokenPattern);
        getter.name("getRefreshTokenPattern");
        getter.annotate(Override.class);
    }

    private void expirationPatternConstant(GeneratedClass oauthAdapter, OAuthCapability oAuthCapability) {
        if (!StringUtils.isEmpty((String)oAuthCapability.getExpirationRegex())) {
            GeneratedField expirationPattern = new FieldBuilder(oauthAdapter).type(Pattern.class).name("EXPIRATION_TIME_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(oAuthCapability.getExpirationRegex())).build();
            GeneratedMethod getter = oauthAdapter.getter(expirationPattern);
            getter.name("getExpirationTimePattern");
            getter.annotate(Override.class);
        }
    }

    private void expirationField(GeneratedClass oauthAdapter, OAuthCapability oAuthCapability) {
        if (!StringUtils.isEmpty((String)oAuthCapability.getExpirationRegex())) {
            new FieldBuilder(oauthAdapter).type(Date.class).name("expiration").setter().build();
        }
    }

    private void generateRefreshAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod refreshAccessTokenMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "refreshAccessToken");
        GeneratedVariable accessTokenId = refreshAccessTokenMethod.param(String.class, "accessTokenId");
        refreshAccessTokenMethod._throws(this.ref(UnableToAcquireAccessTokenException.class));
        refreshAccessTokenMethod.annotate(Override.class);
        refreshAccessTokenMethod.body().add((Statement)oauthManager.invoke("refreshAccessToken").arg(ExpressionFactory._this()).arg((GeneratedExpression)accessTokenId));
    }

    private void generateFetchAccessTokenMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod fetchAccessToken = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "fetchAccessToken");
        GeneratedVariable redirectUri = fetchAccessToken.param((Type)this.ref(String.class), "redirectUri");
        fetchAccessToken._throws(this.ref(UnableToAcquireAccessTokenException.class));
        fetchAccessToken.body().add((Statement)oauthManager.invoke("fetchAccessToken").arg(ExpressionFactory._this()).arg((GeneratedExpression)redirectUri));
    }

    private void generateHasTokenExpiredMethod(GeneratedClass oauthAdapter, OAuthCapability oAuthCapability) {
        GeneratedMethod hasTokenExpired = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "hasTokenExpired");
        if (!StringUtils.isEmpty((String)oAuthCapability.getExpirationRegex())) {
            GeneratedField expirationDate = (GeneratedField)oauthAdapter.fields().get("expiration");
            hasTokenExpired.body()._return(Op.cand((GeneratedExpression)expirationDate.isNotNull(), (GeneratedExpression)expirationDate.invoke("before").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Date.class)))));
        } else {
            hasTokenExpired.body()._return(ExpressionFactory.FALSE);
        }
    }

    private void generateResetMethod(OAuthCapability oAuthCapability, GeneratedClass oauthAdapter) {
        GeneratedMethod reset = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "reset");
        if (!StringUtils.isEmpty((String)oAuthCapability.getExpirationRegex())) {
            reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("expiration"), ExpressionFactory._null());
        }
        reset.body().assign((AssignmentTarget)oauthAdapter.fields().get("oauthVerifier"), ExpressionFactory._null());
        reset.body().invoke("setAccessToken").arg(ExpressionFactory._null());
    }

    protected void generateGetProcessTemplateMethod(GeneratedClass oauthAdapterClass, GeneratedClass capabilitiesAdapterClass, GeneratedField oauthManager) {
        GeneratedMethod getProcessTemplate = oauthAdapterClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        getProcessTemplate.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)));
    }
}

