/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth.process;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.oauth.AbstractOAuthAdapterGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthStateGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_ADAPTER);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion().equals((Object)OAuthVersion.V2);
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oauthStateClass = this.getOAuthStateClass(module);
        oauthStateClass.annotate(Deprecated.class);
        GeneratedField accessToken = oauthStateClass.field(1, (Type)this.ref(String.class), "accessToken");
        oauthStateClass.getter(accessToken);
        oauthStateClass.setter(accessToken);
        GeneratedField authorizationUrl = oauthStateClass.field(1, (Type)this.ref(String.class), "authorizationUrl");
        oauthStateClass.getter(authorizationUrl);
        oauthStateClass.setter(authorizationUrl);
        GeneratedField accessTokenUrl = oauthStateClass.field(1, (Type)this.ref(String.class), "accessTokenUrl");
        oauthStateClass.getter(accessTokenUrl);
        oauthStateClass.setter(accessTokenUrl);
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            GeneratedField accessTokenSecret = oauthStateClass.field(1, (Type)this.ref(String.class), "accessTokenSecret");
            oauthStateClass.getter(accessTokenSecret);
            oauthStateClass.setter(accessTokenSecret);
            GeneratedField requestTokenUrl = oauthStateClass.field(1, (Type)this.ref(String.class), "requestTokenUrl");
            oauthStateClass.getter(requestTokenUrl);
            oauthStateClass.setter(requestTokenUrl);
        }
        if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2) {
            GeneratedField refreshToken = oauthStateClass.field(1, (Type)this.ref(String.class), "refreshToken");
            oauthStateClass.getter(refreshToken);
            oauthStateClass.setter(refreshToken);
        }
        for (OAuthCallbackParameterField field : ((OAuthModule)module).getCallbackParameters()) {
            GeneratedField callbackField = oauthStateClass.field(1, this.ref(field.asTypeMirror()), field.getName());
            oauthStateClass.getter(callbackField);
            oauthStateClass.setter(callbackField);
        }
    }

    protected GeneratedClass getOAuthStateClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass oauthAdapter = pkg._class(1, module.getClassName() + "OAuthState");
        oauthAdapter._implements(Serializable.class);
        this.ctx().registerProduct(Product.OAUTH_STATE, (Identifiable)module, (Object)oauthAdapter);
        oauthAdapter.javadoc().add((Object)"Serializable class used to save and restore OAuth state from ");
        oauthAdapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        return oauthAdapter;
    }
}

