/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.javadoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.streaming.PagingConfiguration;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDocAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    private Map<String, String> exampleFilesByName = new HashMap<String, String>();

    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        if (!this.hasComment((Identifiable)module)) {
            this.addMessage((Identifiable)module, (DevkitNotification)Message.CLASS_MISSING_SUMMARY, module.getQualifiedName().toString());
        }
        if (!module.hasJavaDocTag("author")) {
            this.addMessage((Identifiable)module, (DevkitNotification)Message.CLASS_MISSING_AUTHOR_TAG, module.getQualifiedName().toString());
        }
        for (Field variable : module.getConfigurableFields()) {
            if (this.hasComment((Identifiable)variable)) continue;
            this.addMessage((Identifiable)variable, (DevkitNotification)Message.FIELD_MISSING_DESCRIPTION, variable.getName());
        }
        for (ProcessorMethod method : module.getProcessorMethods()) {
            this.validateMethod(module, (Method)method);
        }
        for (ProcessorMethod method : module.getSourceMethods()) {
            this.validateMethod(module, (Method)method);
        }
        for (ProcessorMethod method : module.getTransformerMethods()) {
            this.validateMethod(module, (Method)method);
        }
        if (module instanceof ManagedConnectionModule) {
            ManagedConnectionModule managedConnectionModule = (ManagedConnectionModule)module;
            this.validateAllParameters((Method)managedConnectionModule.getConnectMethod());
            this.validateAllParameters(managedConnectionModule.getDisconnectMethod());
        }
    }

    private void validateAllParameters(Method method) throws AnnotationVerificationException {
        for (Parameter variable : method.getParameters()) {
            boolean needsJavadoc = this.needsJavadoc(variable, method);
            if (!needsJavadoc || this.hasParameterComment(variable.getName(), variable.parent())) continue;
            this.addMessage((Identifiable)variable, (DevkitNotification)Message.METHOD_PARAMETER_MISSING_JAVADOC, variable.getName(), method.getName());
        }
    }

    private boolean needsJavadoc(Parameter variable, Method method) {
        if (method instanceof ProcessorMethod) {
            ProcessorMethod processorMethod = (ProcessorMethod)method;
            boolean injectParameters = processorMethod.hasAnnotation(Inject.class);
            String className = ((Object)variable.asTypeMirror()).toString();
            if (injectParameters && (className.startsWith(MuleMessage.class.getName()) || className.startsWith(MuleEvent.class.getName()))) {
                return false;
            }
            if (processorMethod.isPaged() && className.startsWith(PagingConfiguration.class.getName())) {
                return false;
            }
        }
        return true;
    }

    private void validateMethod(Module module, Method method) throws AnnotationVerificationException {
        if (!this.hasComment((Identifiable)method)) {
            this.addMessage((Identifiable)method, (DevkitNotification)Message.METHOD_MISSING_DESCRIPTION, method.getName());
        }
        if (!(((Object)method.getReturnType()).toString().equals("void") || ((Object)method.getReturnType()).toString().contains("StopSourceCallback") || method.hasJavaDocTag("return"))) {
            this.addMessage((Identifiable)method, (DevkitNotification)Message.METHOD_MISSING_RETURN_TYPE_DOCUMENTATION, method.getName());
        }
        this.validateThrowComments(method);
        this.validateSampleTag((Method<Type>)method);
        this.validateAllParameters(method);
    }

    private void validateThrowComments(Method method) throws AnnotationVerificationException {
        List thrownTypes = method.getThrownTypes();
        for (TypeMirror thrownType : thrownTypes) {
            String exceptionClassName;
            String fullyQualifiedExceptionClassName = ((Object)thrownType).toString();
            if (!StringUtils.isEmpty((String)method.getThrowsComment(fullyQualifiedExceptionClassName)) || !StringUtils.isEmpty((String)method.getThrowsComment(exceptionClassName = fullyQualifiedExceptionClassName.substring(fullyQualifiedExceptionClassName.lastIndexOf(".") + 1)))) continue;
            this.addMessage((Identifiable)method, (DevkitNotification)Message.METHOD_MISSING_DOCUMENTATION_FOR_THROWN_EXCEPTIONS, method.getName(), fullyQualifiedExceptionClassName);
        }
    }

    private boolean hasComment(Identifiable element) {
        String comment = element.getJavaDocSummary();
        return StringUtils.isNotBlank((String)comment);
    }

    private boolean hasParameterComment(String paramName, Identifiable element) {
        String comment = element.getJavaDocParameterSummary(paramName);
        return StringUtils.isNotBlank((String)comment);
    }

    protected void validateSampleTag(Method<Type> method) throws AnnotationVerificationException {
        if (!method.hasJavaDocTag("sample.xml")) {
            this.addMessage((Identifiable)method, (DevkitNotification)Message.METHDO_MISSING_EXAMPLE, method.getName());
            return;
        }
        String sample = method.getJavaDocTagContent("sample.xml");
        String[] split = sample.split(" ");
        if (split.length != 2) {
            this.addMessage((Identifiable)method, (DevkitNotification)Message.SAMPLE_JAVADOC_TAG_MALFORMED, method.getName());
            return;
        }
        String pathToExamplesFile = split[0];
        String exampleName = split[1];
        String sourcePath = ((Type)method.parent()).getPathToSourceFile();
        for (int packageCount = StringUtils.countMatches((String)((Type)method.parent()).getQualifiedName().toString(), (String)".") + 1; packageCount > 0; --packageCount) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf("/"));
        }
        boolean found = false;
        try {
            String examplesFileContent = this.getExamplesFile(pathToExamplesFile, sourcePath);
            String beginTag = String.format("<!-- BEGIN_INCLUDE(%s) -->", exampleName);
            String endTag = String.format("<!-- END_INCLUDE(%s) -->", exampleName);
            if (examplesFileContent.contains(beginTag) && examplesFileContent.contains(endTag)) {
                found = true;
            }
            if (!found) {
                this.addMessage((Identifiable)method, (DevkitNotification)Message.SAMPLE_PROCESSOR_XML_DOES_NOT_EXIST, exampleName, method.getName());
            }
        }
        catch (IOException e) {
            found = false;
            this.addMessage((Identifiable)method, (DevkitNotification)Message.SAMPLE_FILE_CONTAINING_EXAMPLES_DOES_NOT_EXIST, pathToExamplesFile, method.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExamplesFile(String pathToExamplesFile, String sourcePath) throws FileNotFoundException {
        if (!this.exampleFilesByName.containsKey(pathToExamplesFile)) {
            File docFile = new File(sourcePath, pathToExamplesFile);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(docFile);
                this.exampleFilesByName.put(pathToExamplesFile, IOUtils.toString((InputStream)inputStream));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return this.exampleFilesByName.get(pathToExamplesFile);
    }

    protected void addMessage(Identifiable element, DevkitNotification message, Object ... args) {
        this.getGatherer().error(element, message, args);
    }
}

