/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.javadoc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDocAnnotationVerifier
implements ModuleAnnotationVerifier {
    private Map<String, String> exampleFilesByName = new HashMap<String, String>();

    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        if (!this.hasComment((Identifiable)module)) {
            throw new AnnotationVerificationException((Identifiable)module, "Class " + module.getQualifiedName().toString() + " is not properly documented. A summary is missing.");
        }
        if (!module.hasJavaDocTag("author")) {
            throw new AnnotationVerificationException((Identifiable)module, "Class " + module.getQualifiedName().toString() + " needs to have an @author tag.");
        }
        for (Field variable : module.getConfigurableFields()) {
            if (this.hasComment((Identifiable)variable)) continue;
            throw new AnnotationVerificationException((Identifiable)variable, "Field " + variable.getName() + " is not properly documented. The description is missing.");
        }
        for (ProcessorMethod method : module.getProcessorMethods()) {
            this.validateMethod(module, (Method)method);
        }
        for (ProcessorMethod method : module.getSourceMethods()) {
            this.validateMethod(module, (Method)method);
        }
        for (ProcessorMethod method : module.getTransformerMethods()) {
            this.validateMethod(module, (Method)method);
        }
        if (module instanceof ManagedConnectionModule) {
            ManagedConnectionModule managedConnectionModule = (ManagedConnectionModule)module;
            this.validateAllParameters((Method<? extends Module>)managedConnectionModule.getConnectMethod());
            this.validateAllParameters((Method<? extends Module>)managedConnectionModule.getDisconnectMethod());
        }
    }

    private void validateAllParameters(Method<? extends Module> method) throws AnnotationVerificationException {
        for (Parameter variable : method.getParameters()) {
            if (this.hasParameterComment(variable.getName(), variable.parent())) continue;
            throw new AnnotationVerificationException((Identifiable)variable, "Parameter " + variable.getName() + " of method " + method.getName() + " is not properly documented. A matching @param in the method documentation was not found. ");
        }
    }

    private void validateMethod(Module module, Method method) throws AnnotationVerificationException {
        if (!this.hasComment((Identifiable)method)) {
            throw new AnnotationVerificationException((Identifiable)method, "Method " + method.getName() + " is not properly documented. A description of what it can do is missing.");
        }
        if (!(method.getReturnType().toString().equals("void") || method.getReturnType().toString().contains("StopSourceCallback") || method.hasJavaDocTag("return"))) {
            throw new AnnotationVerificationException((Identifiable)module, "The return type of a non-void method must be documented. Method " + method.getName() + " is at fault. Missing @return.");
        }
        this.validateThrowComments(method);
        if (this.exampleDoesNotExist((Method<Type>)method)) {
            throw new AnnotationVerificationException((Identifiable)module, "Method " + method.getName() + " does not have the example pointed by the {@sample.xml} tag");
        }
        this.validateAllParameters((Method<? extends Module>)method);
    }

    private void validateThrowComments(Method method) throws AnnotationVerificationException {
        List thrownTypes = method.getThrownTypes();
        for (TypeMirror thrownType : thrownTypes) {
            String exceptionClassName;
            String fullyQualifiedExceptionClassName = thrownType.toString();
            if (!StringUtils.isEmpty((String)method.getThrowsComment(fullyQualifiedExceptionClassName)) || !StringUtils.isEmpty((String)method.getThrowsComment(exceptionClassName = fullyQualifiedExceptionClassName.substring(fullyQualifiedExceptionClassName.lastIndexOf(".") + 1)))) continue;
            throw new AnnotationVerificationException((Identifiable)method, "Every exception declared in the 'throws' clause needs to be documented. Method: " + method.getName() + " Exception: " + fullyQualifiedExceptionClassName);
        }
    }

    private boolean hasComment(Identifiable element) {
        String comment = element.getJavaDocSummary();
        return StringUtils.isNotBlank((String)comment);
    }

    private boolean hasParameterComment(String paramName, Identifiable element) {
        String comment = element.getJavaDocParameterSummary(paramName);
        return StringUtils.isNotBlank((String)comment);
    }

    protected boolean exampleDoesNotExist(Method<Type> method) throws AnnotationVerificationException {
        if (!method.hasJavaDocTag("sample.xml")) {
            throw new AnnotationVerificationException(method, "Method " + method.getName() + " does not contain an example using {@sample.xml} tag.");
        }
        String sample = method.getJavaDocTagContent("sample.xml");
        String[] split = sample.split(" ");
        if (split.length != 2) {
            throw new AnnotationVerificationException(method, "Check @sample.xml javadoc tag because is not well formed for method: " + method.getName());
        }
        String pathToExamplesFile = split[0];
        String exampleName = split[1];
        String sourcePath = ((Type)method.parent()).getPathToSourceFile();
        for (int packageCount = StringUtils.countMatches((String)((Type)method.parent()).getQualifiedName().toString(), (String)".") + 1; packageCount > 0; --packageCount) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf("/"));
        }
        boolean found = false;
        try {
            String examplesFileContent = this.getExamplesFile(pathToExamplesFile, sourcePath);
            String beginTag = String.format("<!-- BEGIN_INCLUDE(%s) -->", exampleName);
            String endTag = String.format("<!-- END_INCLUDE(%s) -->", exampleName);
            if (examplesFileContent.contains(beginTag) && examplesFileContent.contains(endTag)) {
                found = true;
            }
        }
        catch (IOException e) {
            found = false;
        }
        return !found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExamplesFile(String pathToExamplesFile, String sourcePath) throws FileNotFoundException {
        if (!this.exampleFilesByName.containsKey(pathToExamplesFile)) {
            File docFile = new File(sourcePath, pathToExamplesFile);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(docFile);
                this.exampleFilesByName.put(pathToExamplesFile, IOUtils.toString((InputStream)inputStream));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return this.exampleFilesByName.get(pathToExamplesFile);
    }
}

