/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.metadata;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;

public class MetaDataModuleVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind().equals((Object)ModuleKind.GENERIC);
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        Set allMetaDataCategoryComponents = module.manager().metaDataCategoryComponents();
        if (!allMetaDataCategoryComponents.isEmpty()) {
            ArrayList<String> metaDataCategoriesNames = new ArrayList<String>();
            for (MetaDataCategoryComponent metaDataCategory : allMetaDataCategoryComponents) {
                metaDataCategoriesNames.add(metaDataCategory.getName());
            }
            gatherer.error((Identifiable)module, (DevkitNotification)Message.METADATASCOPE_CANNOT_BE_USED_ON_MODULES, new Object[]{module.getName(), StringUtils.join(metaDataCategoriesNames, (String)", ")});
        }
    }
}

