/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import org.mule.api.annotations.Query;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;

public class QueryAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getProcessorMethods().stream().anyMatch(ProcessorMethod::hasQuery);
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (ProcessorMethod pm : module.getProcessorMethods()) {
            if (!pm.hasQuery()) continue;
            gatherer.warn((Identifiable)pm, (DevkitNotification)Message.DEPRECATED_ANNOTATION_ON_EXTENSION, new Object[]{Query.class.getName()});
            this.queryValidation(module, gatherer, pm);
        }
    }

    private void queryValidation(Module module, NotificationGatherer gatherer, ProcessorMethod pm) {
        Parameter query = pm.getQueryParameter();
        if (query.asType().isString()) {
            return;
        }
        if (query.asType().isDsqlQueryObject() && !module.hasQueryTranslator()) {
            gatherer.note((Identifiable)query, (DevkitNotification)Message.DSQLQUERY_TYPE_DISABLES_NATIVE_QUERY_USAGE, new Object[0]);
            return;
        }
        gatherer.error((Identifiable)query, (DevkitNotification)Message.QUERY_MUST_BE_STRING_OR_DSQLQUERY, new Object[0]);
    }
}

