/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.operation;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractExtensionMigrationGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.runtime.api.message.MuleMessage;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.Operations;

public class OperationsGenerator
extends AbstractExtensionMigrationGenerator {
    private Map<String, GeneratedClass> metadataResolvers = new HashedMap();

    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_CONFIG_FACTORY, Product.EXTENSION_CONNECTION_PROVIDER, Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER, Product.EXTENSION_OPERATIONS_ADAPTER, Product.EXTENSION_METADATA_OUTPUT_GENERATOR);
    }

    public List<Product> produces() {
        return Collections.singletonList(Product.EXTENSION_OPERATIONS_ADAPTER);
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass extension = this.getExtensionClass();
        GeneratedClass operationsClass = this.ctx().getCodeModel()._package(extension.getPackage().name() + ".operation")._class(1, StringUtils.capitalize((String)module.getName()) + "Operations");
        extension.annotate(Operations.class).param("value", (org.mule.devkit.model.code.Type)operationsClass);
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.generateOperationFromProcessorMethod(module, operationsClass, processorMethod);
        }
        this.ctx().registerProduct(Product.EXTENSION_OPERATIONS_ADAPTER, (Object)operationsClass);
    }

    private void generateOperationFromProcessorMethod(Module module, GeneratedClass operationsClass, ProcessorMethod processorMethod) {
        GeneratedMethod operation = operationsClass.method(1, this.ref(processorMethod.getReturnType()), processorMethod.getName());
        this.addExceptionHandlingToOperation(processorMethod, operation);
        GeneratedVariable connectorLib = operation.body().decl(this.ref(module.asTypeMirror()), "connector", (GeneratedExpression)this._new((Type)module));
        this.generateSetConnectorConfig(module, operation, connectorLib);
        this.addLifecycleToOperation(module, processorMethod, operation, connectorLib);
        this.addJavaDoc((org.mule.devkit.model.Documentable)processorMethod, (Documentable)operation);
        this.ctx().registerProduct(Product.EXTENSION_OPERATIONS_METHOD_ADAPTER, (Identifiable)processorMethod, (Object)operation);
    }

    private void addExceptionHandlingToOperation(ProcessorMethod processorMethod, GeneratedMethod operation) {
        this.addExceptionEnricher(processorMethod, operation);
        for (TypeMirror e : processorMethod.getThrownTypes()) {
            operation._throws(this.ctx().getCodeModel().refClass(e.toString()));
        }
    }

    private void addLifecycleToOperation(Module module, ProcessorMethod processorMethod, GeneratedMethod operation, GeneratedVariable connectorLib) {
        this.addLifecycleInvoke((Optional<Method>)module.startable(), operation, connectorLib);
        GeneratedInvocation processorInvocation = this.getConnectorProcessorInvokation(processorMethod, operation, connectorLib);
        if (!this.returnsVoid(processorMethod)) {
            GeneratedVariable result = operation.body().decl(this.ref(processorMethod.getReturnType()), "result", (GeneratedExpression)processorInvocation);
            this.addLifecycleInvoke((Optional<Method>)module.stoppable(), operation, connectorLib);
            operation.body()._return((GeneratedExpression)result);
        } else {
            operation.body().add((Statement)processorInvocation);
            this.addLifecycleInvoke((Optional<Method>)module.stoppable(), operation, connectorLib);
        }
    }

    private GeneratedInvocation getConnectorProcessorInvokation(ProcessorMethod processorMethod, GeneratedMethod operation, GeneratedVariable connectorLib) {
        GeneratedInvocation processorInvocation = connectorLib.invoke(processorMethod.getName());
        for (Parameter originParam : processorMethod.getParameters()) {
            this.addConnectorProcessorInvokeParameter(operation, processorInvocation, (Parameter<Method<Type>>)originParam);
            this.addJavaDocForParameter((org.mule.devkit.model.Documentable)processorMethod, (Documentable)operation, originParam.getName());
        }
        return processorInvocation;
    }

    private void addConnectorProcessorInvokeParameter(GeneratedMethod operation, GeneratedInvocation processorInvocation, Parameter<Method<Type>> originParam) {
        if (originParam.asTypeMirror().toString().startsWith("MuleMessage")) {
            GeneratedVariable newMuleMessage = operation.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), originParam.getName());
            processorInvocation.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(originParam.asTypeMirror()), (GeneratedExpression)newMuleMessage));
        } else {
            GeneratedVariable newParam = operation.param(this.ref(originParam.asTypeMirror()), originParam.getName());
            this.annotateParameter((Variable)originParam, newParam);
            processorInvocation.arg((GeneratedExpression)newParam);
            this.updateComplexFieldSource(originParam.asType(), Arrays.asList("configuration-replacements.json"));
        }
    }

    private void addLifecycleInvoke(Optional<Method> lifecycleMethod, GeneratedMethod operation, GeneratedVariable connectorLib) {
        if (lifecycleMethod.isPresent()) {
            operation.body().add((Statement)connectorLib.invoke(((Method)lifecycleMethod.get()).getName()));
        }
    }

    private void addExceptionEnricher(ProcessorMethod method, GeneratedMethod operation) {
        if (method.getExceptionHandler().isPresent() || !method.reconnectOn().isEmpty()) {
            GeneratedClass enricherClass = (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER, (Identifiable)method);
            operation.annotate(OnException.class).param("value", (org.mule.devkit.model.code.Type)enricherClass);
        }
    }
}

