/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.operation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.api.MuleContext;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.api.extension.MigratedExtensionSourceCallback;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractExtensionMigrationGenerator;
import org.mule.devkit.model.Documentable;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AnnotationArrayMember;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceContext;

public class OperationSourcesGenerator
extends AbstractExtensionMigrationGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_CONFIG_FACTORY, Product.EXTENSION_CONNECTION_PROVIDER);
    }

    public List<Product> produces() {
        return Collections.singletonList(Product.EXTENSION_SOURCES_ADAPTER);
    }

    public boolean shouldGenerate(Module module) {
        return module.hasSources();
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass extension = this.getExtensionClass();
        AnnotationArrayMember sourcesAnnotation = extension.annotate(Sources.class).paramArray("value");
        module.getSourceMethods().forEach(s -> this.generateSource(module, (SourceMethod)s, extension, sourcesAnnotation));
    }

    private void generateSource(Module module, SourceMethod sourceMethod, GeneratedClass extension, AnnotationArrayMember sourcesAnnotation) {
        GeneratedClass sourceClass = this.ctx().getCodeModel()._package(extension.getPackage().name() + ".source")._class(1, sourceMethod.getCapitalizedName() + "Source");
        sourcesAnnotation.param((Type)sourceClass);
        sourceClass._extends(this.ref(Source.class).narrow(new Class[]{Object.class, Attributes.class}));
        this.addJavaDoc((Documentable)sourceMethod, (org.mule.devkit.model.code.Documentable)sourceClass);
        GeneratedField executor = sourceClass.field(4, ExecutorService.class, "executor");
        GeneratedField context = sourceClass.field(4, MuleContext.class, "context");
        context.annotate(Inject.class);
        sourceMethod.getParameters().stream().filter(p -> !p.getJavaType().endsWith("SourceCallback")).forEach(p -> this.generateSourceParameter(sourceClass, sourceMethod, (Parameter<Method<org.mule.devkit.model.Type>>)p));
        this.generateStartMethod(module, sourceClass, sourceMethod, executor, context);
        this.generateStopMethod(sourceClass, executor);
    }

    private void generateStartMethod(Module module, GeneratedClass sourceClass, SourceMethod sourceMethod, GeneratedField executor, GeneratedField context) {
        GeneratedMethod start = sourceClass.method(1, (Type)sourceClass.owner().VOID, "start");
        start.annotate(Override.class);
        GeneratedMethod createRunnableMethod = this.generateCreateRunnableMethod(module, sourceClass, sourceMethod, context);
        GeneratedVariable connector = start.body().decl(this.ref(module.asTypeMirror()), "connector", (GeneratedExpression)this._new((org.mule.devkit.model.Type)module));
        this.generateConnectorConfigSetter(module, start, sourceClass, connector);
        this.generateLifeCycleStart(module, start, connector);
        GeneratedInvocation invokeRunnableCreation = ExpressionFactory._this().invoke(createRunnableMethod).arg((GeneratedExpression)ExpressionFactory._this().ref("sourceContext")).arg((GeneratedExpression)connector);
        GeneratedVariable runnableInstance = start.body().decl((Type)this.ref(Runnable.class), "runnable", (GeneratedExpression)invokeRunnableCreation);
        if (sourceMethod.isPolling()) {
            start.body().assign((AssignmentTarget)executor, (GeneratedExpression)this.ref(Executors.class).staticInvoke("newScheduledThreadPool").arg(ExpressionFactory.lit((int)1)));
            start.body().invoke((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ScheduledExecutorService.class), (GeneratedExpression)executor), "scheduleAtFixedRate").arg((GeneratedExpression)runnableInstance).arg(ExpressionFactory.lit((int)0)).arg(ExpressionFactory.lit((long)sourceMethod.getPollingPeriod())).arg((GeneratedExpression)this.ref(TimeUnit.class).staticRef("MILLISECONDS"));
        } else {
            start.body().assign((AssignmentTarget)executor, (GeneratedExpression)this.ref(Executors.class).staticInvoke("newSingleThreadExecutor"));
            start.body().invoke((GeneratedExpression)executor, "execute").arg((GeneratedExpression)runnableInstance);
        }
    }

    private GeneratedMethod generateCreateRunnableMethod(Module module, GeneratedClass sourceClass, SourceMethod sourceMethod, GeneratedField context) {
        GeneratedMethod createRunnableMethod = sourceClass.method(4, Runnable.class, "createRunnable");
        GeneratedVariable sourceContext = createRunnableMethod.param(8, (Type)this.ref(SourceContext.class), "sourceContext");
        GeneratedVariable connectorLib = createRunnableMethod.param(8, this.ref((org.mule.devkit.model.Type)module), "connectorLib");
        GeneratedClass runnable = this.ctx().getCodeModel().anonymousClass(this.ref(Runnable.class));
        GeneratedMethod run = runnable.method(1, (Type)this.ctx().getCodeModel().VOID, "run");
        GeneratedTry _try = run.body()._try();
        GeneratedInvocation newSourceCallbackInvocation = ExpressionFactory._new((TypeReference)this.ref(MigratedExtensionSourceCallback.class)).arg((GeneratedExpression)sourceContext).arg((GeneratedExpression)context);
        GeneratedVariable sourceCallback = _try.body().decl((Type)this.ref(SourceCallback.class), "sourceCallback", (GeneratedExpression)newSourceCallbackInvocation);
        GeneratedInvocation sourceMethodInvocation = connectorLib.invoke(sourceMethod.getName());
        sourceMethod.getParameters().stream().forEach(p -> sourceMethodInvocation.arg((GeneratedExpression)(p.getJavaType().endsWith("SourceCallback") ? sourceCallback : ExpressionFactory.ref((String)p.getName()))));
        _try.body().add((Statement)sourceMethodInvocation);
        GeneratedCatchBlock _catch = _try._catch(this.ref(Exception.class));
        GeneratedVariable exception = _catch.param("e");
        GeneratedInvocation getExceptionCallback = sourceContext.invoke("getExceptionCallback");
        _catch.body().invoke((GeneratedExpression)getExceptionCallback, "onException").arg((GeneratedExpression)exception);
        createRunnableMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)runnable));
        return createRunnableMethod;
    }

    private void generateStopMethod(GeneratedClass clazz, GeneratedField executor) {
        GeneratedMethod stop = clazz.method(1, (Type)clazz.owner().VOID, "stop");
        stop.annotate(Override.class);
        stop.body().invoke((GeneratedExpression)executor, "shutdownNow");
        GeneratedTry _try = stop.body()._try();
        _try.body().invoke((GeneratedExpression)executor, "awaitTermination").arg(ExpressionFactory.lit((int)3)).arg((GeneratedExpression)this.ref(TimeUnit.class).staticRef("SECONDS"));
        GeneratedCatchBlock _catch = _try._catch(this.ref(InterruptedException.class));
        GeneratedVariable exception = _catch.param("e");
        _catch.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)exception));
    }

    private void generateSourceParameter(GeneratedClass sourceClass, SourceMethod sourceMethod, Parameter<Method<org.mule.devkit.model.Type>> param) {
        GeneratedField field = sourceClass.field(4, this.ref(param.asTypeMirror()), param.getName());
        field.annotate(org.mule.runtime.extension.api.annotation.Parameter.class);
        if (param.isOptional()) {
            GeneratedAnnotationUse annotate = field.annotate(Optional.class);
            if (param.hasDefaultValue()) {
                annotate.param("defaultValue", param.getDefaultValue());
            }
        }
        this.addJavaDocForParameter((Documentable)sourceMethod, (org.mule.devkit.model.code.Documentable)field, param.getName());
    }

    private void generateConnectorConfigSetter(Module module, GeneratedMethod method, GeneratedClass sourceClass, GeneratedVariable connectorLib) {
        if (module.getConfigStrategy().isPresent()) {
            GeneratedExpression configReference = module.manager().hasConnectionManagement() ? this.generateConnectionParam(module, sourceClass) : this.generateConfigFactoryParam(module, sourceClass);
            method.body().invoke((GeneratedExpression)connectorLib, this.setterName((Field)module.getConfigStrategy().get())).arg(configReference);
        }
    }

    private void generateLifeCycleStart(Module module, GeneratedMethod method, GeneratedVariable connectorLib) {
        if (module.startable().isPresent()) {
            method.body().add((Statement)connectorLib.invoke(((Method)module.startable().get()).getName()));
        }
    }

    private GeneratedExpression generateConfigFactoryParam(Module module, GeneratedClass sourceClass) {
        GeneratedField config = sourceClass.field(4, this.getStrategyBaseType(module), "config");
        config.annotate(UseConfig.class);
        return config;
    }

    private GeneratedExpression generateConnectionParam(Module module, GeneratedClass sourceClass) {
        GeneratedField connection = sourceClass.field(4, this.getStrategyBaseType(module), "connection");
        connection.annotate(Connection.class);
        return connection;
    }
}

