/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.metadata.AbstractMetadataGenerator;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;

public class MetadataResolverGenerator
extends AbstractMetadataGenerator {
    public boolean shouldGenerate(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> p.hasStaticKeyInputMetaData()) || module.manager().metaDataCategoryComponents().stream().anyMatch(c -> c.getMetaDataRetrieverMethod() != null);
    }

    public void generate(Module module) throws GenerationException {
        HashMap resolvers = new HashMap();
        module.manager().metaDataCategoryComponents().stream().forEach(c -> {
            GeneratedClass resolverClass = this.generateResolverClass(module, this.ctx(), this.getCategoryResolverName((MetaDataCategoryComponent)c));
            this.addJavaDoc((org.mule.devkit.model.Documentable)c, (Documentable)resolverClass);
            this.generateGetCategory(module, (MetaDataCategoryComponent)c, resolverClass);
            this.generateGetIdForCategory(resolverClass);
            resolvers.put(c.getName(), resolverClass);
            this.updatedOldSource(c.asType(), Arrays.asList("metadata-replacements.json"));
        });
        module.getProcessorMethods().stream().filter(p -> p.getMetaDataCategoryComponent().isPresent()).forEach(p -> {
            MetaDataCategoryComponent categoryComponent = (MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get();
            this.generateContentResolverForStaticKeyProcessor(module, resolvers, (ProcessorMethod)p, categoryComponent);
            this.ctx().registerProduct(Product.METADATA_RESOLVER, (Object)resolvers);
        });
    }

    private void generateContentResolverForStaticKeyProcessor(Module module, Map<String, GeneratedClass> resolvers, ProcessorMethod processorMethod, MetaDataCategoryComponent categoryComponent) {
        GeneratedClass resolverClass;
        String resolverName;
        if (processorMethod.hasStaticKeyInputMetaData() && !resolvers.containsKey(this.getInputStaticKeyResolverName(categoryComponent, processorMethod))) {
            resolverName = this.getInputStaticKeyResolverName(categoryComponent, processorMethod);
            resolverClass = this.generateResolverForInputStaticKey(module, categoryComponent, processorMethod);
            resolverClass = this.generateAuxiliaryMethodsForStaticKey(module, categoryComponent, resolverClass, this.getInputMetadataStaticKey(processorMethod).type());
            resolvers.put(resolverName, resolverClass);
        }
        if (processorMethod.hasStaticKeyOutputMetaData() && !resolvers.containsKey(this.getOutputStaticKeyResolverName(categoryComponent, processorMethod))) {
            resolverName = this.getOutputStaticKeyResolverName(categoryComponent, processorMethod);
            resolverClass = this.generateResolverForOutputStaticKey(module, categoryComponent, processorMethod);
            resolverClass = this.generateAuxiliaryMethodsForStaticKey(module, categoryComponent, resolverClass, this.getOutputMetadataStaticKey(processorMethod).type());
            resolvers.put(resolverName, resolverClass);
        }
    }

    private GeneratedClass generateAuxiliaryMethodsForStaticKey(Module module, MetaDataCategoryComponent categoryComponent, GeneratedClass resolverClass, String staticKeyType) {
        this.generateGetCategory(module, categoryComponent, resolverClass);
        this.generateGetIDForStaticKey(resolverClass, staticKeyType);
        return resolverClass;
    }

    private GeneratedClass generateResolverForInputStaticKey(Module module, MetaDataCategoryComponent categoryComponent, ProcessorMethod processorMethod) {
        return this.generateResolverClass(module, this.ctx(), this.getInputStaticKeyResolverName(categoryComponent, processorMethod));
    }

    private GeneratedClass generateResolverForOutputStaticKey(Module module, MetaDataCategoryComponent categoryComponent, ProcessorMethod processorMethod) {
        return this.generateResolverClass(module, this.ctx(), this.getOutputStaticKeyResolverName(categoryComponent, processorMethod));
    }

    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_METADATA_CLASS_GENERATOR);
    }
}

