/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.metadata.AbstractMetadataGenerator;
import org.mule.devkit.generation.extension.metadata.DynamicResolverInvoke;
import org.mule.devkit.generation.extension.metadata.ResolverInvoke;
import org.mule.devkit.generation.extension.metadata.StaticKeyResolverInvoke;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.resolving.MetadataOutputResolver;

public class MetadataOutputResolverGenerator
extends AbstractMetadataGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_METADATA_CLASS_GENERATOR);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_METADATA_OUTPUT_GENERATOR);
    }

    public boolean shouldGenerate(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> p.hasStaticKeyOutputMetaData()) || module.manager().metaDataCategoryComponents().stream().anyMatch(c -> c.getMetaDataOutputRetrieverMethod() != null);
    }

    public void generate(Module module) throws GenerationException {
        Map resolvers = (Map)this.ctx().getProduct(Product.METADATA_RESOLVER);
        HashSet resolversProcessedInThisStage = new HashSet();
        module.manager().metaDataCategoryComponents().stream().filter(c -> !resolversProcessedInThisStage.contains(c.getName())).forEach(c -> this.generateOutputResolver(resolvers, resolversProcessedInThisStage, (MetaDataCategoryComponent)c, c.getName(), new DynamicResolverInvoke()));
        module.getProcessorMethods().stream().filter(p -> p.getMetaDataCategoryComponent().isPresent()).filter(p -> p.hasStaticKeyOutputMetaData() && !resolversProcessedInThisStage.contains(this.getOutputStaticKeyResolverName((MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get(), (ProcessorMethod)p))).forEach(p -> this.generateOutputResolver(resolvers, resolversProcessedInThisStage, (MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get(), this.getOutputStaticKeyResolverName((MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get(), (ProcessorMethod)p), new StaticKeyResolverInvoke()));
        this.ctx().registerProduct(Product.METADATA_RESOLVER, (Object)resolvers);
    }

    private void generateOutputResolver(Map<String, GeneratedClass> resolvers, Set<String> resolversProcessedInThisStage, MetaDataCategoryComponent categoryComponent, String resolverName, ResolverInvoke resolverInvoke) {
        GeneratedClass resolverClass = resolvers.get(resolverName);
        this.generateOutputResolver(categoryComponent, resolverClass, resolverInvoke);
        resolvers.put(resolverName, resolverClass);
        resolversProcessedInThisStage.add(resolverName);
    }

    private void generateOutputResolver(MetaDataCategoryComponent categoryComponent, GeneratedClass generatedClass, ResolverInvoke resolverInvoke) {
        generatedClass._implements(this.ref(MetadataOutputResolver.class));
        GeneratedMethod generatedMethod = this.generateMetadataTypeRetrieverMethod(generatedClass, "getOutputMetadata");
        GeneratedVariable metadataContext = generatedMethod.param((Type)this.ref(MetadataContext.class), "metadataContext");
        GeneratedVariable metadataKey = generatedMethod.param((Type)this.ref(MetadataKey.class), "metadataKey");
        generatedMethod.body().add(ExpressionFactory.inlineComment((String)"TODO: Type mismatch left intentionally. Manual migration needed from Metadata to the new MetadataType"));
        if (categoryComponent.getMetaDataOutputRetrieverMethod() != null) {
            Method outputRetriever = categoryComponent.getMetaDataOutputRetrieverMethod();
            resolverInvoke.generateInvoke(generatedMethod, metadataContext, metadataKey, outputRetriever.getName());
            this.addJavaDoc((org.mule.devkit.model.Documentable)outputRetriever, (Documentable)generatedMethod);
        } else if (categoryComponent.getMetaDataRetrieverMethod() != null) {
            Method contentRetriever = categoryComponent.getMetaDataRetrieverMethod();
            resolverInvoke.generateInvoke(generatedMethod, metadataContext, metadataKey, contentRetriever.getName());
            this.addJavaDoc((org.mule.devkit.model.Documentable)contentRetriever, (Documentable)generatedMethod);
        }
    }
}

