/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections.map.HashedMap;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.metadata.AbstractMetadataGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;

public class MetadataOperationGenerator
extends AbstractMetadataGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_OPERATIONS_ADAPTER, Product.EXTENSION_METADATA_OUTPUT_GENERATOR, Product.EXTENSION_METADATA_CLASS_GENERATOR, Product.EXTENSION_METADATA_KEY_GENERATOR, Product.EXTENSION_METADATA_CONTENT_GENERATOR);
    }

    public List<Product> produces() {
        return Collections.singletonList(Product.EXTENSION_OPERATIONS_METADATA_ADAPTER);
    }

    public boolean shouldGenerate(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> p.hasMetaDataScope());
    }

    public void generate(Module module) throws GenerationException {
        Map resolvers = (Map)this.ctx().getProduct(Product.METADATA_RESOLVER);
        if (module.manager().metaDataCategoryComponent().isPresent()) {
            GeneratedClass extension = (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ADAPTER);
            this.addMetadataResolversToExtension(extension, (MetaDataCategoryComponent)module.manager().metaDataCategoryComponent().get(), resolvers);
        }
        module.getProcessorMethods().stream().filter(p -> p.getMetaDataCategoryComponent().isPresent()).forEach(p -> {
            GeneratedMethod operation = (GeneratedMethod)this.ctx().getProduct(Product.EXTENSION_OPERATIONS_METHOD_ADAPTER, (Identifiable)p);
            this.addMetadataResolversToOperation((ProcessorMethod)p, operation, module, (MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get(), resolvers);
        });
    }

    private void addMetadataResolversToExtension(GeneratedClass extension, MetaDataCategoryComponent categoryComponent, Map<String, GeneratedClass> generatedResolvers) {
        GeneratedAnnotationUse metadataAnnotation = extension.annotate(MetadataScope.class);
        String resolverName = categoryComponent.getName();
        metadataAnnotation.param("keysResolver", (Type)generatedResolvers.get(resolverName));
        metadataAnnotation.param("contentResolver", (Type)generatedResolvers.get(resolverName));
        metadataAnnotation.param("outputResolver", (Type)generatedResolvers.get(resolverName));
    }

    private void addMetadataResolversToOperation(ProcessorMethod processorMethod, GeneratedMethod operation, Module module, MetaDataCategoryComponent categoryComponent, Map<String, GeneratedClass> generatedResolvers) {
        HashedMap operationResolvers = new HashedMap();
        this.addKeyResolver(processorMethod, categoryComponent, generatedResolvers, (Map<String, GeneratedClass>)operationResolvers);
        this.addContentResolver(processorMethod, categoryComponent, generatedResolvers, (Map<String, GeneratedClass>)operationResolvers);
        this.addOutputResolver(processorMethod, categoryComponent, generatedResolvers, (Map<String, GeneratedClass>)operationResolvers);
        if (this.checkRedundantMetadataAnnotation(module, (Map<String, GeneratedClass>)operationResolvers)) {
            return;
        }
        if (!operationResolvers.isEmpty()) {
            GeneratedAnnotationUse metadataAnnotation = operation.annotate(MetadataScope.class);
            operationResolvers.keySet().stream().forEach(arg_0 -> MetadataOperationGenerator.lambda$addMetadataResolversToOperation$6(metadataAnnotation, (Map)operationResolvers, arg_0));
        }
    }

    private void addKeyResolver(ProcessorMethod processorMethod, MetaDataCategoryComponent categoryComponent, Map<String, GeneratedClass> generatedResolvers, Map<String, GeneratedClass> operationResolvers) {
        if (this.shouldAddDynamicKeyResolver(processorMethod)) {
            operationResolvers.put("keysResolver", generatedResolvers.get(categoryComponent.getName()));
        }
    }

    private void addContentResolver(ProcessorMethod processorMethod, MetaDataCategoryComponent categoryComponent, Map<String, GeneratedClass> generatedResolvers, Map<String, GeneratedClass> operationResolvers) {
        if (this.shouldAddStaticKeyContentResolver(processorMethod)) {
            operationResolvers.put("contentResolver", generatedResolvers.get(this.getInputStaticKeyResolverName(categoryComponent, processorMethod)));
        } else if (this.shouldAddContentResolver(processorMethod)) {
            operationResolvers.put("contentResolver", generatedResolvers.get(categoryComponent.getName()));
        }
    }

    private void addOutputResolver(ProcessorMethod processorMethod, MetaDataCategoryComponent categoryComponent, Map<String, GeneratedClass> generatedResolvers, Map<String, GeneratedClass> operationResolvers) {
        if (this.shouldAddStaticKeyOutputResolver(processorMethod)) {
            operationResolvers.put("outputResolver", generatedResolvers.get(this.getOutputStaticKeyResolverName(categoryComponent, processorMethod)));
        } else if (this.shouldAddOutputResolver(processorMethod)) {
            operationResolvers.put("outputResolver", generatedResolvers.get(categoryComponent.getName()));
        }
    }

    private boolean checkRedundantMetadataAnnotation(Module module, Map<String, GeneratedClass> resolvers) {
        if (!module.manager().metaDataCategoryComponent().isPresent()) {
            return false;
        }
        GeneratedClass extensionMetadataResolver = (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_METADATA_FACTORY, (Identifiable)module.manager().metaDataCategoryComponent().get());
        return resolvers.keySet().stream().allMatch(k -> ((GeneratedClass)resolvers.get(k)).equals((Object)extensionMetadataResolver)) && resolvers.size() == 3;
    }

    private boolean shouldAddDynamicKeyResolver(ProcessorMethod processorMethod) {
        boolean result = processorMethod.getInputMetaDataKeyParameter() != null;
        result |= processorMethod.getOutputMetaDataKeyParameter() != null;
        return result &= !processorMethod.hasStaticKeyMetaData();
    }

    private boolean shouldAddStaticKeyContentResolver(ProcessorMethod processorMethod) {
        return processorMethod.hasStaticKeyInputMetaData();
    }

    private boolean shouldAddStaticKeyOutputResolver(ProcessorMethod processorMethod) {
        return processorMethod.hasStaticKeyOutputMetaData();
    }

    private boolean shouldAddContentResolver(ProcessorMethod processorMethod) {
        boolean result = processorMethod.getInputMetaDataKeyParameter() != null;
        result &= processorMethod.getPayloadParameter() != null;
        return result &= !processorMethod.hasStaticKeyInputMetaData();
    }

    private boolean shouldAddOutputResolver(ProcessorMethod processorMethod) {
        TypeMirror returnType = processorMethod.getReturnType();
        boolean result = processorMethod.getOutputMetaDataKeyParameter() != null;
        result &= !processorMethod.hasStaticKeyOutputMetaData();
        return result &= !returnType.toString().equals("void");
    }

    private static /* synthetic */ void lambda$addMetadataResolversToOperation$6(GeneratedAnnotationUse metadataAnnotation, Map operationResolvers, String k) {
        metadataAnnotation.param(k, (Type)operationResolvers.get(k));
    }
}

