/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.MetaDataKey;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.metadata.AbstractMetadataGenerator;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataKeysResolver;

public class MetadataKeyResolverGenerator
extends AbstractMetadataGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_METADATA_CLASS_GENERATOR);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_METADATA_KEY_GENERATOR);
    }

    public boolean shouldGenerate(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> !p.hasStaticKeyInputMetaData()) || module.manager().metaDataCategoryComponents().stream().anyMatch(c -> c.getMetaDataKeyRetrieverMethod() != null);
    }

    public void generate(Module module) throws GenerationException {
        Map resolvers = (Map)this.ctx().getProduct(Product.METADATA_RESOLVER);
        HashSet resolversProcessedInThisStage = new HashSet();
        module.manager().metaDataCategoryComponents().stream().filter(c -> c.getMetaDataRetrieverMethod() != null).forEach(c -> {
            String resolverName = c.getName();
            GeneratedClass resolverClass = (GeneratedClass)resolvers.get(resolverName);
            this.generateKeyResolver((MetaDataCategoryComponent)c, resolverClass);
            resolvers.put(resolverName, resolverClass);
            resolversProcessedInThisStage.add(resolverName);
        });
        module.getProcessorMethods().stream().filter(p -> p.getMetaDataCategoryComponent().isPresent()).filter(p -> this.shouldAddDynamicKeyResolver((ProcessorMethod)p) && !resolversProcessedInThisStage.contains(((MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get()).getName())).forEach(p -> {
            MetaDataCategoryComponent categoryComponent = (MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get();
            String resolverName = categoryComponent.getName();
            GeneratedClass resolverClass = (GeneratedClass)resolvers.get(resolverName);
            this.generateKeyResolver(categoryComponent, resolverClass);
            resolvers.put(resolverName, resolverClass);
            resolversProcessedInThisStage.add(resolverName);
        });
        this.ctx().registerProduct(Product.METADATA_RESOLVER, (Object)resolvers);
    }

    private void generateKeyResolver(MetaDataCategoryComponent categoryComponent, GeneratedClass generatedClass) {
        Method keyRetriever = categoryComponent.getMetaDataKeyRetrieverMethod();
        generatedClass._implements(this.ref(MetadataKeysResolver.class));
        GeneratedMethod generatedMethod = generatedClass.method(1, (Type)this.ref(List.class).narrow(MetadataKey.class), "getMetadataKeys");
        generatedMethod.annotate(Override.class);
        GeneratedVariable metadataContext = generatedMethod.param((Type)this.ref(MetadataContext.class), "metadataContext");
        GeneratedVariable wrappedKeys = this.addMetadataKeyRetrieverAdapter(generatedMethod, ExpressionFactory.invoke((String)"getCategory").arg((GeneratedExpression)metadataContext).invoke(keyRetriever.getName()));
        generatedMethod.body()._return((GeneratedExpression)wrappedKeys);
        this.addJavaDoc((org.mule.devkit.model.Documentable)keyRetriever, (Documentable)generatedMethod);
    }

    private GeneratedVariable addMetadataKeyRetrieverAdapter(GeneratedMethod method, GeneratedInvocation listOfOldKeys) {
        GeneratedVariable keys = method.body().decl((Type)this.ref(List.class).narrow(this.ref(MetadataKey.class)), "keys", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(MetadataKey.class)));
        GeneratedForEach forLoop = method.body().forEach((Type)this.ref(MetaDataKey.class), "oldMetadataKey", (GeneratedExpression)listOfOldKeys);
        forLoop.body().add((Statement)keys.invoke("add").arg((GeneratedExpression)this.ref(MetadataKeyBuilder.class).staticInvoke("newKey").arg((GeneratedExpression)forLoop.var().invoke("getId")).invoke("build")));
        return keys;
    }

    public boolean shouldAddDynamicKeyResolver(ProcessorMethod processorMethod) {
        boolean result = processorMethod.getInputMetaDataKeyParameter() != null;
        result |= processorMethod.getOutputMetaDataKeyParameter() != null;
        return result &= !processorMethod.hasStaticKeyMetaData();
    }
}

