/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.metadata.AbstractMetadataGenerator;
import org.mule.devkit.generation.extension.metadata.DynamicResolverInvoke;
import org.mule.devkit.generation.extension.metadata.ResolverInvoke;
import org.mule.devkit.generation.extension.metadata.StaticKeyResolverInvoke;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.resolving.MetadataContentResolver;

public class MetadataContentResolverGenerator
extends AbstractMetadataGenerator {
    public boolean shouldGenerate(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> p.hasStaticKeyInputMetaData()) || module.manager().metaDataCategoryComponents().stream().anyMatch(c -> c.getMetaDataRetrieverMethod() != null);
    }

    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_METADATA_CLASS_GENERATOR);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_METADATA_CONTENT_GENERATOR);
    }

    private GeneratedMethod generateContentMethod(MetaDataCategoryComponent categoryComponent, GeneratedClass generatedClass, ResolverInvoke resolverInvoke) {
        Method contentRetriever = categoryComponent.getMetaDataRetrieverMethod();
        generatedClass._implements(MetadataContentResolver.class);
        GeneratedMethod generatedMethod = this.generateMetadataTypeRetrieverMethod(generatedClass, "getContentMetadata");
        GeneratedVariable metadataContext = generatedMethod.param((Type)this.ref(MetadataContext.class), "metadataContext");
        GeneratedVariable metadataKey = generatedMethod.param((Type)this.ref(MetadataKey.class), "metadataKey");
        generatedMethod.body().add(ExpressionFactory.inlineComment((String)"TODO: Type mismatch left intentionally. Manual migration needed from Metadata to the new MetadataType"));
        resolverInvoke.generateInvoke(generatedMethod, metadataContext, metadataKey, contentRetriever.getName());
        this.addJavaDoc((org.mule.devkit.model.Documentable)contentRetriever, (Documentable)generatedMethod);
        return generatedMethod;
    }

    public void generate(Module module) {
        Map resolvers = (Map)this.ctx().getProduct(Product.METADATA_RESOLVER);
        HashSet generatedResolvers = new HashSet();
        module.manager().metaDataCategoryComponents().stream().filter(c -> c.getMetaDataRetrieverMethod() != null).forEach(c -> {
            GeneratedClass resolverClass = (GeneratedClass)resolvers.get(c.getName());
            this.generateContentMethod((MetaDataCategoryComponent)c, resolverClass, new DynamicResolverInvoke());
            resolvers.put(c.getName(), resolverClass);
        });
        module.getProcessorMethods().stream().filter(p -> p.getMetaDataCategoryComponent().isPresent()).filter(p -> p.hasStaticKeyInputMetaData() && !generatedResolvers.contains(this.getInputStaticKeyResolverName((MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get(), (ProcessorMethod)p))).forEach(p -> {
            MetaDataCategoryComponent categoryComponent = (MetaDataCategoryComponent)p.getMetaDataCategoryComponent().get();
            String resolverName = this.getInputStaticKeyResolverName(categoryComponent, (ProcessorMethod)p);
            GeneratedClass resolverClass = (GeneratedClass)resolvers.get(resolverName);
            this.generateContentMethod(categoryComponent, resolverClass, new StaticKeyResolverInvoke());
            resolvers.put(resolverName, resolverClass);
            generatedResolvers.add(resolverName);
        });
        this.ctx().registerProduct(Product.METADATA_RESOLVER, (Object)resolvers);
    }
}

