/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.metadata;

import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaDataKey;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.extension.AbstractExtensionMigrationGenerator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;

public abstract class AbstractMetadataGenerator
extends AbstractExtensionMigrationGenerator {
    public static final String MIGRATE_METADATA_TYPE_MESSAGE = "TODO: Type mismatch left intentionally. Manual migration needed from Metadata to the new MetadataType";
    protected static final String GET_CATEGORY_METHOD = "getCategory";
    protected static final String GET_METADATAKEY = "getMetadatakey";
    protected static final String WITH_STATIC_KEY = "WithStaticKey";
    protected static final String KEYS_RESOLVER = "keysResolver";
    protected static final String CONTENT_RESOLVER = "contentResolver";
    protected static final String OUTPUT_RESOLVER = "outputResolver";

    protected GeneratedVariable getConfiguredConnector(Module module, GeneratedMethod generatedMethod, GeneratedVariable metadataContext) {
        GeneratedVariable connectorLib = this.generateConnectorLib(module, generatedMethod);
        if (module.getConfigStrategy().isPresent()) {
            GeneratedInvocation configOrConnection = module.manager().hasConnectionManagement() ? ExpressionFactory.cast((Type)this.getStrategyBaseType(module), (GeneratedExpression)metadataContext.invoke("getConnection").invoke("get")) : metadataContext.invoke("getConfig");
            generatedMethod.body().add((Statement)connectorLib.invoke(this.setterName((Field)module.getConfigStrategy().get())).arg((GeneratedExpression)configOrConnection));
        }
        return connectorLib;
    }

    protected GeneratedMethod generateMetadataTypeRetrieverMethod(GeneratedClass generatedClass, String methodName) {
        GeneratedMethod generatedMethod = generatedClass.method(1, (Type)this.ref(MetadataType.class), methodName)._throws(this.ref(MetadataResolvingException.class))._throws(this.ref(ConnectionException.class));
        generatedMethod.annotate(Override.class);
        return generatedMethod;
    }

    protected GeneratedMethod generateGetCategory(Module module, MetaDataCategoryComponent categoryComponent, GeneratedClass generatedClass) {
        GeneratedMethod getCategory = generatedClass.method(4, this.ref(categoryComponent.asTypeMirror()), GET_CATEGORY_METHOD);
        getCategory.javadoc().add((Object)"Auxiliary method that configures the MetaDataCategory instance");
        GeneratedVariable metadataContext = getCategory.param((Type)this.ref(MetadataContext.class), "metadataContext");
        if (categoryComponent.getInjectedConnector().isPresent()) {
            GeneratedVariable connectorMetadataCategory = getCategory.body().decl(this.ref(categoryComponent.asTypeMirror()), "metadataCategory", (GeneratedExpression)this._new(categoryComponent.asType()));
            GeneratedVariable connectorLib = this.getConfiguredConnector(module, getCategory, metadataContext);
            getCategory.body().add((Statement)connectorMetadataCategory.invoke(this.setterName((Field)categoryComponent.getInjectedConnector().get())).arg((GeneratedExpression)connectorLib));
            getCategory.body()._return((GeneratedExpression)connectorMetadataCategory);
        } else {
            getCategory.body()._return((GeneratedExpression)this._new(categoryComponent.asType()));
        }
        return getCategory;
    }

    protected GeneratedMethod generateGetIDForStaticKey(GeneratedClass generatedClass, String staticKey) {
        GeneratedMethod getId = generatedClass.method(4, (Type)this.ref(MetaDataKey.class), GET_METADATAKEY);
        getId.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaDataKey.class)).arg(ExpressionFactory.lit((String)staticKey)).arg(ExpressionFactory.lit((String)staticKey)));
        return getId;
    }

    protected GeneratedMethod generateGetIdForCategory(GeneratedClass generatedClass) {
        GeneratedMethod getId = generatedClass.method(4, (Type)this.ref(MetaDataKey.class), GET_METADATAKEY);
        GeneratedVariable metadataKey = getId.param((Type)this.ref(MetadataKey.class), "metadataKey");
        getId.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaDataKey.class)).arg((GeneratedExpression)metadataKey.invoke("getId")).arg((GeneratedExpression)metadataKey.invoke("getId")));
        return getId;
    }

    protected GeneratedClass generateResolverClass(Module module, Context ctx, String resolverName) {
        return ctx.getCodeModel()._package(module.getPackageName() + ".extension.metadata")._class(1, resolverName);
    }

    protected String getCategoryResolverName(MetaDataCategoryComponent categoryComponent) {
        return categoryComponent.getName().concat("Resolver");
    }

    protected String getOutputStaticKeyResolverName(MetaDataCategoryComponent categoryComponent, ProcessorMethod processorMethod) {
        MetaDataStaticKey staticKey = this.getOutputMetadataStaticKey(processorMethod);
        return this.getStaticKeyResolverName(categoryComponent, staticKey);
    }

    protected String getInputStaticKeyResolverName(MetaDataCategoryComponent categoryComponent, ProcessorMethod processorMethod) {
        MetaDataStaticKey staticKey = this.getInputMetadataStaticKey(processorMethod);
        return this.getStaticKeyResolverName(categoryComponent, staticKey);
    }

    protected String getStaticKeyResolverName(MetaDataCategoryComponent categoryComponent, MetaDataStaticKey staticKey) {
        return categoryComponent.getName().concat(WITH_STATIC_KEY).concat(StringUtils.capitalize((String)staticKey.type().toLowerCase()));
    }

    protected MetaDataStaticKey getInputMetadataStaticKey(ProcessorMethod processorMethod) {
        return (MetaDataStaticKey)processorMethod.getStaticKeyInputMetaData().metaDataStaticKey().get();
    }

    protected MetaDataStaticKey getOutputMetadataStaticKey(ProcessorMethod processorMethod) {
        return processorMethod.getStaticKeyOutputMetaData();
    }
}

