/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.connection;

import java.util.Arrays;
import java.util.List;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.connection.AbstractConnectionProviderGenerator;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.utils.NameUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionExceptionCode;
import org.mule.runtime.api.connection.ConnectionValidationResult;

public class PooledConnectionProviderGenerator
extends AbstractConnectionProviderGenerator {
    List<? extends String> b;

    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_CONNECTION_PROVIDER);
    }

    public boolean shouldGenerate(Module module) {
        return module.getConfigStrategy().isPresent() && !module.manager().connectionManagementComponents().isEmpty();
    }

    @Override
    protected List<? extends ConnectionComponent> getAffectedComponents(Module module) {
        return module.manager().connectionManagementComponents();
    }

    protected GeneratedInvocation getPoolingProfile(ConnectionComponent connectionComponent, GeneratedVariable strategyFactory) {
        if (((ConnectionManagementComponent)connectionComponent).getConnectMethod().getStrategy().equals((Object)ConnectStrategy.MULTIPLE_INSTANCES)) {
            return strategyFactory.invoke("supportsPooling");
        }
        return strategyFactory.invoke("cached");
    }

    @Override
    protected void generateDisconnectMethodBody(Module module, ConnectionComponent connectionComponent, GeneratedMethod disconnect, GeneratedVariable connection) {
        String disconnectMethodName = ((ConnectionManagementComponent)connectionComponent).getDisconnectMethod().getName();
        GeneratedInvocation disconnectInvoke = connectionComponent.asTypeMirror().toString().equals(this.getStrategyBaseType(module).fullName()) ? connection.invoke(disconnectMethodName) : ExpressionFactory.cast((Type)this.ref(connectionComponent.asType()), (GeneratedExpression)connection).invoke(disconnectMethodName);
        disconnect.body().add((Statement)disconnectInvoke);
    }

    @Override
    protected void generateValidateMethodBody(Module module, ConnectionComponent connectionComponent, GeneratedMethod validate, GeneratedVariable connection) {
        String validateMethodName = ((ConnectionManagementComponent)connectionComponent).getValidateConnectionMethod().getName();
        GeneratedInvocation disconnectInvoke = connectionComponent.asTypeMirror().toString().equals(this.getStrategyBaseType(module).fullName()) ? connection.invoke(validateMethodName) : ExpressionFactory.cast((Type)this.ref(connectionComponent.asType()), (GeneratedExpression)connection).invoke(validateMethodName);
        GeneratedConditional ifConnected = validate.body()._if((GeneratedExpression)disconnectInvoke);
        ifConnected._then().block()._return((GeneratedExpression)this.ref(ConnectionValidationResult.class).staticInvoke("success"));
        ifConnected._else().block()._return((GeneratedExpression)this.ref(ConnectionValidationResult.class).staticInvoke("failure").arg("Connection is no longer valid").arg((GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("UNKNOWN")).arg(ExpressionFactory._null()));
    }

    @Override
    protected void generateConnectExecutionOnClient(ConnectionComponent connectionComponent, GeneratedMethod connect, GeneratedVariable connectionClient, GeneratedClass connectionProviderClass) {
        this.generateConnectionParameters((ConnectionManagementComponent)connectionComponent, connectionProviderClass);
        GeneratedTry connectionExceptionTry = connect.body()._try();
        if (connectionComponent.startable().isPresent()) {
            connectionExceptionTry.body().add((Statement)connectionClient.invoke(((Method)connectionComponent.startable().get()).getName()));
        }
        GeneratedInvocation connectInvoke = connectionClient.invoke(((ConnectionManagementComponent)connectionComponent).getConnectMethod().getName());
        for (Parameter connectionParam : ((ConnectionManagementComponent)connectionComponent).getConnectMethod().getParameters()) {
            connectInvoke.arg((GeneratedExpression)ExpressionFactory.invoke((String)NameUtils.buildGetter((String)connectionParam.getName())));
        }
        connectionExceptionTry.body().add((Statement)connectInvoke);
        GeneratedCatchBlock catchBlock = connectionExceptionTry._catch(this.ref(Exception.class));
        if (connectionComponent.stoppable().isPresent()) {
            catchBlock.body().add((Statement)connectionClient.invoke(((Method)connectionComponent.stoppable().get()).getName()));
        }
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConnectionException.class)).arg((GeneratedExpression)catchBlock.param("oldConnectionException").invoke("getMessage")));
    }

    private void generateConnectionParameters(ConnectionManagementComponent connectionManagerComponent, GeneratedClass connectionProviderClass) {
        for (Parameter connectionParam : connectionManagerComponent.getConnectMethod().getParameters()) {
            GeneratedField extensionParameter = this.methodParamToExtensionParameter(connectionProviderClass, connectionParam);
            this.addJavaDocForParameter((org.mule.devkit.model.Documentable)connectionManagerComponent.getConnectMethod(), (Documentable)extensionParameter, connectionParam.getName());
        }
    }
}

