/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.connection;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationValue;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractComponentMigrationGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.GeneratedWhileLoop;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.exceptionhandler.OnExceptionHandlerComponent;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.introspection.exception.ExceptionEnricher;

public class OnExceptionHandlerGenerator
extends AbstractComponentMigrationGenerator {
    public static final String ENRICHER = "Enricher";
    public static final String ENRICH_EXCEPTION = "enrichException";
    private Map<String, GeneratedClass> handlers = new HashMap<String, GeneratedClass>();

    public List<Product> consumes() {
        return Collections.emptyList();
    }

    public List<Product> produces() {
        return Collections.singletonList(Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER);
    }

    public boolean shouldGenerate(Module module) {
        return module.manager().handlerComponent().isPresent() || !module.reconnectOn().isEmpty() || this.hasProcessorAnnotatedWithOnException(module) || this.hasProcessorAnnotatedWithReconnectOn(module);
    }

    private boolean hasProcessorAnnotatedWithOnException(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> p.manager().handlerComponent().isPresent());
    }

    private boolean hasProcessorAnnotatedWithReconnectOn(Module module) {
        return module.getProcessorMethods().stream().anyMatch(p -> !p.reconnectOn().isEmpty());
    }

    public void generate(Module module) throws GenerationException {
        this.generateEnricherForModule(module);
        this.generateEnricherForProcessorMethods(module);
    }

    private void generateEnricherForProcessorMethods(Module module) {
        module.getProcessorMethods().stream().filter(method -> method.getExceptionHandler().isPresent() || !method.reconnectOn().isEmpty()).forEach(method -> this.generateExceptionEnricher(module, (ProcessorMethod)method, method.reconnectOn()));
    }

    private void generateEnricherForModule(Module module) {
        if (module.getExceptionHandler().isPresent() || !module.reconnectOn().isEmpty()) {
            GeneratedClass enricherClass = this.generateEnricherClass(module, (Optional<OnExceptionHandlerComponent>)module.manager().handlerComponent(), module.reconnectOn());
            this.ctx().registerProduct(Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER, (Identifiable)module, (Object)enricherClass);
        }
    }

    public void generateExceptionEnricher(Module module, ProcessorMethod method, List<AnnotationValue> reconnectionExceptions) {
        GeneratedClass enricherClass;
        String className = this.generateClassNameForEnricher((Optional<OnExceptionHandlerComponent>)method.manager().handlerComponent(), reconnectionExceptions);
        if (!this.handlers.containsKey(className)) {
            enricherClass = this.generateEnricherClass(module, (Optional<OnExceptionHandlerComponent>)method.manager().handlerComponent(), reconnectionExceptions);
            this.handlers.put(className, enricherClass);
        } else {
            enricherClass = this.handlers.get(className);
        }
        this.ctx().registerProduct(Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER, (Identifiable)method, (Object)enricherClass);
    }

    private GeneratedClass generateEnricherClass(Module module, Optional<OnExceptionHandlerComponent> handler, List<AnnotationValue> reconnectionExceptions) {
        String className = this.generateClassNameForEnricher(handler, reconnectionExceptions);
        if (!handler.isPresent()) {
            return this.generateClassForReconnectOn(module, reconnectionExceptions, className);
        }
        this.updatedOldSource(((OnExceptionHandlerComponent)handler.get()).asType(), Arrays.asList("exception-handler-replacements.json"));
        return this.generateClassForExceptionEnricher(module, (OnExceptionHandlerComponent)handler.get(), reconnectionExceptions, className);
    }

    private String generateClassNameForEnricher(Optional<OnExceptionHandlerComponent> handler, List<AnnotationValue> reconnectionExceptions) {
        if (!handler.isPresent()) {
            return this.getReconnectOnExceptionEnricherName(reconnectionExceptions) + "Exception";
        }
        String name = ((OnExceptionHandlerComponent)handler.get()).asType().getClassName().replace("Handler", "Exception");
        return reconnectionExceptions.isEmpty() ? name : this.getReconnectOnExceptionEnricherName(reconnectionExceptions) + name;
    }

    private String getReconnectOnExceptionEnricherName(List<AnnotationValue> reconnectionExceptions) {
        StringBuilder builder = new StringBuilder();
        for (AnnotationValue value : reconnectionExceptions) {
            String name = value.toString().replace(".class", "");
            int lastDotIndex = name.lastIndexOf(".");
            if (lastDotIndex == -1) continue;
            builder.append(name.substring(lastDotIndex + 1));
        }
        return builder.toString();
    }

    private GeneratedClass generateClassForReconnectOn(Module module, List<AnnotationValue> reconnectionExceptions, String className) {
        GeneratedClass enricherClass = this.ctx().getCodeModel()._package(module.getPackageName() + ".extension.enricher")._class(1, className)._implements(ExceptionEnricher.class);
        GeneratedMethod enrichMethod = enricherClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Exception.class), ENRICH_EXCEPTION);
        enrichMethod.annotate(Override.class);
        GeneratedVariable exception = enrichMethod.param(Exception.class, "exception");
        this.checkReconnection(reconnectionExceptions, enrichMethod.body(), exception, enricherClass);
        enrichMethod.body()._return((GeneratedExpression)exception);
        return enricherClass;
    }

    private void checkReconnection(List<AnnotationValue> reconnectionExceptions, GeneratedBlock block, GeneratedVariable exception, GeneratedClass enrichedClass) {
        GeneratedField exceptionList = this.addConnectionListToGeneratedClass(enrichedClass, reconnectionExceptions);
        GeneratedVariable iterator = block.decl((org.mule.devkit.model.code.Type)this.ref(Iterator.class).narrow(this.ref(Class.class).wildcard()), "iterator", (GeneratedExpression)exceptionList.invoke("iterator"));
        GeneratedWhileLoop exceptionLoop = block._while((GeneratedExpression)iterator.invoke("hasNext"));
        exceptionLoop.body()._if((GeneratedExpression)iterator.invoke("next").invoke("isInstance").arg((GeneratedExpression)exception))._then().block()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConnectionException.class)).arg((GeneratedExpression)exception));
    }

    private GeneratedField addConnectionListToGeneratedClass(GeneratedClass enrichedClass, List<AnnotationValue> recconectionExceptions) {
        GeneratedField field = enrichedClass.field(4, (org.mule.devkit.model.code.Type)this.ref(List.class).narrow(this.ref(Class.class).wildcard()), "connectionExceptions");
        GeneratedInvocation invocation = this.ref(Arrays.class).staticInvoke("asList");
        recconectionExceptions.stream().map(e -> e.getValue()).forEach(e -> invocation.arg(this.ref(e.toString()).boxify().dotclass()));
        field.init((GeneratedExpression)invocation);
        return field;
    }

    private GeneratedClass generateClassForExceptionEnricher(Module module, OnExceptionHandlerComponent handler, List<AnnotationValue> reconnectionExceptions, String className) {
        Type type = handler.asType();
        GeneratedClass enricherClass = this.ctx().getCodeModel()._package(module.getPackageName() + ".extension.enricher")._class(1, className)._implements(ExceptionEnricher.class);
        GeneratedMethod enrichMethod = enricherClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Exception.class), ENRICH_EXCEPTION);
        enrichMethod.annotate(Override.class);
        GeneratedVariable exception = enrichMethod.param(Exception.class, "exception");
        GeneratedTry tryBlock = enrichMethod.body()._try();
        GeneratedVariable handlerVar = tryBlock.body().decl(this.ref(type), "handler", (GeneratedExpression)this._new(type));
        tryBlock.body().add((Statement)handlerVar.invoke(handler.getExceptionHandle().getName()).arg((GeneratedExpression)exception));
        GeneratedCatchBlock catchBlock = tryBlock._catch(this.ref(Exception.class));
        catchBlock.body()._return((GeneratedExpression)catchBlock.param("e"));
        if (!reconnectionExceptions.isEmpty()) {
            this.checkReconnection(reconnectionExceptions, tryBlock.body(), exception, enricherClass);
        }
        enrichMethod.body()._return((GeneratedExpression)exception);
        return enricherClass;
    }
}

