/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.connection;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.connection.AbstractConnectionProviderGenerator;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.runtime.api.connection.ConnectionValidationResult;

public class NoneConnectionProviderGenerator
extends AbstractConnectionProviderGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_CONNECTION_PROVIDER);
    }

    public boolean shouldGenerate(Module module) {
        return module.getConfigStrategy().isPresent() && !module.manager().connectionManagementComponents().isEmpty() && !module.manager().configurationComponents().isEmpty();
    }

    @Override
    protected List<? extends ConnectionComponent> getAffectedComponents(Module module) {
        return module.manager().configurationComponents();
    }

    @Override
    protected GeneratedExpression getPoolingProfile(ConnectionComponent connectionManagerComponent, GeneratedVariable strategyFactory) {
        return strategyFactory.invoke("cached");
    }

    @Override
    protected void generateValidateMethodBody(Module module, ConnectionComponent connectionComponent, GeneratedMethod validate, GeneratedVariable connection) {
        validate.body().add(ExpressionFactory.inlineComment((String)"This connection does not support validation"));
        validate.body()._return((GeneratedExpression)this.ref(ConnectionValidationResult.class).staticInvoke("success"));
    }

    @Override
    protected void generateDisconnectMethodBody(Module module, ConnectionComponent connectionComponent, GeneratedMethod disconnect, GeneratedVariable connection) {
        disconnect.body().add(ExpressionFactory.inlineComment((String)"This connection does not support connect/disconnect lifecycle"));
    }

    @Override
    protected void generateConnectExecutionOnClient(ConnectionComponent connectionComponent, GeneratedMethod connect, GeneratedVariable connectionClient, GeneratedClass connectionProviderClass) {
    }
}

