/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.connection;

import java.util.Arrays;
import java.util.List;
import org.mule.api.annotations.Configurable;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractComponentMigrationGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.runtime.api.connection.ConnectionProvider;

public class BaseConnectionProviderGenerator
extends AbstractComponentMigrationGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER);
    }

    public boolean shouldGenerate(Module module) {
        return module.getConfigStrategy().isPresent() && !module.manager().connectionManagementComponents().isEmpty() && this.baseConfigIsRequired(module.manager().connectionManagementComponents());
    }

    private boolean baseConfigIsRequired(List<ConnectionManagementComponent> components) {
        return components.stream().anyMatch(this::hasInheritedConfigurables);
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass extension = (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ADAPTER);
        module.manager().connectionManagementComponents().stream().filter(this::hasInheritedConfigurables).forEach(component -> this.generateBaseProvider(module, extension.getPackage().name() + ".connection.provider", component.asType().getSuperClass()));
    }

    private GeneratedClass generateBaseProvider(Module module, String packageName, Type configurablesContainer) {
        if (this.ctx().getProduct(Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER, (Identifiable)configurablesContainer) != null) {
            return (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER, (Identifiable)configurablesContainer);
        }
        GeneratedClass abstractProviderClass = this.ctx().getCodeModel()._package(packageName)._class(33, configurablesContainer.getClassName() + "ConnectionProvider");
        this.addJavaDoc((org.mule.devkit.model.Documentable)configurablesContainer, (Documentable)abstractProviderClass);
        this.fieldsToExtensionParameter(abstractProviderClass, configurablesContainer.getFieldsAnnotatedWith(Configurable.class));
        if (this.hasInheritedConfigurables(configurablesContainer)) {
            abstractProviderClass._extends((TypeReference)this.generateBaseProvider(module, packageName, configurablesContainer.getSuperClass()));
        } else {
            abstractProviderClass._implements(this.ref(ConnectionProvider.class).narrow(this.getStrategyBaseType(module)));
        }
        this.ctx().registerProduct(Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER, (Identifiable)configurablesContainer, (Object)abstractProviderClass);
        this.updatedOldSource(configurablesContainer.asType(), Arrays.asList("connection-management-replacements.json"));
        return abstractProviderClass;
    }
}

