/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.connection;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractComponentMigrationGenerator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AnnotationArrayMember;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.utils.NameUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandlingStrategy;
import org.mule.runtime.api.connection.ConnectionHandlingStrategyFactory;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connector.Providers;

public abstract class AbstractConnectionProviderGenerator
extends AbstractComponentMigrationGenerator {
    public void generate(Module module) throws GenerationException {
        GeneratedClass extension = this.getExtensionClass();
        Optional<GeneratedAnnotationUse> providerParams = extension.annotations().stream().filter(annotation -> annotation.getAnnotationClass().fullName().equals(Providers.class.getName())).findFirst();
        GeneratedAnnotationUse annotation2 = providerParams.isPresent() ? providerParams.get() : extension.annotate(Providers.class);
        AnnotationArrayMember providersExtensionParams = annotation2.paramArray("value");
        List<? extends ConnectionComponent> components = this.getAffectedComponents(module);
        for (ConnectionComponent connectionComponent : components) {
            providersExtensionParams.param((Type)this.generateConnectionProvider(module, extension, connectionComponent));
        }
        this.updatedOldSources(components, Arrays.asList("configuration-replacements.json", "connection-management-replacements.json"));
    }

    protected abstract List<? extends ConnectionComponent> getAffectedComponents(Module var1);

    protected GeneratedClass generateConnectionProvider(Module module, GeneratedClass extension, ConnectionComponent connectionManagerComponent) {
        GeneratedClass connectionProviderClass = this.ctx().getCodeModel()._package(extension.getPackage().name() + ".connection.provider")._class(1, connectionManagerComponent.asType().getClassName() + "ConnectionProvider");
        connectionProviderClass.annotate(Alias.class).param("value", connectionManagerComponent.getName());
        this.addHierarchyDeclaration(module, extension, connectionManagerComponent, connectionProviderClass);
        this.fieldsToExtensionParameter(connectionProviderClass, this.getDeclaredConfigurables(connectionManagerComponent));
        this.implementProviderInterfaceMethods(module, extension, connectionManagerComponent, connectionProviderClass);
        this.addJavaDoc((org.mule.devkit.model.Documentable)connectionManagerComponent, (Documentable)connectionProviderClass);
        this.ctx().registerProduct(Product.EXTENSION_CONNECTION_PROVIDER, (Identifiable)connectionManagerComponent, (Object)connectionProviderClass);
        return connectionProviderClass;
    }

    private GeneratedClass addHierarchyDeclaration(Module module, GeneratedClass extension, ConnectionComponent connectionComponent, GeneratedClass connectionProviderClass) {
        if (this.hasInheritedConfigurables(connectionComponent.asType())) {
            return connectionProviderClass._extends((TypeReference)this.getParentProvider(connectionComponent));
        }
        return connectionProviderClass._implements(this.ref(ConnectionProvider.class).narrow(this.getStrategyBaseType(module)));
    }

    private GeneratedClass getParentProvider(ConnectionComponent connectionManagerComponent) {
        return (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ABSTRACT_CONNECTION_PROVIDER, (Identifiable)connectionManagerComponent.asType().getSuperClass());
    }

    private void implementProviderInterfaceMethods(Module module, GeneratedClass extension, ConnectionComponent connectionComponent, GeneratedClass connectionProviderClass) {
        this.generateConnectMethod(module, connectionComponent, connectionProviderClass, extension);
        this.generateDisconnectMethod(module, connectionComponent, connectionProviderClass);
        this.generateGetHandlingStrategy(module, connectionComponent, connectionProviderClass);
        this.generateValidateMethod(module, connectionComponent, connectionProviderClass);
    }

    private void generateGetHandlingStrategy(Module module, ConnectionComponent connectionComponent, GeneratedClass connectionProviderClass) {
        GeneratedMethod getHandlingStrategy = connectionProviderClass.method(1, (Type)this.ref(ConnectionHandlingStrategy.class).narrow(this.getStrategyBaseType(module)), "getHandlingStrategy");
        getHandlingStrategy.annotate(Override.class);
        GeneratedVariable strategyFactory = getHandlingStrategy.param((Type)this.ref(ConnectionHandlingStrategyFactory.class).narrow(this.getStrategyBaseType(module)), "handlingStrategyFactory");
        getHandlingStrategy.body()._return(this.getPoolingProfile(connectionComponent, strategyFactory));
    }

    protected abstract GeneratedExpression getPoolingProfile(ConnectionComponent var1, GeneratedVariable var2);

    private void generateValidateMethod(Module module, ConnectionComponent connectionComponent, GeneratedClass connectionProviderClass) {
        GeneratedMethod validate = connectionProviderClass.method(1, ConnectionValidationResult.class, "validate");
        GeneratedVariable connection = validate.param(this.getStrategyBaseType(module), "connection");
        validate.annotate(Override.class);
        this.generateValidateMethodBody(module, connectionComponent, validate, connection);
    }

    protected abstract void generateValidateMethodBody(Module var1, ConnectionComponent var2, GeneratedMethod var3, GeneratedVariable var4);

    protected void generateDisconnectMethod(Module module, ConnectionComponent connectionComponent, GeneratedClass connectionProviderClass) {
        GeneratedMethod disconnect = connectionProviderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "disconnect");
        GeneratedVariable connection = disconnect.param(this.getStrategyBaseType(module), "connection");
        disconnect.annotate(Override.class);
        this.generateDisconnectMethodBody(module, connectionComponent, disconnect, connection);
    }

    protected abstract void generateDisconnectMethodBody(Module var1, ConnectionComponent var2, GeneratedMethod var3, GeneratedVariable var4);

    protected void generateConnectMethod(Module module, ConnectionComponent connectionComponent, GeneratedClass connectionProviderClass, GeneratedClass config) {
        GeneratedMethod connect = connectionProviderClass.method(1, this.getStrategyBaseType(module), "connect");
        connect._throws(ConnectionException.class);
        connect.annotate(Override.class);
        GeneratedVariable connectionClient = connect.body().decl(this.ref(connectionComponent.asTypeMirror()), "connectionClient", (GeneratedExpression)this._new(connectionComponent.asType()));
        for (Field configurable : connectionComponent.getConfigurableFields()) {
            connect.body().invoke((GeneratedExpression)connectionClient, this.setterName(configurable)).arg((GeneratedExpression)ExpressionFactory.invoke((String)NameUtils.buildGetter((String)configurable.getName())));
        }
        this.generateConnectExecutionOnClient(connectionComponent, connect, connectionClient, connectionProviderClass);
        connect.body()._return((GeneratedExpression)connectionClient);
    }

    protected abstract void generateConnectExecutionOnClient(ConnectionComponent var1, GeneratedMethod var2, GeneratedVariable var3, GeneratedClass var4);
}

