/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractComponentMigrationGenerator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.code.AnnotationArrayMember;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.runtime.extension.api.annotation.Configurations;

public class ConfigurationMigrationGenerator
extends AbstractComponentMigrationGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER, Product.EXTENSION_ABSTRACT_CONFIG_FACTORY);
    }

    public List<Product> produces() {
        return Collections.singletonList(Product.EXTENSION_CONFIG_FACTORY);
    }

    public boolean shouldGenerate(Module module) {
        return module.getConfigStrategy().isPresent() && module.manager().connectionManagementComponents().isEmpty() && !module.manager().configurationComponents().isEmpty();
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass extension = this.getExtensionClass();
        AnnotationArrayMember configExtensionParams = extension.annotate(Configurations.class).paramArray("value");
        this.updatedOldSources(module.manager().configurationComponents(), Arrays.asList("configuration-replacements.json"));
        for (ConfigurationComponent configurationComponent : module.manager().configurationComponents()) {
            configExtensionParams.param(this.ref(configurationComponent.asTypeMirror()));
            configurationComponent.getFields().stream().forEach(f -> this.updateComplexFieldSource((Field)f, Arrays.asList("configuration-replacements.json")));
        }
    }
}

