/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension.config;

import java.util.Arrays;
import java.util.List;
import org.mule.api.annotations.Configurable;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractComponentMigrationGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;

public class BaseConfigurationGenerator
extends AbstractComponentMigrationGenerator {
    public List<Product> consumes() {
        return Arrays.asList(Product.EXTENSION_ADAPTER);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.EXTENSION_ABSTRACT_CONFIG_FACTORY);
    }

    public boolean shouldGenerate(Module module) {
        return module.getConfigStrategy().isPresent() && module.manager().connectionManagementComponents().isEmpty() && !module.manager().configurationComponents().isEmpty() && this.abstractConfigFactoryIsRequired(module.manager().configurationComponents());
    }

    private boolean abstractConfigFactoryIsRequired(List<ConfigurationComponent> configurationComponents) {
        return configurationComponents.stream().anyMatch(this::hasInheritedConfigurables);
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass extension = (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ADAPTER);
        module.manager().configurationComponents().stream().filter(this::hasInheritedConfigurables).forEach(configurationComponent -> this.generateAbstractFactory(module, extension.getPackage().name() + ".config", configurationComponent.asType().getSuperClass()));
        this.updatedOldSources(module.manager().configurationComponents(), Arrays.asList("configuration-replacements.json"));
    }

    private GeneratedClass generateAbstractFactory(Module module, String packageName, Type configurablesContainer) {
        if (this.ctx().getProduct(Product.EXTENSION_ABSTRACT_CONFIG_FACTORY, (Identifiable)configurablesContainer) != null) {
            return (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ABSTRACT_CONFIG_FACTORY, (Identifiable)configurablesContainer);
        }
        GeneratedClass abstractFactoryClass = this.ctx().getCodeModel()._package(packageName)._class(33, configurablesContainer.getClassName() + "Factory");
        this.addJavaDoc((org.mule.devkit.model.Documentable)configurablesContainer, (Documentable)abstractFactoryClass);
        this.fieldsToExtensionParameter(abstractFactoryClass, configurablesContainer.getFieldsAnnotatedWith(Configurable.class));
        if (this.hasInheritedConfigurables(configurablesContainer)) {
            abstractFactoryClass._extends((TypeReference)this.generateAbstractFactory(module, packageName, configurablesContainer.getSuperClass()));
        }
        abstractFactoryClass.method(33, this.getStrategyBaseType(module), "getConfig");
        this.ctx().registerProduct(Product.EXTENSION_ABSTRACT_CONFIG_FACTORY, (Identifiable)configurablesContainer, (Object)abstractFactoryClass);
        this.updatedOldSource(configurablesContainer.asType(), Arrays.asList("configuration-replacements.json"));
        return abstractFactoryClass;
    }
}

