/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.extension.AbstractComponentMigrationGenerator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.Documentable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.OnException;

public class ExtensionGenerator
extends AbstractComponentMigrationGenerator {
    public List<Product> consumes() {
        return Collections.singletonList(Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER);
    }

    public List<Product> produces() {
        return Collections.singletonList(Product.EXTENSION_ADAPTER);
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass extensionClass = this.ctx().getCodeModel()._package(module.getPackageName() + ".extension")._class(1, module.getName().replace("Connector", "Extension"));
        extensionClass.annotate(Extension.class).param("name", module.getFriendlyName()).param("description", module.getDescription());
        this.addExceptionEnricher(module, extensionClass);
        this.addJavaDoc((org.mule.devkit.model.Documentable)module, (Documentable)extensionClass);
        this.ctx().registerProduct(Product.EXTENSION_ADAPTER, (Object)extensionClass);
        this.updatedOldSource(module.asType(), Arrays.asList("connector-replacements.json", "oauth-replacements.json", "metadata-replacements.json", "licensing-replacements.json"));
    }

    private void addExceptionEnricher(Module module, GeneratedClass extensionClass) {
        if (module.getExceptionHandler().isPresent() || !module.reconnectOn().isEmpty()) {
            GeneratedClass enricherClass = (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_EXCEPTION_HANDLER_ADAPTER, (Identifiable)module);
            extensionClass.annotate(OnException.class).param("value", (Type)enricherClass);
        }
    }
}

