/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.extension;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.display.FriendlyName;
import org.mule.api.annotations.display.Placement;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.OSUtils;
import org.mule.devkit.generation.utils.Replacement;
import org.mule.devkit.model.Documentable;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedAnnotationUse;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.metadata.Content;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;

public abstract class AbstractExtensionMigrationGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final Logger LOGGER = Logger.getLogger(AbstractExtensionMigrationGenerator.class);
    public static final String TAB = "tab";
    public static final String GROUP = "group";
    public static final String ORDER = "order";

    protected List<Field> getDeclaredConfigurables(ConnectionComponent component) {
        return component.asType().getFieldsAnnotatedWith(Configurable.class);
    }

    protected void fieldsToExtensionParameter(GeneratedClass parametersContainer, List<Field> configurables) {
        for (Field field : configurables) {
            this.fieldsToExtensionParameter(parametersContainer, field);
        }
    }

    protected GeneratedField fieldsToExtensionParameter(GeneratedClass configurationClass, Field field) {
        GeneratedField extensionParameter = configurationClass.field(4, this.ref(field.asTypeMirror()), field.getName());
        extensionParameter.annotate(org.mule.runtime.extension.api.annotation.Parameter.class);
        this.addJavaDoc((Documentable)field, (org.mule.devkit.model.code.Documentable)extensionParameter);
        this.generateSetAndGet(configurationClass, extensionParameter);
        this.annotateParameter((Variable)field, (GeneratedVariable)extensionParameter);
        return extensionParameter;
    }

    protected void generateSetAndGet(GeneratedClass configurationClass, GeneratedField extensionParameter) {
        configurationClass.setter(extensionParameter);
        configurationClass.getter(extensionParameter);
    }

    protected GeneratedField methodParamToExtensionParameter(GeneratedClass configurationClass, Parameter param) {
        GeneratedField extensionParameter = configurationClass.field(1, this.ref(param.asTypeMirror()), param.getName());
        extensionParameter.annotate(org.mule.runtime.extension.api.annotation.Parameter.class);
        this.generateSetAndGet(configurationClass, extensionParameter);
        this.annotateParameter((Variable)param, (GeneratedVariable)extensionParameter);
        return extensionParameter;
    }

    protected void annotateParameter(Variable param, GeneratedVariable fieldParameter) {
        this.annotateIfOptional(param, fieldParameter);
        this.annotateIfLiteral(param, fieldParameter);
        this.annotateIfPlacement(param, fieldParameter);
        this.annotateIfFriendlyName(param, fieldParameter);
        this.annotateIfPayload(param, fieldParameter);
        this.annotateIfMetadataKeypParam(param, fieldParameter);
    }

    private void annotateIfMetadataKeypParam(Variable param, GeneratedVariable fieldParameter) {
        if (param.metaDataKey().isPresent()) {
            fieldParameter.annotate(MetadataKeyId.class);
        }
    }

    private void annotateIfPayload(Variable param, GeneratedVariable fieldParameter) {
        if (param.isPayload()) {
            fieldParameter.annotate(Content.class);
        }
    }

    protected void annotateIfOptional(Variable param, GeneratedVariable fieldParameter) {
        if (param.isOptional() && !param.isPayload()) {
            GeneratedAnnotationUse optional = fieldParameter.annotate(Optional.class);
            if (param.hasDefaultValue()) {
                optional.param("defaultValue", param.getDefaultValue());
            }
        }
    }

    protected void annotateIfLiteral(Variable param, GeneratedVariable fieldParameter) {
        if (param.isLiteral()) {
            GeneratedAnnotationUse expression = fieldParameter.annotate(Expression.class);
            expression.param("value", (Enum)ExpressionSupport.LITERAL);
        }
    }

    protected void annotateIfFriendlyName(Variable param, GeneratedVariable fieldParameter) {
        FriendlyName friendlyName = (FriendlyName)param.getAnnotation(FriendlyName.class);
        if (friendlyName != null) {
            GeneratedAnnotationUse expression = fieldParameter.annotate(DisplayName.class);
            expression.param("value", friendlyName.value());
        }
    }

    protected void annotateIfPlacement(Variable param, GeneratedVariable fieldParameter) {
        if (param.placement().isPresent()) {
            Placement connectorPlacement = (Placement)param.placement().get();
            GeneratedAnnotationUse placement = fieldParameter.annotate(org.mule.runtime.extension.api.annotation.param.display.Placement.class);
            if (!StringUtils.isBlank((String)connectorPlacement.tab())) {
                placement.param(TAB, connectorPlacement.tab());
            }
            if (!StringUtils.isBlank((String)connectorPlacement.group())) {
                placement.param(GROUP, connectorPlacement.group());
            }
            if (connectorPlacement.order() != 1) {
                placement.param(ORDER, connectorPlacement.order());
            }
        }
    }

    protected String setterName(Field field) {
        return field.getSetter().getName();
    }

    protected String getterName(Field field) {
        return field.getGetter().getName();
    }

    protected GeneratedInvocation _new(ConnectionComponent component) {
        return this._new(component.asType());
    }

    protected GeneratedInvocation _new(org.mule.devkit.model.Type type) {
        return ExpressionFactory._new((Type)this.ref(type.asTypeMirror()));
    }

    protected boolean hasConfigurableFields(org.mule.devkit.model.Type type) {
        return !type.getFieldsAnnotatedWith(Configurable.class).isEmpty();
    }

    protected boolean hasInheritedConfigurables(org.mule.devkit.model.Type configurationComponent) {
        return configurationComponent.hasSuperClass() && (this.hasConfigurableFields(configurationComponent.getSuperClass()) || this.hasInheritedConfigurables(configurationComponent.getSuperClass()));
    }

    protected Type getStrategyBaseType(Module module) {
        return this.ref(((Field)module.getConfigStrategy().get()).asTypeMirror());
    }

    protected GeneratedClass getExtensionClass() {
        return (GeneratedClass)this.ctx().getProduct(Product.EXTENSION_ADAPTER);
    }

    protected void updatedOldSources(List<? extends ConnectionComponent> affectedComponents, List<String> replacements) throws GenerationException {
        for (ConnectionComponent connectionComponent : affectedComponents) {
            this.updatedOldSource(connectionComponent.asType(), replacements);
        }
    }

    protected void updatedOldSource(org.mule.devkit.model.Type type, List<String> replacementDefinitions) {
        try {
            LinkedList<String> replacedLines = new LinkedList<String>();
            List<Replacement> replacements = this.buildReplacements(replacementDefinitions);
            for (String line : FileUtils.readLines((File)new File(type.getPathToSourceFile()))) {
                boolean wasBlank = StringUtils.isBlank((String)line);
                for (Replacement replacement : replacements) {
                    line = Pattern.compile(replacement.getToken()).matcher(line).replaceAll(replacement.getValue());
                }
                if (!wasBlank && StringUtils.isBlank((String)line)) continue;
                replacedLines.add(line);
            }
            File newComponent = this.getMigratedSourceFile(type);
            newComponent.getParentFile().mkdirs();
            FileUtils.writeLines((File)newComponent, replacedLines);
        }
        catch (IOException e) {
            LOGGER.error((Object)"An error occurred while updating a source file", (Throwable)e);
        }
    }

    private File getMigratedSourceFile(org.mule.devkit.model.Type type) {
        Path sourceFilePath = Paths.get(this.getSanitizedPath(type.getPathToSourceFile()), new String[0]);
        Path sourceDirPath = Paths.get(this.ctx().getMavenInformation().getSrcDirectory(), new String[0]);
        Path packagePath = sourceDirPath.relativize(sourceFilePath);
        Path outputPackagePath = Paths.get(this.ctx().getMavenInformation().getOutputDirectory(), packagePath.toString());
        return new File(outputPackagePath.toUri());
    }

    private String getSanitizedPath(String path) {
        if (OSUtils.isWindows()) {
            if (path.startsWith("/")) {
                path = path.replaceFirst("/", "");
            }
            path = path.replace("/", "\\");
        }
        return path;
    }

    private List<Replacement> buildReplacements(List<String> componentReplacements) throws IOException {
        LinkedList<String> definitions = new LinkedList<String>(componentReplacements);
        definitions.add("common-replacements.json");
        LinkedList<Replacement> replacements = new LinkedList<Replacement>();
        Gson gson = new Gson();
        for (String definition : definitions) {
            String content = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("replacements/" + definition));
            replacements.addAll((Collection)gson.fromJson(content, new TypeToken<List<Replacement>>(){}.getType()));
        }
        return replacements;
    }

    private boolean isPojo(org.mule.devkit.model.Type t) {
        return t.isComplexType() && !t.isMap();
    }

    protected void updateComplexFieldSource(org.mule.devkit.model.Type type, List<String> replacements) {
        if (this.isPojo(type)) {
            this.updatedOldSource(type, replacements);
        }
    }

    protected void updateComplexFieldSource(Field field, List<String> replacements) {
        org.mule.devkit.model.Type type = field.asType();
        if (type.isCollection()) {
            field.getTypeArguments().stream().forEach(t -> this.updateComplexFieldSource((org.mule.devkit.model.Type)t, replacements));
        } else {
            this.updateComplexFieldSource(type, replacements);
        }
    }

    protected void addJavaDoc(Documentable original, org.mule.devkit.model.code.Documentable migrated) {
        String javaDocSummary = original.getJavaDocSummary();
        if (!StringUtils.isBlank((String)javaDocSummary)) {
            migrated.javadoc().add((Object)javaDocSummary);
        }
    }

    protected void addJavaDocForParameter(Documentable original, org.mule.devkit.model.code.Documentable migrated, String paramName) {
        String javaDocSummary = original.getJavaDocParameterSummary(paramName);
        if (!StringUtils.isBlank((String)javaDocSummary)) {
            migrated.javadoc().addParam(String.format("%s %s", paramName, javaDocSummary));
        }
    }

    protected GeneratedVariable generateConnectorLib(Module module, GeneratedMethod method) {
        return method.body().decl(this.ref(module.asTypeMirror()), "connector", (GeneratedExpression)this._new((org.mule.devkit.model.Type)module));
    }

    protected void generateSetConnectorConfig(Module module, GeneratedMethod operation, GeneratedVariable connectorLib) {
        if (module.getConfigStrategy().isPresent()) {
            GeneratedVariable configReference = module.manager().hasConnectionManagement() ? this.generateConnectionParam(module, operation) : this.generateConfigFactoryParam(module, operation);
            operation.body().invoke((GeneratedExpression)connectorLib, this.setterName((Field)module.getConfigStrategy().get())).arg((GeneratedExpression)configReference);
        }
    }

    protected GeneratedVariable generateConfigFactoryParam(Module module, GeneratedMethod operation) {
        GeneratedVariable configParam = operation.param(this.getStrategyBaseType(module), "config");
        configParam.annotate(UseConfig.class);
        return configParam;
    }

    protected GeneratedVariable generateConnectionParam(Module module, GeneratedMethod operation) {
        GeneratedVariable configParam = operation.param(this.getStrategyBaseType(module), "connection");
        configParam.annotate(Connection.class);
        return configParam;
    }

    protected boolean returnsVoid(ProcessorMethod processorMethod) {
        return processorMethod.getReturnType().toString().equals(Void.TYPE.toString());
    }
}

