/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema;

import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.mule.devkit.generation.spring.schema.ComplexTypeHolder;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.schema.Annotation;
import org.mule.devkit.model.schema.Any;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.ComplexType;
import org.mule.devkit.model.schema.Documentation;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.GroupRef;
import org.mule.devkit.model.schema.LocalComplexType;
import org.mule.devkit.model.schema.LocalSimpleType;
import org.mule.devkit.model.schema.NumFacet;
import org.mule.devkit.model.schema.ObjectFactory;
import org.mule.devkit.model.schema.Pattern;
import org.mule.devkit.model.schema.Restriction;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.schema.SimpleContent;
import org.mule.devkit.model.schema.SimpleExtensionType;
import org.mule.devkit.model.schema.TopLevelComplexType;
import org.mule.devkit.model.schema.TopLevelElement;
import org.mule.devkit.model.schema.TopLevelSimpleType;
import org.mule.devkit.model.schema.Union;
import org.mule.devkit.utils.NameUtils;
import org.mule.module.http.api.requester.HttpRequesterConfig;

public abstract class AbstractSchemaBuilder {
    protected abstract RegisteredElements getRegisteredElements();

    protected Schema getSchema() {
        return this.getRegisteredElements().getSchema();
    }

    protected Set<String> getRegisteredMethods() {
        return this.getRegisteredElements().getRegisteredMethods();
    }

    protected Set<ComplexTypeHolder> getRegisteredComplexTypesHolders() {
        return this.getRegisteredElements().getRegisteredComplexTypesHolders();
    }

    protected Set<EnumType> getRegisteredEnums() {
        return this.getRegisteredElements().getRegisteredEnums();
    }

    protected ObjectFactory getObjectFactory() {
        return new ObjectFactory();
    }

    protected Annotation createDocAnnotation(String content) {
        Annotation annotation = new Annotation();
        Documentation doc = new Documentation();
        doc.getContent().add(content);
        annotation.getAppinfoOrDocumentation().add(doc);
        return annotation;
    }

    protected String registerComplexTypeWithoutRef(Type type) {
        return this.registerComplexType(type, false);
    }

    protected String registerComplexType(Type type) {
        return this.registerComplexType(type, true);
    }

    protected String registerComplexType(Type type, boolean registerRefBean) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        for (ComplexTypeHolder typeHolder : this.getRegisteredComplexTypesHolders()) {
            if (!this.areEquals(type, typeHolder.getType())) continue;
            return typeHolder.getComplexType().getName();
        }
        String registeredName = this.checkSimpleName(type.getName()) ? type.getName() + "ObjectType" : type.getPackageName() + "." + type.getName() + "ObjectType";
        complexType.setName(registeredName);
        this.getRegisteredComplexTypesHolders().add(new ComplexTypeHolder((ComplexType)complexType, type));
        ExplicitGroup all = new ExplicitGroup();
        if (type.hasSuperClass()) {
            String superClassName = this.registerComplexType(type.getSuperClass());
            ComplexContent complexContent = new ComplexContent();
            complexType.setComplexContent(complexContent);
            complexType.getComplexContent().setExtension(new ExtensionType());
            complexType.getComplexContent().getExtension().setBase(new QName(this.getSchema().getTargetNamespace(), superClassName));
            complexContent.getExtension().setSequence(all);
        } else {
            complexType.setSequence(all);
        }
        for (Field field : type.getFields()) {
            if (this.skipField(field)) continue;
            if (field.asType().isCollection()) {
                this.generateCollectionElement(all, (Variable)field, true);
                continue;
            }
            if (this.generateNestedProcessor(field)) {
                this.generateNestedProcessorElement(all, (Variable)field);
                continue;
            }
            if (field.isText()) {
                this.createParameterElement(all, (Variable)field);
                continue;
            }
            if (field.asType().isComplexType()) {
                this.registerComplexTypeChildElement(all, (Variable)field, true);
                continue;
            }
            if (type.hasSuperClass()) {
                complexType.getComplexContent().getExtension().getAttributeOrAttributeGroup().add(this.createAttribute((Variable)field, true));
                continue;
            }
            complexType.getAttributeOrAttributeGroup().add(this.createAttribute((Variable)field, true));
        }
        if (registerRefBean) {
            Attribute ref = this.createAttribute("ref", true, SchemaConstants.STRING, "The reference object for this parameter");
            if (!type.hasSuperClass()) {
                complexType.getAttributeOrAttributeGroup().add(ref);
            }
        }
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
        return registeredName;
    }

    protected void generateNestedProcessorElement(ExplicitGroup all, Variable variable) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        GroupRef group = this.generateNestedProcessorGroup();
        collectionComplexType.setGroup(group);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(NameUtils.uncamel((String)variable.getName()));
        collectionElement.setMinOccurs(variable.isOptional() ? BigInteger.ZERO : BigInteger.ONE);
        collectionElement.setComplexType(collectionComplexType);
        collectionElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.getObjectFactory().createElement(collectionElement));
        Attribute attribute = this.createAttribute("text", true, SchemaConstants.STRING, null);
        collectionComplexType.getAttributeOrAttributeGroup().add(attribute);
    }

    private LocalComplexType generateCollectionComplexType(String name, Identifiable type) {
        LocalComplexType collectionComplexType = new LocalComplexType();
        ExplicitGroup sequence = new ExplicitGroup();
        ExplicitGroup choice = new ExplicitGroup();
        if (type.asType().isMap()) {
            collectionComplexType.setChoice(choice);
            choice.getParticle().add(this.getObjectFactory().createSequence(sequence));
            Any any = new Any();
            any.setProcessContents("lax");
            any.setMinOccurs(new BigInteger("0"));
            any.setMaxOccurs("unbounded");
            ExplicitGroup anySequence = new ExplicitGroup();
            anySequence.getParticle().add(any);
            choice.getParticle().add(this.getObjectFactory().createSequence(anySequence));
        } else if (type.asType().isArrayOrList() || type.asType().isSet()) {
            collectionComplexType.setSequence(sequence);
        }
        TopLevelElement collectionItemElement = new TopLevelElement();
        collectionItemElement.setName(name);
        collectionItemElement.setMinOccurs(BigInteger.ZERO);
        collectionItemElement.setMaxOccurs("unbounded");
        collectionItemElement.setComplexType(this.generateComplexType(name, type));
        sequence.getParticle().add(this.getObjectFactory().createElement(collectionItemElement));
        Attribute ref = this.createAttribute("ref", true, SchemaConstants.STRING, "The reference object for this parameter");
        collectionComplexType.getAttributeOrAttributeGroup().add(ref);
        return collectionComplexType;
    }

    private LocalComplexType generateComplexType(String name, Identifiable typeMirror) {
        if (typeMirror.asType().isArrayOrList() || typeMirror.asType().isSet()) {
            List variableTypeParameters = typeMirror.getTypeArguments();
            if (variableTypeParameters.size() != 0 && variableTypeParameters.get(0) != null) {
                Type genericType = (Type)variableTypeParameters.get(0);
                if (this.isTypeSupported(genericType.asTypeMirror())) {
                    return this.generateComplexTypeWithRef((Identifiable)genericType);
                }
                if (genericType.isArrayOrList() || genericType.isMap() || genericType.isSet()) {
                    return this.generateCollectionComplexType("inner-" + name, (Identifiable)genericType);
                }
                if (genericType.isEnum()) {
                    return this.generateEnumComplexType((Identifiable)genericType);
                }
                return this.generateExtendedRefComplexType(genericType, "value-ref");
            }
            return this.generateRefComplexType("value-ref");
        }
        if (typeMirror.asType().isMap()) {
            List variableTypeParameters = typeMirror.getTypeArguments();
            LocalComplexType mapComplexType = new LocalComplexType();
            Attribute keyAttribute = new Attribute();
            if (variableTypeParameters.size() > 0 && this.isTypeSupported(((Type)variableTypeParameters.get(0)).asTypeMirror())) {
                keyAttribute.setName("key");
                keyAttribute.setType(SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)((Type)variableTypeParameters.get(0)).asTypeMirror().toString()));
            } else if (variableTypeParameters.size() > 0 && ((Type)variableTypeParameters.get(0)).isEnum()) {
                keyAttribute.setName("key");
                keyAttribute.setType(new QName(this.getSchema().getTargetNamespace(), ((Type)variableTypeParameters.get(0)).getName() + "EnumType"));
                this.getRegisteredEnums().add((EnumType)((Type)variableTypeParameters.get(0)).asType());
            } else {
                keyAttribute.setUse("required");
                keyAttribute.setName("key-ref");
                keyAttribute.setType(SchemaConstants.STRING);
            }
            QName baseType = variableTypeParameters.size() > 1 && this.isTypeSupported(((Type)variableTypeParameters.get(1)).asTypeMirror()) ? SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)((Type)variableTypeParameters.get(1)).asTypeMirror().toString()) : new QName("http://www.w3.org/2001/XMLSchema", "string", "xs");
            SimpleContent simpleContent = new SimpleContent();
            mapComplexType.setSimpleContent(simpleContent);
            SimpleExtensionType complexContentExtension = new SimpleExtensionType();
            complexContentExtension.setBase(baseType);
            simpleContent.setExtension(complexContentExtension);
            Attribute refAttribute = this.createAttribute("value-ref", true, SchemaConstants.STRING, null);
            complexContentExtension.getAttributeOrAttributeGroup().add(refAttribute);
            complexContentExtension.getAttributeOrAttributeGroup().add(keyAttribute);
            return mapComplexType;
        }
        return null;
    }

    private LocalComplexType generateEnumComplexType(Identifiable genericType) {
        LocalComplexType complexType = new LocalComplexType();
        SimpleContent simpleContent = new SimpleContent();
        complexType.setSimpleContent(simpleContent);
        SimpleExtensionType simpleContentExtension = new SimpleExtensionType();
        simpleContentExtension.setBase(new QName(this.getSchema().getTargetNamespace(), genericType.getName() + "EnumType"));
        simpleContent.setExtension(simpleContentExtension);
        this.getRegisteredEnums().add((EnumType)genericType.asType());
        return complexType;
    }

    private LocalComplexType generateComplexTypeWithRef(Identifiable genericType) {
        LocalComplexType complexType = new LocalComplexType();
        SimpleContent simpleContent = new SimpleContent();
        complexType.setSimpleContent(simpleContent);
        SimpleExtensionType simpleContentExtension = new SimpleExtensionType();
        QName extensionBase = SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)genericType.asTypeMirror().toString());
        simpleContentExtension.setBase(extensionBase);
        simpleContent.setExtension(simpleContentExtension);
        Attribute refAttribute = this.createAttribute("value-ref", true, SchemaConstants.STRING, null);
        simpleContentExtension.getAttributeOrAttributeGroup().add(refAttribute);
        return complexType;
    }

    private LocalComplexType generateExtendedRefComplexType(Type type, String name) {
        LocalComplexType itemComplexType = new LocalComplexType();
        itemComplexType.setComplexContent(new ComplexContent());
        itemComplexType.getComplexContent().setExtension(new ExtensionType());
        itemComplexType.getComplexContent().getExtension().setBase(new QName(this.getSchema().getTargetNamespace(), this.registerComplexType(type)));
        Attribute refAttribute = this.createAttribute(name, true, SchemaConstants.STRING, null);
        itemComplexType.getComplexContent().getExtension().getAttributeOrAttributeGroup().add(refAttribute);
        return itemComplexType;
    }

    private LocalComplexType generateRefComplexType(String name) {
        LocalComplexType itemComplexType = new LocalComplexType();
        Attribute refAttribute = this.createAttribute(name, false, SchemaConstants.STRING, null);
        itemComplexType.getAttributeOrAttributeGroup().add(refAttribute);
        return itemComplexType;
    }

    protected GroupRef generateNestedProcessorGroup() {
        GroupRef group = new GroupRef();
        group.generateNestedProcessorGroup(SchemaConstants.MULE_MESSAGE_PROCESSOR_OR_OUTBOUND_ENDPOINT_TYPE);
        group.setMinOccurs(BigInteger.valueOf(0L));
        group.setMaxOccurs("unbounded");
        return group;
    }

    protected void generateCollectionElement(ExplicitGroup all, Variable variable, boolean forceOptional) {
        String name = NameUtils.uncamel((String)variable.getName());
        BigInteger minOccurs = BigInteger.ZERO;
        if (!forceOptional && !variable.isOptional()) {
            minOccurs = BigInteger.ONE;
        }
        String collectionName = NameUtils.uncamel((String)NameUtils.singularize((String)name));
        LocalComplexType collectionComplexType = this.generateCollectionComplexType(collectionName, (Identifiable)variable);
        TopLevelElement collectionElement = new TopLevelElement();
        collectionElement.setName(name);
        collectionElement.setMinOccurs(minOccurs);
        collectionElement.setMaxOccurs("1");
        collectionElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.getObjectFactory().createElement(collectionElement));
        collectionElement.setComplexType(collectionComplexType);
    }

    protected void createParameterElement(ExplicitGroup all, Variable variable) {
        Named named = (Named)variable.getAnnotation(Named.class);
        String name = NameUtils.uncamel((String)variable.getName());
        if (named != null && named.value().length() > 0) {
            name = named.value();
        }
        TopLevelElement textElement = new TopLevelElement();
        textElement.setName(name);
        textElement.setMinOccurs(variable.isOptional() ? BigInteger.ZERO : BigInteger.ONE);
        textElement.setType(SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)variable.asTypeMirror().toString()));
        textElement.setDefault(variable.getDefaultValue());
        textElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.getObjectFactory().createElement(textElement));
    }

    private boolean checkSimpleName(String name) {
        assert (name != null);
        for (ComplexTypeHolder typeHolder : this.getRegisteredComplexTypesHolders()) {
            if (!name.equals(typeHolder.getType().getName())) continue;
            return false;
        }
        return true;
    }

    private boolean areEquals(Type type, Type typeHolderType) {
        return type.getClassName().equals(typeHolderType.getClassName()) && type.getPackage().equals(typeHolderType.getPackage());
    }

    protected boolean isTypeSupported(TypeMirror typeMirror) {
        return SchemaTypeConversion.isSupported((String)typeMirror.toString());
    }

    private boolean skipField(Field field) {
        return !field.hasGetter() || !field.hasSetter() || field.shouldBeIgnored();
    }

    private boolean generateNestedProcessor(Field field) {
        return field.asType().isNestedProcessor() || field.asType().isArrayOrList() && field.getTypeArguments().size() > 0 && ((Type)field.getTypeArguments().get(0)).isNestedProcessor();
    }

    protected Attribute createAttribute(String name, boolean optional, QName type, String description) {
        Attribute attr = new Attribute();
        attr.setName(name);
        attr.setUse(optional ? "optional" : "required");
        attr.setType(type);
        if (description != null) {
            attr.setAnnotation(this.createDocAnnotation(description));
        }
        return attr;
    }

    protected Attribute createAttribute(String name, boolean optional, QName type, String description, String defaultValue) {
        Attribute attr = new Attribute();
        attr.setName(name);
        attr.setUse(optional ? "optional" : "required");
        attr.setType(type);
        if (description != null) {
            attr.setAnnotation(this.createDocAnnotation(description));
        }
        if (defaultValue != null) {
            attr.setDefault(defaultValue);
        }
        return attr;
    }

    protected Attribute createAttribute(Variable variable, boolean forceOptional) {
        return this.createAttribute(variable, forceOptional, false);
    }

    private Attribute createAttribute(Variable variable, boolean forceOptional, boolean isParameter) {
        Named named = (Named)variable.getAnnotation(Named.class);
        String name = variable.getName();
        if (named != null && named.value().length() > 0) {
            name = named.value();
        }
        Attribute attribute = new Attribute();
        String optional = "optional";
        if (!forceOptional && !variable.isOptional() || variable instanceof Field && ((Field)variable).isRequired()) {
            optional = "required";
        }
        attribute.setUse(optional);
        if (isParameter && variable.asType().isString() && (variable.hasSizeLimit() || variable.hasPattern() || variable.hasEmailPattern())) {
            if (variable.hasPattern() || variable.hasEmailPattern()) {
                this.registerType(this.getSchema(), variable.getName() + "SizedType", SchemaConstants.STRING, variable.getMinSizeLimit(), variable.getMaxSizeLimit(), variable.getPattern());
            } else {
                this.registerType(this.getSchema(), variable.getName() + "SizedType", SchemaConstants.STRING, variable.getMinSizeLimit(), variable.getMaxSizeLimit());
            }
            attribute.setName(name);
            attribute.setType(new QName(this.getSchema().getTargetNamespace(), variable.getName() + "SizedType"));
        } else if (this.isTypeSupported(variable.asTypeMirror())) {
            attribute.setName(name);
            attribute.setType(SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)variable.asTypeMirror().toString()));
        } else if (variable.asType().isEnum()) {
            attribute.setName(name);
            attribute.setType(new QName(this.getSchema().getTargetNamespace(), variable.asType().getName() + "EnumType"));
            this.getRegisteredEnums().add((EnumType)variable.asType());
        } else if (variable.asType().inheritsFrom(HttpRequesterConfig.class)) {
            attribute.setName(name + "-ref");
            attribute.setType(SchemaConstants.STRING);
        } else if (isParameter && variable.asType().isHttpCallback()) {
            attribute.setName(NameUtils.uncamel((String)name) + "-flow-ref");
            attribute.setType(SchemaConstants.STRING);
        } else {
            attribute.setName(name + "-ref");
            attribute.setType(SchemaConstants.STRING);
        }
        String doc = isParameter ? variable.parent().getJavaDocParameterSummary(variable.getName()) : variable.getJavaDocSummary();
        attribute.setAnnotation(this.createDocAnnotation(doc));
        if (variable.hasDefaultValue()) {
            attribute.setDefault(variable.getDefaultValue());
        }
        return attribute;
    }

    protected void registerComplexTypeChildElement(ExplicitGroup all, Variable variable, boolean forceOptional) {
        LocalComplexType objectComplexType = new LocalComplexType();
        objectComplexType.setComplexContent(new ComplexContent());
        objectComplexType.getComplexContent().setExtension(new ExtensionType());
        objectComplexType.getComplexContent().getExtension().setBase(new QName(this.getSchema().getTargetNamespace(), this.registerComplexType(variable.asType())));
        TopLevelElement objectElement = new TopLevelElement();
        objectElement.setName(NameUtils.uncamel((String)variable.getName()));
        objectElement.setMinOccurs(!forceOptional && !variable.isOptional() ? BigInteger.ONE : BigInteger.ZERO);
        objectElement.setMaxOccurs("1");
        objectElement.setComplexType(objectComplexType);
        objectElement.setAnnotation(this.createDocAnnotation(variable.parent().getJavaDocParameterSummary(variable.getName())));
        all.getParticle().add(this.getObjectFactory().createElement(objectElement));
    }

    protected void registerType(Schema schema, String name, QName base) {
        this.registerType(schema, name, base, -1, -1);
    }

    protected void registerType(Schema schema, String name, QName base, int minlen, int maxlen) {
        this.registerType(schema, name, base, minlen, maxlen, SchemaConstants.DEFAULT_PATTERN);
    }

    private void registerType(Schema schema, String name, QName base, int minlen, int maxlen, String pattern) {
        TopLevelSimpleType simpleType = new TopLevelSimpleType();
        simpleType.setName(name);
        Union union = new Union();
        simpleType.setUnion(union);
        union.getSimpleType().add(this.createSimpleType(base, minlen, maxlen, pattern));
        union.getSimpleType().add(this.createExpressionAndPropertyPlaceHolderSimpleType());
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(simpleType);
    }

    protected LocalSimpleType createExpressionAndPropertyPlaceHolderSimpleType() {
        LocalSimpleType expression = new LocalSimpleType();
        Restriction restriction = new Restriction();
        expression.setRestriction(restriction);
        restriction.setBase(SchemaConstants.MULE_PROPERTY_PLACEHOLDER_TYPE);
        return expression;
    }

    private LocalSimpleType createSimpleType(QName base, int minlen, int maxlen) {
        return this.createSimpleType(base, minlen, maxlen, SchemaConstants.DEFAULT_PATTERN);
    }

    private LocalSimpleType createSimpleType(QName base, int minlen, int maxlen, String pattern) {
        JAXBElement element;
        LocalSimpleType simpleType = new LocalSimpleType();
        Restriction restriction = new Restriction();
        restriction.setBase(base);
        if (minlen != -1) {
            NumFacet minLenFacet = new NumFacet();
            minLenFacet.setValue(Integer.toString(minlen));
            element = this.getObjectFactory().createMinLength(minLenFacet);
            restriction.getFacets().add(element);
        }
        if (maxlen != -1) {
            NumFacet maxLenFacet = new NumFacet();
            maxLenFacet.setValue(Integer.toString(maxlen));
            element = this.getObjectFactory().createMaxLength(maxLenFacet);
            restriction.getFacets().add(element);
        }
        if (!SchemaConstants.DEFAULT_PATTERN.equals(pattern)) {
            Pattern xmlPattern = this.getObjectFactory().createPattern();
            xmlPattern.setValue(pattern);
            restriction.getFacets().add(xmlPattern);
        }
        simpleType.setRestriction(restriction);
        return simpleType;
    }

    protected Attribute createParameterAttribute(Variable variable, boolean forceOptional) {
        return this.createAttribute(variable, forceOptional, true);
    }

    protected void registerProcessorElement(boolean intercepting, String name, String typeName, String docText) {
        TopLevelElement element = new TopLevelElement();
        element.setName(name);
        element.setType(new QName(this.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.createDocAnnotation(docText));
        element.setSubstitutionGroup(intercepting ? SchemaConstants.MULE_ABSTRACT_INTERCEPTING_MESSAGE_PROCESSOR : SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }
}

