/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.devkit.api.exception.ConfigurationWarning;
import org.mule.devkit.api.lifecycle.LifeCycleManager;
import org.mule.devkit.api.lifecycle.MuleContextAwareManager;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.internal.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.internal.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.utils.NameUtils;

public class AbstractConnectionManagerGenerator
extends AbstractMetadataCodeGenerator {
    protected void generateNewConnectorMethod(GeneratedClass connectionManagerClass, GeneratedClass keyClass) {
        GeneratedMethod newConnector = connectionManagerClass.method(1, ConnectionManagementConnectorAdapter.class, "newConnector");
        newConnector.annotate(Override.class);
        GeneratedVariable connection = newConnector.param((Type)this.ref(ConnectionManagementConnectionAdapter.class).narrow(Object.class).narrow((TypeReference)keyClass), "connection");
        newConnector.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectionManagementConnectorAdapter.class), (GeneratedExpression)connection));
    }

    protected void generateNewConnectorMethod(Module module, GeneratedClass connectionManagerClass, ConnectionComponent component, GeneratedClass keyClass, Map<GeneratedField, GeneratedMethod> configurables, GeneratedClass connectorClass) {
        GeneratedMethod newConnector = connectionManagerClass.method(1, ConnectionManagementConnectorAdapter.class, "newConnector");
        newConnector.annotate(Override.class);
        GeneratedVariable connection = newConnector.param((Type)this.ref(ConnectionManagementConnectionAdapter.class).narrow(this.ref(component.asType())).narrow((TypeReference)keyClass), "connection");
        GeneratedVariable connector = newConnector.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        String connectionFieldName = StringUtils.capitalize((String)((Field)module.getConfigStrategy().get()).getName());
        newConnector.body().add((Statement)connector.invoke(NameUtils.buildSetter((String)connectionFieldName)).arg((GeneratedExpression)connection.invoke("getStrategy")));
        for (GeneratedField generatedField : configurables.keySet()) {
            newConnector.body().add((Statement)connector.invoke(NameUtils.buildSetter((String)generatedField.name())).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)configurables.get(generatedField))));
        }
        newConnector.body()._return((GeneratedExpression)connector);
    }

    protected void generateNewConnectionMethod(GeneratedClass connectionKeyClass, Type strategyAdapter, ConnectionComponent component) {
        GeneratedMethod newConnection = connectionKeyClass.method(1, ConnectionManagementConnectionAdapter.class, "newConnection");
        newConnection.annotate(Override.class);
        GeneratedVariable connection = newConnection.body().decl(strategyAdapter, "connection", (GeneratedExpression)ExpressionFactory._new((Type)strategyAdapter));
        for (Field field : component.getConfigurableFields()) {
            String param = StringUtils.capitalize((String)field.getName());
            newConnection.body().add((Statement)connection.invoke(NameUtils.buildSetter((String)param)).arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + param))));
        }
        newConnection.body()._return((GeneratedExpression)connection);
    }

    protected void generateGetDefaultConnectionKey(ConnectMethod connectMethod, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedMethod getDefaultConnectionKey = connectionManagerClass.method(1, (Type)connectionKeyClass, "getDefaultConnectionKey");
        getDefaultConnectionKey.annotate(Override.class);
        GeneratedInvocation newConnectionKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : connectMethod.getParameters()) {
            newConnectionKey.arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)parameter.getName()))));
        }
        getDefaultConnectionKey.body()._return((GeneratedExpression)newConnectionKey);
    }

    protected void generateGetEvaluatedConnectionKey(ConnectMethod connectMethod, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass, GeneratedField muleContext) {
        GeneratedMethod getEvaluatedConnectionKey = connectionManagerClass.method(1, (Type)connectionKeyClass, "getEvaluatedConnectionKey");
        getEvaluatedConnectionKey.annotate(Override.class);
        getEvaluatedConnectionKey._throws(Exception.class);
        GeneratedVariable event = getEvaluatedConnectionKey.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedBlock ifNotNull = getEvaluatedConnectionKey.body()._if(event.isNotNull())._then();
        GeneratedInvocation newKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : connectMethod.getParameters()) {
            GeneratedVariable transformedVariable = this.declareTransformedVariable((Variable)parameter, (GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)parameter.getName()))), (GeneratedExpression)ExpressionFactory._this().invoke("getClass").invoke("getDeclaredField").arg(parameter.getName()).invoke("getGenericType"), event, ifNotNull, (GeneratedExpression)muleContext);
            newKey.arg((GeneratedExpression)transformedVariable);
            if (parameter.isOptional()) continue;
            ifNotNull._if(transformedVariable.isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnableToAcquireConnectionException.class)).arg(MessageConstants.nullNotOptionalParameter(parameter.getName(), connectMethod.getName())));
        }
        ifNotNull._return((GeneratedExpression)newKey);
        getEvaluatedConnectionKey.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
    }

    protected void generateAcquireConnectionMethod(GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass, TypeReference connectorClass) {
        GeneratedMethod borrowConnector = connectionManagerClass.method(1, (Type)connectorClass, "acquireConnection");
        GeneratedVariable key = borrowConnector.param((Type)connectionKeyClass, "key");
        borrowConnector._throws(this.ref(Exception.class));
        borrowConnector.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)connectionPool.invoke("borrowObject").arg((GeneratedExpression)key)));
    }

    protected void generateReturnConnectionMethod(GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass, TypeReference connectorClass) {
        GeneratedMethod returnConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "releaseConnection");
        GeneratedVariable key = returnConnector.param((Type)connectionKeyClass, "key");
        returnConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = returnConnector.param((Type)connectorClass, "connection");
        returnConnector.body().add((Statement)connectionPool.invoke("returnObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    protected void generateDestroyConnectionMethod(GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass, TypeReference connectorClass) {
        GeneratedMethod destroyConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyConnection");
        GeneratedVariable key = destroyConnector.param((Type)connectionKeyClass, "key");
        destroyConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = destroyConnector.param((Type)connectorClass, "connection");
        destroyConnector.body().add((Statement)connectionPool.invoke("invalidateObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    protected GeneratedField generateFieldForConnectionPool(GeneratedClass connectionManagerClass) {
        GeneratedField connectionPool = connectionManagerClass.field(4, (Type)this.ref(KeyedObjectPool.class), "connectionPool");
        connectionPool.javadoc().add((Object)"Connector Pool");
        return connectionPool;
    }

    protected Map<GeneratedField, GeneratedMethod> generateConfigurablesWithSettersAndGetters(GeneratedClass connectionManagerClass, List<Field> configurableFields) {
        HashMap<GeneratedField, GeneratedMethod> fieldMap = new HashMap<GeneratedField, GeneratedMethod>();
        for (Field field : configurableFields) {
            GeneratedField configField = connectionManagerClass.field(4, this.ref(field.asTypeMirror()), field.getName());
            connectionManagerClass.setter(configField);
            GeneratedMethod getter = connectionManagerClass.getter(configField);
            fieldMap.put(configField, getter);
        }
        return fieldMap;
    }

    protected void generateTestMethodForStrategiesEnabledConnector(GeneratedClass connectionManagerClass, Type strategyAdapter) {
        GeneratedMethod testMethod = connectionManagerClass.method(1, (Type)this.ref(TestResult.class), "test");
        GeneratedTry tryTestConnection = testMethod.body()._try();
        GeneratedVariable strategy = tryTestConnection.body().decl(strategyAdapter, "strategy", (GeneratedExpression)ExpressionFactory.cast((Type)strategyAdapter, (GeneratedExpression)ExpressionFactory.invoke((String)"newConnection")));
        tryTestConnection.body().staticInvoke(this.ref(MuleContextAwareManager.class), "setMuleContext").arg((GeneratedExpression)strategy).arg((GeneratedExpression)ExpressionFactory._this().ref("muleContext"));
        tryTestConnection.body().staticInvoke(this.ref(LifeCycleManager.class), "executeInitialiseAndStart").arg((GeneratedExpression)strategy);
        GeneratedVariable connectorAdapter = tryTestConnection.body().decl((Type)this.ref(ConnectionManagementConnectorAdapter.class), "connectorAdapter", (GeneratedExpression)ExpressionFactory.invoke((String)"newConnector").arg((GeneratedExpression)strategy));
        tryTestConnection.body().staticInvoke(this.ref(MuleContextAwareManager.class), "setMuleContext").arg((GeneratedExpression)connectorAdapter).arg((GeneratedExpression)ExpressionFactory._this().ref("muleContext"));
        tryTestConnection.body().staticInvoke(this.ref(LifeCycleManager.class), "executeInitialiseAndStart").arg((GeneratedExpression)connectorAdapter);
        tryTestConnection.body().add((Statement)strategy.invoke("test").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey")));
        tryTestConnection.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("SUCCESS")));
        GeneratedCatchBlock catchTestConnectionWarning = tryTestConnection._catch(this.ref(ConfigurationWarning.class));
        GeneratedVariable warning = catchTestConnectionWarning.param("warning");
        catchTestConnectionWarning.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultTestResult.class), (GeneratedExpression)this.ref(ConnectivityTestingErrorHandler.class).staticInvoke("buildWarningTestResult").arg((GeneratedExpression)warning)));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultTestResult.class), (GeneratedExpression)this.ref(ConnectivityTestingErrorHandler.class).staticInvoke("buildFailureTestResult").arg((GeneratedExpression)e)));
    }

    protected void generateInitialiseMethod(GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedField poolingConfig, GeneratedField retryPolicyTemplate) {
        GeneratedMethod initialisableMethod = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        GeneratedInvocation newObjectFactory = ExpressionFactory._new((TypeReference)this.ref(ConnectionManagementConnectorFactory.class));
        newObjectFactory.arg(ExpressionFactory._this());
        initialisableMethod.body().assign((AssignmentTarget)connectionPool, (GeneratedExpression)ExpressionFactory._new((TypeReference)((TypeReference)this.ctx().getProduct(Product.POOL_IMPL))).arg((GeneratedExpression)newObjectFactory).arg((GeneratedExpression)poolingConfig));
        GeneratedConditional ifRetryPolicyTemplateIsNull = initialisableMethod.body()._if(retryPolicyTemplate.isNull());
        ifRetryPolicyTemplateIsNull._then().assign((AssignmentTarget)retryPolicyTemplate, (GeneratedExpression)ExpressionFactory.ref((String)"muleContext").invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE")));
    }

    protected void generateGetConnectionAdapter(Module module, GeneratedClass connectionManagerClass, Type connectorClass) {
        GeneratedMethod getConnectionAdapter = connectionManagerClass.method(1, ConnectionManagementConnectionAdapter.class, "getConnectionAdapter");
        GeneratedVariable adapter = getConnectionAdapter.param((Type)this.ref(ConnectionManagementConnectorAdapter.class), "adapter");
        GeneratedVariable connector = getConnectionAdapter.body().decl(connectorClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)adapter));
        String connectionFieldName = StringUtils.capitalize((String)((Field)module.getConfigStrategy().get()).getName());
        GeneratedVariable strategy = getConnectionAdapter.body().decl((Type)this.ref(ConnectionManagementConnectionAdapter.class), "strategy", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectionManagementConnectionAdapter.class), (GeneratedExpression)connector.invoke("get" + connectionFieldName)));
        getConnectionAdapter.body()._return((GeneratedExpression)strategy);
    }

    protected void generateGetConnectionManagementProcessTemplateMethod(GeneratedClass connectionManagerClass, Type connectorAdapterClass) {
        GeneratedMethod getProcessTemplate = connectionManagerClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow(connectorAdapterClass));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConnectionManagementProcessTemplate.class)).arg(ExpressionFactory._this()).arg((GeneratedExpression)ExpressionFactory.ref((String)"muleContext")));
    }
}

