/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.apidoc;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SampleLoader {
    private static final String DOC_FOLDER_DIR = System.getProperty("user.dir") + File.separator + "doc";
    private String moduleName;
    private Optional<String> samplesFileContent = Optional.absent();
    private Map<String, List<String>> samples;

    public SampleLoader(String moduleName) throws IOException {
        this.moduleName = moduleName;
        Optional docFiles = Optional.fromNullable((Object)new File(DOC_FOLDER_DIR).listFiles());
        if (docFiles.isPresent()) {
            for (File file : (File[])docFiles.get()) {
                if (!file.getName().endsWith("xml.sample")) continue;
                String content = new String(Files.readAllBytes(file.toPath()));
                this.samplesFileContent = Optional.fromNullable((Object)content);
                break;
            }
        }
    }

    public SampleLoader(String moduleName, File samples) throws IOException {
        this.moduleName = moduleName;
        String content = new String(Files.readAllBytes(samples.toPath()));
        this.samplesFileContent = Optional.of((Object)content);
    }

    public List<String> loadSamples(String operationJavaName) {
        String id;
        if (this.samples == null) {
            this.samples = this.parseSamples();
        }
        return this.samples.get(id = this.moduleName + ":" + operationJavaName) != null ? this.samples.get(id) : new ArrayList<String>();
    }

    private Map<String, List<String>> parseSamples() {
        HashMap<String, List<String>> samplesMap = new HashMap<String, List<String>>();
        if (!this.samplesFileContent.isPresent()) {
            return samplesMap;
        }
        String samples = (String)this.samplesFileContent.get();
        String beginInclude = "<!-- BEGIN_INCLUDE(";
        String endInclude = "<!-- END_INCLUDE(";
        String closeInclude = ") -->";
        while (samples.contains(beginInclude)) {
            String id = samples.substring(samples.indexOf(beginInclude), samples.indexOf(closeInclude)).replace(beginInclude, "");
            String beginTag = beginInclude + id + closeInclude;
            String endTag = endInclude + id + closeInclude;
            if (!samplesMap.containsKey(id)) {
                samplesMap.put(id, new ArrayList());
            }
            String sample = samples.substring(samples.indexOf(beginTag), samples.indexOf(endTag)).replace(beginTag, "");
            samplesMap.get(id).add(sample.trim());
            samples = samples.substring(samples.indexOf(endTag) + endTag.length());
        }
        return samplesMap;
    }
}

