/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.strategies;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.TestConnectivity;
import org.mule.api.annotations.components.WsdlProvider;
import org.mule.api.annotations.lifecycle.OnException;
import org.mule.api.annotations.ws.WsdlBodyEnricher;
import org.mule.api.annotations.ws.WsdlHeaders;
import org.mule.api.annotations.ws.WsdlSecurity;
import org.mule.api.annotations.ws.WsdlServiceEndpoint;
import org.mule.api.annotations.ws.WsdlServiceRetriever;
import org.mule.api.annotations.ws.WsdlTransportRetriever;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.verifiers.metadata.MetaDataAnnotationVerifierUtils;
import org.mule.devkit.verifiers.strategies.ConnectionManagementVerifier;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;
import org.mule.devkit.verifiers.util.VerifierUtils;
import org.w3c.dom.Document;

public class WsdlProviderAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return !module.manager().wsdlProviderComponent().isEmpty();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            this.verifyWsdlComponent(module, gatherer, wsdlProviderComponent);
        }
        this.verifyNoProcessors(module, gatherer);
        this.verifyNoConfigurables(module, gatherer);
        this.verifyCompatibleComponents(module, module.manager().wsdlProviderComponent(), gatherer);
        this.verifyMinMuleVersion(module, gatherer);
    }

    private void verifyMinMuleVersion(Module module, NotificationGatherer gatherer) {
        String minSupporterWsdlProviderVersion = "3.7";
        if (!module.getMinMuleVersion().atLeast(minSupporterWsdlProviderVersion)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.MIN_MULE_VERSION_FEATURE_SUPPORT, new Object[]{minSupporterWsdlProviderVersion, "@" + WsdlProvider.class.getName(), module.getMinMuleVersion().toString()});
        }
    }

    private void verifyCompatibleComponents(Module module, List<WsdlProviderComponent> components, NotificationGatherer gatherer) {
        if (components.size() > 1 && this.consistentServiceRetrievers(module, gatherer, components)) {
            LinkedList<String> foundSeparators = new LinkedList<String>();
            LinkedList<String> foundLabels = new LinkedList<String>();
            for (WsdlProviderComponent component : components) {
                if (!foundSeparators.contains(component.keySeparator())) {
                    foundSeparators.add(component.keySeparator());
                }
                if (foundLabels.contains(component.plainedKeyLabels())) continue;
                foundLabels.add(component.plainedKeyLabels());
            }
            this.verifySameSeparator(module, gatherer, foundSeparators);
            this.verifySameLabels(module, gatherer, foundLabels);
        }
    }

    private boolean consistentServiceRetrievers(Module module, NotificationGatherer gatherer, List<WsdlProviderComponent> components) {
        boolean validRetrievers = true;
        LinkedList<String> serviceRetrieverReturnTypes = new LinkedList<String>();
        Iterator<WsdlProviderComponent> componentIt = components.iterator();
        while (componentIt.hasNext() && validRetrievers) {
            Method serviceRetriever = componentIt.next().wsdlServiceRetrieverMethod();
            if (serviceRetriever != null) {
                if (serviceRetrieverReturnTypes.contains(serviceRetriever.getReturnType().toString())) continue;
                serviceRetrieverReturnTypes.add(serviceRetriever.getReturnType().toString());
                continue;
            }
            validRetrievers = false;
        }
        if (!validRetrievers) {
            return false;
        }
        if (serviceRetrieverReturnTypes.size() != 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.SERVICE_DEFINITION_MULTIPLE_RETURN_TYPES, new Object[]{StringUtils.join(serviceRetrieverReturnTypes, (String)" - ")});
            return false;
        }
        return true;
    }

    private void verifySameLabels(Module module, NotificationGatherer gatherer, List<String> foundLabels) {
        if (foundLabels.size() != 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.INVALID_KEY_LABELS_INCONSISTENT, new Object[]{StringUtils.join(foundLabels, (String)" - ")});
        }
    }

    private void verifySameSeparator(Module module, NotificationGatherer gatherer, List<String> foundSeparators) {
        if (foundSeparators.size() != 1) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.INVALID_KEY_SEPARATOR_INCONSISTENT, new Object[]{StringUtils.join(foundSeparators, (String)" - ")});
        }
    }

    private void verifyWsdlComponent(Module module, NotificationGatherer gatherer, WsdlProviderComponent wsdlProviderComponent) throws AnnotationVerificationException {
        this.verifyServiceRetriever(module, wsdlProviderComponent, gatherer);
        this.verifyServiceEndpoint(wsdlProviderComponent, gatherer);
        this.verifyWsdlSecurity(wsdlProviderComponent, gatherer);
        this.verifyWsdlTransport(wsdlProviderComponent, gatherer);
        this.verifyWsdlHeader(wsdlProviderComponent, gatherer);
        this.verifyWsdlBodyEnricher(module, wsdlProviderComponent, gatherer);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableGetterAndSetter(gatherer, (ConnectionComponent)wsdlProviderComponent);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableFields(module, gatherer, (ConnectionComponent)wsdlProviderComponent);
        if (wsdlProviderComponent.hasConnectionManagement()) {
            this.verifyWsdlConnectionManagement(module, gatherer);
        } else {
            ConnectionStrategiesVerifierUtils.verifyTestConnectionMethod((ConnectionComponent)wsdlProviderComponent, wsdlProviderComponent.getMethodsAnnotatedWith(TestConnectivity.class), gatherer);
        }
    }

    private void verifyWsdlConnectionManagement(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        ConnectionManagementVerifier verifier = new ConnectionManagementVerifier();
        verifier.verify(module, gatherer);
    }

    private void verifyNoProcessors(Module module, NotificationGatherer gatherer) {
        if (!module.getMethodsAnnotatedWith(Processor.class).isEmpty()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.NO_PROCESSORS_ALLOWED_IN_CLASS_WITH_WSDL_PROVIDER, new Object[]{module.getClassName()});
        }
    }

    private void verifyNoConfigurables(Module module, NotificationGatherer gatherer) {
        if (!module.getConfigurableFields().isEmpty()) {
            gatherer.errorAll(module.getConfigurableFields(), (DevkitNotification)Message.NO_CONFIGURABLES_ALLOWED_IN_CLASS_WITH_WSDL_PROVIDER, new Object[]{module.getClassName()});
        }
    }

    private void verifyServiceRetriever(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method serviceRetriever = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlServiceRetriever.class);
        if (serviceRetriever != null) {
            Type wsdlServiceList;
            if (wsdlProviderComponent.getRecursivelyMethodsAnnotatedWith(WsdlServiceRetriever.class).size() != 1) {
                gatherer.error((Identifiable)serviceRetriever, (DevkitNotification)Message.TOO_MANY_METHODS_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceRetriever.class.getName(), 1, wsdlProviderComponent.getMethodsAnnotatedWith(WsdlServiceRetriever.class).size()});
            }
            if (!VerifierUtils.returnTypeEqualsType(serviceRetriever, (wsdlServiceList = new TypeToken<List<ServiceDefinition>>(){}.getType()).toString()) && !VerifierUtils.returnTypeEqualsType(serviceRetriever, ServiceDefinition.class.getName())) {
                gatherer.error((Identifiable)serviceRetriever, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlServiceRetriever.class.getName(), wsdlServiceList.toString() + " or " + ServiceDefinition.class.getName()});
            }
            if (!serviceRetriever.getParameters().isEmpty()) {
                gatherer.error((Identifiable)serviceRetriever, (DevkitNotification)Message.ANNOTATED_METHOD_NO_PARAMS, new Object[]{WsdlServiceRetriever.class.getName()});
            }
            this.verifyKeySeparator(wsdlProviderComponent, gatherer);
            this.verifyKeyLabels(wsdlProviderComponent, gatherer);
        } else {
            gatherer.error((Identifiable)wsdlProviderComponent, (DevkitNotification)Message.MISSING_METHOD_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceRetriever.class.getName()});
        }
    }

    private void verifyServiceEndpoint(WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method addressResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlServiceEndpoint.class);
        if (addressResolver != null) {
            if (wsdlProviderComponent.getRecursivelyMethodsAnnotatedWith(WsdlServiceEndpoint.class).size() != 1) {
                gatherer.error((Identifiable)addressResolver, (DevkitNotification)Message.TOO_MANY_METHODS_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceEndpoint.class.getName(), 1, wsdlProviderComponent.getMethodsAnnotatedWith(WsdlServiceEndpoint.class).size()});
            }
            if (!VerifierUtils.returnTypeEqualsType(addressResolver, String.class.getName())) {
                gatherer.error((Identifiable)addressResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlServiceEndpoint.class.getName(), String.class.getName()});
            }
            if (!VerifierUtils.parametersMatchExpectedTypes(addressResolver, ServiceDefinition.class)) {
                gatherer.error((Identifiable)addressResolver, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_ONE_ALLOWED, new Object[]{WsdlServiceEndpoint.class.getName(), ServiceDefinition.class.getName()});
            }
        } else {
            gatherer.error((Identifiable)wsdlProviderComponent, (DevkitNotification)Message.MISSING_METHOD_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlServiceEndpoint.class.getName()});
        }
    }

    private void verifyWsdlSecurity(WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method strategyResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlSecurity.class);
        if (strategyResolver != null) {
            Type wsdlSecurityList = new TypeToken<List<WsdlSecurityStrategy>>(){}.getType();
            if (!VerifierUtils.returnTypeEqualsType(strategyResolver, wsdlSecurityList.toString())) {
                gatherer.error((Identifiable)strategyResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlSecurity.class.getName(), wsdlSecurityList.toString()});
            }
            if (!VerifierUtils.parametersMatchExpectedTypes(strategyResolver, ServiceDefinition.class)) {
                gatherer.error((Identifiable)strategyResolver, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_ONE_ALLOWED, new Object[]{WsdlSecurity.class.getName(), ServiceDefinition.class.getName()});
            }
        }
    }

    private void verifyWsdlTransport(WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method transportResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlTransportRetriever.class);
        if (transportResolver != null) {
            if (!VerifierUtils.returnTypeEqualsType(transportResolver, WsdlTransport.class.getName())) {
                gatherer.error((Identifiable)transportResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlTransport.class.getName(), WsdlTransport.class.getName()});
            }
            if (!VerifierUtils.parametersMatchExpectedTypes(transportResolver, ServiceDefinition.class)) {
                gatherer.error((Identifiable)transportResolver, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_ONE_ALLOWED, new Object[]{WsdlTransport.class.getName(), ServiceDefinition.class.getName()});
            }
        }
    }

    private void verifyWsdlHeader(WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        Method headersResolver = wsdlProviderComponent.getFirstMethodAnnotatedWith(WsdlHeaders.class);
        if (headersResolver != null) {
            Type listString = new TypeToken<List<Document>>(){}.getType();
            if (!VerifierUtils.returnTypeEqualsType(headersResolver, listString.toString())) {
                gatherer.error((Identifiable)headersResolver, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlHeaders.class.getName(), listString});
            }
            if (!VerifierUtils.parametersMatchExpectedTypes(headersResolver, ServiceDefinition.class, String.class)) {
                gatherer.error((Identifiable)headersResolver, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_THIS_ALLOWED, new Object[]{WsdlHeaders.class.getName(), ServiceDefinition.class.getName() + ", " + String.class.getName()});
            }
        }
    }

    private void verifyWsdlBodyEnricher(Module module, WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        List methodsAnnotatedWithEnricher = wsdlProviderComponent.getMethodsAnnotatedWith(WsdlBodyEnricher.class);
        if (!methodsAnnotatedWithEnricher.isEmpty()) {
            if (methodsAnnotatedWithEnricher.size() > 1) {
                gatherer.error((Identifiable)wsdlProviderComponent, (DevkitNotification)Message.TOO_MANY_METHODS_ANNOTATED_WITH_IN_WSDL_PROVIDER, new Object[]{WsdlBodyEnricher.class.getName(), "1", methodsAnnotatedWithEnricher.size()});
            } else {
                Method bodyEnricher = (Method)methodsAnnotatedWithEnricher.get(0);
                if (!VerifierUtils.returnTypeEqualsType(bodyEnricher, Document.class.getName())) {
                    gatherer.error((Identifiable)bodyEnricher, (DevkitNotification)Message.ANNOTATED_METHOD_RETURN_TYPE, new Object[]{WsdlBodyEnricher.class.getName(), Document.class.getName()});
                }
                if (!VerifierUtils.parametersMatchExpectedTypes(bodyEnricher, ServiceDefinition.class, String.class, Document.class)) {
                    gatherer.error((Identifiable)bodyEnricher, (DevkitNotification)Message.INVALID_PARAMETERS_FOR_METHOD_ONLY_THIS_ALLOWED, new Object[]{WsdlBodyEnricher.class.getName(), ServiceDefinition.class.getName() + ", " + String.class.getName() + ", " + Document.class.getName()});
                }
            }
            if (!module.hasAnnotation(OnException.class)) {
                gatherer.warn((Identifiable)module, (DevkitNotification)Message.MISSING_ON_EXCEPTION_STRATEGY, new Object[]{"When using the @WsdlBodyEnricher, it is recommended to have a custom exception handling strategy in order to simplify troubleshooting"});
            }
        }
    }

    private void verifyKeySeparator(WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        MetaDataAnnotationVerifierUtils.verifyMetaDataKeySeparator(wsdlProviderComponent.wsdlServiceRetrieverMethod(), wsdlProviderComponent.keySeparator(), gatherer);
    }

    private void verifyKeyLabels(WsdlProviderComponent wsdlProviderComponent, NotificationGatherer gatherer) {
        List labels = wsdlProviderComponent.keyLabels();
        MetaDataAnnotationVerifierUtils.verifyMetaDataKeyLabels(wsdlProviderComponent.wsdlServiceRetrieverMethod(), labels, gatherer);
        Type wsdlServiceList = new TypeToken<List<ServiceDefinition>>(){}.getType();
        if (VerifierUtils.returnTypeEqualsType(wsdlProviderComponent.wsdlServiceRetrieverMethod(), ServiceDefinition.class.getName()) && labels.size() != 1) {
            gatherer.error((Identifiable)wsdlProviderComponent.wsdlServiceRetrieverMethod(), (DevkitNotification)Message.INVALID_NUMBER_OF_KEY_LABELS, new Object[]{String.format("Expected 1 label but %s were found. Override the default labels when returning a single ServiceDefinition", labels.size())});
        } else if (VerifierUtils.returnTypeEqualsType(wsdlProviderComponent.wsdlServiceRetrieverMethod(), wsdlServiceList.toString()) && labels.size() != 2) {
            gatherer.error((Identifiable)wsdlProviderComponent.wsdlServiceRetrieverMethod(), (DevkitNotification)Message.INVALID_NUMBER_OF_KEY_LABELS, new Object[]{String.format("Expected 2 labels but %s were found. Two labels are required when overriding the defaults", labels.size())});
        }
    }
}

