/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.ArrayList;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;

public class ValidationAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            for (Parameter variable : processorMethod.getParameters()) {
                if (variable.hasSizeLimit() && !variable.asType().isString() && !variable.asType().isCollection()) {
                    gatherer.error((Identifiable)variable, (DevkitNotification)Message.SIZE_ANNOTATION_INCORRECT_ARGUMENT_TYPE, new Object[]{variable.asType().getName()});
                }
                if (!variable.hasPattern() || variable.asType().isString()) continue;
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.PATTERN_ANNOTATION_INCORRECT_ARGUMENT_TYPE, new Object[]{variable.asType().getName()});
            }
        }
        ArrayList<Parameter> defaultPayloadParams = new ArrayList<Parameter>();
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            defaultPayloadParams.clear();
            for (Parameter param : processorMethod.getParameters()) {
                if (!param.hasDefaultPayload()) continue;
                defaultPayloadParams.add(param);
            }
            if (defaultPayloadParams.size() <= 1) continue;
            for (Parameter param : defaultPayloadParams) {
                gatherer.error((Identifiable)param, (DevkitNotification)Message.DEFAULT_VALUE_CANNOT_BE_PAYLOAD_MORE_THAN_ONCE, new Object[0]);
            }
        }
    }
}

