/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.client.MuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.common.MuleVersion;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.utils.NameUtils;
import org.mule.util.queue.QueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAndInjectAdapterGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.LIFECYCLE_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void generate(Module module) {
        GeneratedClass lifecycleAdapter = this.getLifecycleAdapterClass(module);
        lifecycleAdapter.javadoc().add((Object)("A <code>" + lifecycleAdapter.name() + "</code> is a wrapper around "));
        lifecycleAdapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        lifecycleAdapter.javadoc().add((Object)" that adds lifecycle methods to the pojo.");
        this.generateStartMethod(module, lifecycleAdapter);
        this.generateStopMethod(module, lifecycleAdapter);
        this.generateInitMethod(module, lifecycleAdapter);
        this.generateDisposeMethod(module, lifecycleAdapter);
        this.generateSetMuleContextMethod(module, lifecycleAdapter);
    }

    private void generateSetMuleContextMethod(Module module, GeneratedClass adapter) {
        adapter._implements(this.ref(MuleContextAware.class));
        adapter.javadoc().add((Object)" This adapter also allows the injection of several Mule facilities when a MuleContext is set.");
        GeneratedMethod setMuleContext = adapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        setMuleContext.annotate(Override.class);
        GeneratedVariable context = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        if (module.getInjectFields().isEmpty()) {
            return;
        }
        for (Field variable : module.getInjectFields()) {
            if (variable.asTypeMirror().toString().startsWith(MuleContext.class.getName())) {
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)context));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ObjectStoreManager.class.getName())) {
                GeneratedCast getObjectStoreManager = ExpressionFactory.cast((Type)this.ref(ObjectStoreManager.class), (GeneratedExpression)context.invoke("getRegistry").invoke("get").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_STORE_MANAGER")));
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getObjectStoreManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(TransactionManager.class.getName())) {
                GeneratedInvocation getTransactionManager = context.invoke("getTransactionManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getTransactionManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(QueueManager.class.getName())) {
                GeneratedInvocation getQueueManager = context.invoke("getQueueManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getQueueManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ObjectStore.class.getName())) {
                GeneratedConditional notNull = setMuleContext.body()._if(Op.eq((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)variable.getName()))), (GeneratedExpression)ExpressionFactory._null()));
                GeneratedInvocation getObjectStore = context.invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_STORE_DEFAULT_IN_MEMORY_NAME"));
                notNull._then().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ObjectStore.class), (GeneratedExpression)getObjectStore)));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(MuleConfiguration.class.getName())) {
                GeneratedInvocation getConfiguration = context.invoke("getConfiguration");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getConfiguration));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(LifecycleManager.class.getName())) {
                GeneratedInvocation getLifecycleManager = context.invoke("getLifecycleManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getLifecycleManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ClassLoader.class.getName())) {
                GeneratedInvocation getExecutionClassLoader = context.invoke("getExecutionClassLoader");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getExecutionClassLoader));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ExpressionManager.class.getName())) {
                GeneratedInvocation getExpressionManager = context.invoke("getExpressionManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getExpressionManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(EndpointFactory.class.getName())) {
                GeneratedInvocation getEndpointFactory = context.invoke("getEndpointFactory");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getEndpointFactory));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(MuleClient.class.getName())) {
                GeneratedInvocation getClient = context.invoke("getClient");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getClient));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(SystemExceptionHandler.class.getName())) {
                GeneratedInvocation getExceptionListener = context.invoke("getExceptionListener");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getExceptionListener));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(SecurityManager.class.getName())) {
                GeneratedInvocation getSecurityManager = context.invoke("getSecurityManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getSecurityManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(WorkManager.class.getName())) {
                GeneratedInvocation getWorkManager = context.invoke("getWorkManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getWorkManager));
                continue;
            }
            if (!variable.asTypeMirror().toString().startsWith(Registry.class.getName()) && !variable.asTypeMirror().toString().startsWith(MuleRegistry.class.getName())) continue;
            GeneratedInvocation getRegistry = context.invoke("getRegistry");
            setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getRegistry));
        }
    }

    private void generateDisposeMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method disposeMethod = module.getLifecycleMethod("dispose");
        lifecycleAdapter._implements(Disposable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends org.mule.devkit.model.Type>)disposeMethod, "dispose", null, false);
    }

    private void generateInitMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method initMethod = module.getLifecycleMethod("initialise");
        lifecycleAdapter._implements(Initialisable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends org.mule.devkit.model.Type>)initMethod, "initialise", InitialisationException.class, true);
    }

    private void generateStopMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method stopMethod = module.getLifecycleMethod("stop");
        lifecycleAdapter._implements(Stoppable.class);
        GeneratedMethod stop = this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends org.mule.devkit.model.Type>)stopMethod, "stop", MuleException.class, false);
    }

    private void generateStartMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method startMethod = module.getLifecycleMethod("start");
        lifecycleAdapter._implements(Startable.class);
        GeneratedMethod start = this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends org.mule.devkit.model.Type>)startMethod, "start", MuleException.class, false);
    }

    private GeneratedClass getLifecycleAdapterClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.adapters");
        GeneratedClass previous = ((GeneratedClass)this.ctx().getProduct(Product.METADATA_ADAPTER, (Identifiable)module)).topLevelClass();
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "LifecycleInjectionAdapter", (TypeReference)previous);
        this.ctx().registerProduct(Product.LIFECYCLE_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }

    private GeneratedMethod generateLifecycleInvocation(GeneratedClass lifecycleWrapper, Module module, Method<? extends org.mule.devkit.model.Type> superExecutableElement, String name, Class<?> catchException, boolean addThis) {
        GeneratedMethod lifecycleMethod = lifecycleWrapper.method(1, (Type)this.ctx().getCodeModel().VOID, name);
        lifecycleMethod.annotate(this.ref(Override.class));
        if (name.equals("initialise")) {
            GeneratedVariable log = lifecycleMethod.body().decl((Type)this.ref(Logger.class), "log", (GeneratedExpression)this.ref(LoggerFactory.class).staticInvoke("getLogger").arg(lifecycleWrapper.dotclass()));
            GeneratedVariable connectorVersion = lifecycleMethod.body().decl((Type)this.ref(MuleVersion.class), "connectorVersion", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleVersion.class)).arg(ExpressionFactory.lit((String)module.getMinMuleVersion().toString())));
            GeneratedVariable muleVersion = lifecycleMethod.body().decl((Type)this.ref(MuleVersion.class), "muleVersion", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleVersion.class)).arg((GeneratedExpression)this.ref(MuleManifest.class).staticInvoke("getProductVersion")));
            GeneratedConditional ifversionatleast = lifecycleMethod.body()._if(Op.not((GeneratedExpression)muleVersion.invoke("atLeastBase").arg((GeneratedExpression)connectorVersion)));
            ifversionatleast._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(InitialisationException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("minMuleVersionNotMet").arg((GeneratedExpression)ExpressionFactory._this().invoke("getMinMuleVersion"))).arg(ExpressionFactory._this()));
        }
        if (catchException != null) {
            lifecycleMethod._throws(this.ref(catchException));
        }
        if (superExecutableElement != null) {
            GeneratedInvocation startInvocation = ExpressionFactory._super().invoke(superExecutableElement.getName());
            boolean foundNonCatchException = false;
            for (TypeMirror exception : superExecutableElement.getThrownTypes()) {
                if (catchException.getName().toString().equals(exception.toString())) continue;
                foundNonCatchException = true;
            }
            if (foundNonCatchException) {
                GeneratedTry tryBlock = lifecycleMethod.body()._try();
                tryBlock.body().add((Statement)startInvocation);
                int i = 0;
                for (TypeMirror exception : superExecutableElement.getThrownTypes()) {
                    GeneratedCatchBlock catchBlock = tryBlock._catch(this.ref(exception).boxify());
                    GeneratedVariable catchedException = catchBlock.param("e" + i);
                    GeneratedInvocation newMuleException = null;
                    newMuleException = catchException.getName().toString().equals(MuleException.class.getName()) ? ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)) : ExpressionFactory._new((TypeReference)this.ref(catchException));
                    newMuleException.arg((GeneratedExpression)catchedException);
                    if (addThis) {
                        newMuleException.arg(ExpressionFactory._this());
                    }
                    catchBlock.body()._throw((GeneratedExpression)newMuleException);
                    ++i;
                }
            } else {
                lifecycleMethod.body().add((Statement)startInvocation);
            }
        }
        return lifecycleMethod;
    }
}

