/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import org.mule.api.callback.HttpCallback;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.util.NumberUtils;

public class HttpCallbackAdapterGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    public static final String LOCAL_PORT_FIELD_NAME = "localPort";
    public static final String REMOTE_PORT_FIELD_NAME = "remotePort";
    public static final String DOMAIN_FIELD_NAME = "domain";
    public static final String ASYNC_FIELD_NAME = "async";
    public static final String PATH_FIELD_NAME = "path";
    public static final String DEFAULT_ACCESS_TOKEN_ID_FIELD_NAME = "defaultAccessTokenId";
    public static final String CONNECTOR_FIELD_NAME = "connector";
    private static final int DEFAULT_LOCAL_PORT = 8080;
    private static final int DEFAULT_REMOTE_PORT = 80;
    private static final List<Product> CONSUMES = Arrays.asList(Product.ADAPTER_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(new Product[0]);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.hasProcessorMethodWithParameter(HttpCallback.class);
    }

    public void generate(Module module) {
        GeneratedClass httpCallbackAdapter = this.getHttpCallbackAdapterClass(module);
        GeneratedField localPort = this.localPortFieldWithGetterAndSetter(httpCallbackAdapter);
        GeneratedField remotePort = this.remotePortFieldWithGetterAndSetter(httpCallbackAdapter);
        GeneratedField domain = this.domainFieldWithGetterAndSetter(httpCallbackAdapter);
        GeneratedField path = this.pathFieldWithGetterAndSetter(httpCallbackAdapter);
        this.connectorFieldWithGetterAndSetter(httpCallbackAdapter);
        GeneratedField logger = FieldBuilder.newLoggerField((GeneratedClass)httpCallbackAdapter);
        this.asyncFieldWithGetterAndSetter(httpCallbackAdapter);
        this.generateInitialiseMethod(httpCallbackAdapter, localPort, remotePort, domain, logger);
    }

    private void generateInitialiseMethod(GeneratedClass httpCallbackAdapter, GeneratedField localPort, GeneratedField remotePort, GeneratedField domain, GeneratedField logger) {
        GeneratedMethod initialise = httpCallbackAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialise._throws(this.ref(InitialisationException.class));
        if (this.ref(Initialisable.class).isAssignableFrom(httpCallbackAdapter._extends())) {
            initialise.body().invoke(ExpressionFactory._super(), "initialise");
        }
        GeneratedBlock ifLocalPortIsNull = initialise.body()._if(localPort.isNull())._then();
        this.initialiseLocalPort(localPort, logger, ifLocalPortIsNull);
        GeneratedBlock ifRemotePortIsNull = initialise.body()._if(remotePort.isNull())._then();
        ifRemotePortIsNull.invoke((GeneratedExpression)logger, "info").arg(ExpressionFactory.lit((String)"Using default remotePort: 80"));
        ifRemotePortIsNull.assign((AssignmentTarget)remotePort, ExpressionFactory.lit((int)80));
        GeneratedBlock ifDomainIsNull = initialise.body()._if(domain.isNull())._then();
        this.assignDomainSystemVariable(domain, logger, ifDomainIsNull);
    }

    private void initialiseLocalPort(GeneratedField localPort, GeneratedField logger, GeneratedBlock ifPortIsNull) {
        GeneratedVariable portSystemVar = ifPortIsNull.decl((Type)this.ref(String.class), "portSystemVar", (GeneratedExpression)this.ref(System.class).staticInvoke("getProperty").arg("http.port"));
        GeneratedConditional conditional = ifPortIsNull._if((GeneratedExpression)this.ref(NumberUtils.class).staticInvoke("isDigits").arg((GeneratedExpression)portSystemVar));
        conditional._then().block().assign((AssignmentTarget)localPort, (GeneratedExpression)this.ref(Integer.class).staticInvoke("parseInt").arg((GeneratedExpression)portSystemVar));
        GeneratedBlock thenBlock = conditional._else().block();
        thenBlock.invoke((GeneratedExpression)logger, "warn").arg(ExpressionFactory.lit((String)"Environment variable 'http.port' not found, using default localPort: 8080"));
        thenBlock.assign((AssignmentTarget)localPort, ExpressionFactory.lit((int)8080));
    }

    private void assignDomainSystemVariable(GeneratedField domain, GeneratedField logger, GeneratedBlock ifDomainIsNull) {
        GeneratedVariable domainSystemVar = ifDomainIsNull.decl((Type)this.ref(String.class), "domainSystemVar", (GeneratedExpression)this.ref(System.class).staticInvoke("getProperty").arg("fullDomain"));
        GeneratedConditional conditional = ifDomainIsNull._if(domainSystemVar.isNotNull());
        conditional._then().block().assign((AssignmentTarget)domain, (GeneratedExpression)domainSystemVar);
        GeneratedBlock thenBlock = conditional._else().block();
        thenBlock.invoke((GeneratedExpression)logger, "warn").arg("Environment variable 'fullDomain' not found, using default: localhost");
        thenBlock.assign((AssignmentTarget)domain, ExpressionFactory.lit((String)"localhost"));
    }

    private GeneratedClass getHttpCallbackAdapterClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.adapters");
        GeneratedClass previous = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass httpCallbackAdapterClass = pkg._class(modifiers, module.getClassName() + "HttpCallbackAdapter", (TypeReference)previous);
        httpCallbackAdapterClass._implements(this.ref(Initialisable.class));
        httpCallbackAdapterClass._implements(this.ref(HttpCallbackAdapter.class));
        return httpCallbackAdapterClass;
    }

    private GeneratedField localPortFieldWithGetterAndSetter(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Integer.class).name(LOCAL_PORT_FIELD_NAME).getterAndSetter().build();
    }

    private GeneratedField remotePortFieldWithGetterAndSetter(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Integer.class).name(REMOTE_PORT_FIELD_NAME).getterAndSetter().build();
    }

    private GeneratedField domainFieldWithGetterAndSetter(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(DOMAIN_FIELD_NAME).getterAndSetter().build();
    }

    private GeneratedField pathFieldWithGetterAndSetter(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(PATH_FIELD_NAME).getterAndSetter().build();
    }

    private GeneratedField connectorFieldWithGetterAndSetter(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Object.class).name(CONNECTOR_FIELD_NAME).getterAndSetter().build();
    }

    private GeneratedField asyncFieldWithGetterAndSetter(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Boolean.class).name(ASYNC_FIELD_NAME).initialValue(ExpressionFactory.lit((boolean)false)).getterAndSetter().build();
    }
}

