/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.visitor.EnumTypeVisitor;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

@JustOnce
public class EnumTransformerGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.TRANSFORMER, Product.REGISTRY_BOOTSTRAP_ENTRY);
    private Set<Type> registeredEnums = new HashSet<Type>();

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) {
        EnumTypeVisitor visitor = new EnumTypeVisitor();
        for (Module module : modules) {
            module.accept((ModelVisitor)visitor);
        }
        this.registeredEnums = visitor.getRegisteredEnums();
        for (Type enumType : this.registeredEnums) {
            this.registerEnumTransformer((Identifiable)enumType);
        }
    }

    private void registerEnumTransformer(Identifiable variableElement) {
        GeneratedClass transformerClass = this.getEnumTransformerClass(variableElement);
        this.ctx().note("Generating enum transformer for " + variableElement.asType().getName() + " as " + transformerClass.binaryName());
        GeneratedField weighting = transformerClass.field(4, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "weighting", (GeneratedExpression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"));
        this.generateConstructor(transformerClass, variableElement);
        this.generateDoTransform(transformerClass, variableElement);
        this.generateGetPriorityWeighting(transformerClass, weighting);
        this.generateSetPriorityWeighting(transformerClass, weighting);
    }

    private void generateSetPriorityWeighting(GeneratedClass jaxbTransformerClass, GeneratedField weighting) {
        GeneratedMethod setPriorityWeighting = jaxbTransformerClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "setPriorityWeighting");
        GeneratedVariable localWeighting = setPriorityWeighting.param((org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)weighting), (GeneratedExpression)localWeighting);
    }

    private void generateGetPriorityWeighting(GeneratedClass jaxbTransformerClass, GeneratedField weighting) {
        GeneratedMethod getPriorityWeighting = jaxbTransformerClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((GeneratedExpression)weighting);
    }

    private void generateDoTransform(GeneratedClass jaxbTransformerClass, Identifiable variableElement) {
        GeneratedMethod doTransform = jaxbTransformerClass.method(2, (org.mule.devkit.model.code.Type)this.ref(Object.class), "doTransform");
        doTransform._throws(TransformerException.class);
        GeneratedVariable src = doTransform.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "src");
        doTransform.param((org.mule.devkit.model.code.Type)this.ref(String.class), "encoding");
        GeneratedVariable result = doTransform.body().decl((org.mule.devkit.model.code.Type)this.ref(variableElement.asTypeMirror()).boxify(), "result", ExpressionFactory._null());
        GeneratedInvocation valueOf = this.ref(Enum.class).staticInvoke("valueOf");
        valueOf.arg(this.ref(variableElement.asTypeMirror()).boxify().dotclass());
        valueOf.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(String.class), (GeneratedExpression)src));
        doTransform.body().assign((AssignmentTarget)result, (GeneratedExpression)valueOf);
        doTransform.body()._return((GeneratedExpression)result);
    }

    private void generateConstructor(GeneratedClass transformerClass, Identifiable variableElement) {
        GeneratedMethod constructor = transformerClass.constructor(1);
        this.registerSourceTypes(constructor);
        this.registerDestinationType(constructor, this.ref(variableElement.asTypeMirror()).boxify());
        constructor.body().invoke("setName").arg(transformerClass.name());
    }

    private void registerDestinationType(GeneratedMethod constructor, TypeReference clazz) {
        GeneratedInvocation setReturnClass = constructor.body().invoke("setReturnClass");
        setReturnClass.arg(ExpressionFactory.dotclass((org.mule.devkit.model.code.Type)clazz));
    }

    private void registerSourceTypes(GeneratedMethod constructor) {
        GeneratedInvocation registerSourceType = constructor.body().invoke("registerSourceType");
        registerSourceType.arg((GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(String.class).boxify().dotclass()));
    }

    private <T extends Identifiable> GeneratedClass getEnumTransformerClass(T variableElement) {
        String packageName = "";
        if (variableElement instanceof Type) {
            packageName = ((Type)variableElement).getPackage().getName();
        } else if (variableElement instanceof Parameter) {
            packageName = ((Type)((Method)((Parameter)variableElement).parent()).parent()).getPackage().getName();
        } else if (variableElement instanceof Field) {
            packageName = ((Type)((Field)variableElement).parent()).getPackage().getName();
        }
        packageName = packageName.startsWith("java.") ? packageName.replace("java.", "javawrapper.") : packageName;
        String clazzName = variableElement.asType().getName();
        if (((TypeElement)variableElement.asType().unwrap()).getNestingKind() == NestingKind.MEMBER) {
            clazzName = ((TypeElement)variableElement.asType().unwrap()).getEnclosingElement().getSimpleName().toString() + clazzName;
        }
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(packageName + ".generated.transformers");
        GeneratedClass transformer = pkg._class(clazzName + "EnumTransformer", AbstractTransformer.class, new Class[]{DiscoverableTransformer.class});
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, null, transformer.name(), (Object)transformer);
        return transformer;
    }
}

