/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.components.WsdlProvider;
import org.mule.api.annotations.licensing.RequiresEnterpriseLicense;
import org.mule.api.annotations.licensing.RequiresEntitlement;
import org.mule.devkit.generation.api.AbstractBaseProjectVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ConnectorCategory;
import org.mule.devkit.generation.api.MavenInformation;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;

public class MavenInfoProjectVerifier
extends AbstractBaseProjectVerifier {
    public boolean shouldVerify(List modules) {
        return true;
    }

    public List<Module> processableModules(List<Module> modules) {
        return modules;
    }

    public void verify(List<Module> modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        MavenInformation mavenInfo = this.ctx().getMavenInformation();
        String category = mavenInfo.getCategory();
        if (!ArrayUtils.contains((Object[])ConnectorCategory.getValidCategories(), (Object)category)) {
            this.getGatherer().error((Identifiable)modules.get(0), (DevkitNotification)Message.INVALID_CATEGORY, new Object[]{category, Arrays.toString(ConnectorCategory.getValidCategories())});
        }
        if (StringUtils.equalsIgnoreCase((String)category, (String)ConnectorCategory.COMMUNITY.getCategory())) {
            this.verifyCommunityRunsOnCE(modules, gatherer);
        } else {
            this.verifyNonCommunityRunsOnEEOnly(modules, gatherer, category);
        }
    }

    private void verifyNonCommunityRunsOnEEOnly(List<Module> modules, NotificationGatherer gatherer, String category) {
        for (Module module : modules) {
            if (module.requiresEnterpriseLicense()) continue;
            gatherer.error((Identifiable)module, (DevkitNotification)Message.NON_COMMUNITY_CATEGORY_REQUIRES_LICENSE, new Object[]{category, RequiresEnterpriseLicense.class.getSimpleName(), ConnectorCategory.COMMUNITY.getCategory()});
        }
    }

    private void verifyCommunityRunsOnCE(List<Module> modules, NotificationGatherer gatherer) {
        for (Module module : modules) {
            if (!module.requiresEnterpriseLicense()) continue;
            if (module.manager().wsdlProviderComponent().isEmpty()) {
                String invalidAnnotation = "Remove the annotation " + (module.hasAnnotation(RequiresEnterpriseLicense.class) ? RequiresEnterpriseLicense.class.getSimpleName() : RequiresEntitlement.class.getSimpleName());
                gatherer.error((Identifiable)module, (DevkitNotification)Message.COMMUNITY_CATEGORY_REQUIRES_LICENSE, new Object[]{invalidAnnotation});
                continue;
            }
            gatherer.error((Identifiable)module, (DevkitNotification)Message.COMMUNITY_CATEGORY_REQUIRES_LICENSE, new Object[]{"Don`t use the " + WsdlProvider.class.getSimpleName() + " strategy"});
        }
    }
}

