/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.ws;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.mule.api.DefaultMuleException;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.devkit.api.ws.authentication.WsdlSecurityStrategy;
import org.mule.devkit.api.ws.definition.ServiceDefinition;
import org.mule.devkit.api.ws.transport.WsdlTransport;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.connectivity.AbstractConnectionManagerGenerator;
import org.mule.devkit.generation.connectivity.metadata.ConnectorMetaDataEnabledUtilsGenerator;
import org.mule.devkit.generation.utils.MuleGeneratorUtils;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.internal.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.internal.ws.common.WSResolver;
import org.mule.devkit.internal.ws.common.WsdlAdapter;
import org.mule.devkit.internal.ws.connection.DefaultProcessTemplate;
import org.mule.devkit.internal.ws.metadata.WsdlMetaDataDescriptor;
import org.mule.devkit.internal.ws.model.DefaultWSResolver;
import org.mule.devkit.internal.ws.model.SoapBodyEnricher;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.components.exceptionhandler.OnExceptionHandlerComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.devkit.utils.NameUtils;
import org.w3c.dom.Document;

public class WsdlProviderConnectorAdapterGenerator
extends AbstractConnectionManagerGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_ADAPTER, Product.STRATEGY_ADAPTER, Product.CONNECTION_KEY, Product.CONNECTION_MANAGEMENT_CONNECTOR_ADAPTER, Product.POOL_IMPL, Product.POOL_CONFIG, Product.CACHE_IMPL, Product.CACHE_CONFIG);
    private static final List<Product> PRODUCES = Arrays.asList(Product.WSDL_PROVIDER_CONNECTOR_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return !module.manager().wsdlProviderComponent().isEmpty();
    }

    public void generate(Module module) throws GenerationException {
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            this.generateWsdlAdapterFor(module, wsdlProviderComponent);
        }
    }

    private void generateWsdlAdapterFor(Module module, WsdlProviderComponent wsdlProviderComponent) throws GenerationException {
        ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator = new ConnectorMetaDataEnabledUtilsGenerator();
        connectorMetaDataEnabledUtilsGenerator.setCtx(this.ctx());
        GeneratedClass wsdlProviderAdapterClass = this.createBasicAdapter(module, wsdlProviderComponent);
        this.generateClassJavaDoc(module, wsdlProviderComponent, wsdlProviderAdapterClass);
        this.generateWsdlAdapterMethods(module, wsdlProviderAdapterClass, wsdlProviderComponent);
        if (wsdlProviderComponent.hasConnectionManagement()) {
            this.generateConnectionManagementMethods(module, wsdlProviderComponent, wsdlProviderAdapterClass);
        } else {
            this.generateMetadataMethods(wsdlProviderAdapterClass);
            connectorMetaDataEnabledUtilsGenerator.generateGenericTestConnectivity(module, (ConnectionComponent)wsdlProviderComponent, wsdlProviderAdapterClass);
            this.generateGetProcessTemplate(wsdlProviderAdapterClass);
        }
    }

    private void generateWsdlAdapterMethods(Module module, GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent) {
        wsdlProviderAdapterClass._implements(WsdlAdapter.class);
        GeneratedField wsResolverField = wsdlProviderAdapterClass.field(4, (Type)this.ref(WSResolver.class), "wsResolver");
        this.generateWsdlConfigField(module, wsdlProviderComponent, wsdlProviderAdapterClass);
        GeneratedClass lifecycleAdapter = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        GeneratedField connectorAdapter = wsdlProviderAdapterClass.field(2, (Type)lifecycleAdapter.topLevelClass(), "connector");
        this.generateInitializeConnectorMethod(module, wsdlProviderAdapterClass, connectorAdapter, lifecycleAdapter);
        GeneratedMethod getConnectorMethod = this.generateGetConnectorMethod(wsdlProviderAdapterClass, connectorAdapter);
        GeneratedInvocation getStrategy = ExpressionFactory.invoke((String)NameUtils.buildGetter((String)((Field)module.getConfigStrategy().get()).getName()));
        GeneratedInvocation getConnector = ExpressionFactory.invoke((GeneratedMethod)getConnectorMethod);
        this.generateLifeCycleMethods(module, wsdlProviderAdapterClass, wsdlProviderComponent, wsResolverField, connectorAdapter, getStrategy, getConnector);
        this.generateServiceDefinitionsMethod(wsdlProviderAdapterClass, wsdlProviderComponent, getStrategy);
        this.generateServiceEndpointMethod(wsdlProviderAdapterClass, wsdlProviderComponent, getStrategy);
        this.generateWsdlSeparatorMethod(wsdlProviderAdapterClass, wsdlProviderComponent);
        this.generateStrategiesMethod(wsdlProviderAdapterClass, wsdlProviderComponent, getStrategy);
        this.generateTransportMethod(wsdlProviderAdapterClass, wsdlProviderComponent, getStrategy);
        this.generateHeadersMethod(wsdlProviderAdapterClass, wsdlProviderComponent, getStrategy);
        this.generateInitializeWsResolverMethod(wsdlProviderAdapterClass, wsResolverField);
        this.generateWsResolverMethod(wsdlProviderAdapterClass, wsResolverField);
        this.generateSingleServiceDefinitionId(wsdlProviderAdapterClass, wsdlProviderComponent);
        this.generateExceptionHandler(wsdlProviderAdapterClass, module, getConnector);
        this.generateManagedExceptions(wsdlProviderAdapterClass, module);
        this.generateBodyEnricher(wsdlProviderAdapterClass, wsdlProviderComponent, getStrategy);
    }

    private void generateLifeCycleMethods(Module module, GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedField wsResolverField, GeneratedField connectorAdapter, GeneratedInvocation getStrategy, GeneratedInvocation getConnector) {
        this.generateDisposeMethod(wsdlProviderAdapterClass, wsResolverField, connectorAdapter);
        if (module.setMuleContext().isPresent() || wsdlProviderComponent.setMuleContext().isPresent()) {
            this.generateSetMuleContext(module, wsdlProviderComponent, wsdlProviderAdapterClass, getStrategy, getConnector);
        }
        if (module.startable().isPresent() || wsdlProviderComponent.startable().isPresent()) {
            this.generateStartable(module, wsdlProviderComponent, wsdlProviderAdapterClass, getStrategy, getConnector);
        }
        if (module.stoppable().isPresent() || wsdlProviderComponent.stoppable().isPresent()) {
            this.generateStoppable(module, wsdlProviderComponent, wsdlProviderAdapterClass, getStrategy, getConnector);
        }
    }

    private void generateConnectionManagementMethods(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass) throws GenerationException {
        ConnectMethod connectMethod = wsdlProviderComponent.getConnectMethod();
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)wsdlProviderComponent, module.getName());
        GeneratedClass connectionManagerClass = this.addConnectionManagerInterfaces(module, wsdlProviderComponent, wsdlProviderAdapterClass, connectionKeyClass);
        this.generateStandardFieldForEachParameter(connectionManagerClass, (Method)connectMethod);
        Map<GeneratedField, GeneratedMethod> moduleConfigurables = this.generateConfigurablesWithSettersAndGetters(connectionManagerClass, module.getConfigurableFields());
        Map<GeneratedField, GeneratedMethod> componentConfigurables = this.generateConfigurablesWithSettersAndGetters(connectionManagerClass, wsdlProviderComponent.getConfigurableFields());
        GeneratedField muleContext = connectionManagerClass.muleContextField();
        TypeReference poolConfig = MuleGeneratorUtils.getPoolConfig(module, this.ctx());
        GeneratedField connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        GeneratedField poolingConfig = connectionManagerClass.field(2, (Type)poolConfig, StringUtils.uncapitalize((String)poolConfig.name()));
        GeneratedField retryPolicyTemplate = connectionManagerClass.field(2, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        connectionManagerClass.setter(poolingConfig);
        connectionManagerClass.getter(poolingConfig);
        connectionManagerClass.setter(retryPolicyTemplate);
        connectionManagerClass.getter(retryPolicyTemplate);
        GeneratedClass strategyAdapter = (GeneratedClass)this.ctx().getProduct(Product.STRATEGY_ADAPTER, (Identifiable)wsdlProviderComponent, module.getName());
        this.generateAcquireConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, (TypeReference)wsdlProviderAdapterClass);
        this.generateReturnConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, this.ref(WsdlAdapter.class));
        this.generateDestroyConnectionMethod(connectionManagerClass, connectionPool, connectionKeyClass, this.ref(WsdlAdapter.class));
        this.generateIsCapableOfMethod(module, connectionManagerClass);
        this.generateGetDefaultConnectionKey(connectMethod, connectionManagerClass, connectionKeyClass);
        this.generateGetEvaluatedConnectionKey(connectMethod, connectionManagerClass, connectionKeyClass, muleContext);
        this.generateMetadataConstantsAndGetters(module, connectionManagerClass);
        this.generateGetConnectionKeyMethod(connectionManagerClass, connectionKeyClass);
        this.generateGetConnectionManagementProcessTemplateMethod(connectionManagerClass, (Type)this.ref(WsdlAdapter.class));
        this.generateGetConnectionAdapter(module, connectionManagerClass, (Type)wsdlProviderAdapterClass);
        this.generateNewConnectionMethod(connectionManagerClass, (Type)strategyAdapter, (ConnectionComponent)wsdlProviderComponent);
        this.generateNewConnectorMethod(module, connectionManagerClass, (ConnectionComponent)wsdlProviderComponent, connectionKeyClass, moduleConfigurables, wsdlProviderAdapterClass);
        this.generateTestMethodForStrategiesEnabledConnector(connectionManagerClass, (Type)strategyAdapter);
        this.generateConnectionManagedMetadataMethods(connectionManagerClass, connectionKeyClass);
        this.generateInitialiseMethod(connectionManagerClass, connectionPool, poolingConfig, retryPolicyTemplate, MuleGeneratorUtils.getPoolImpl(module, this.ctx()));
    }

    private void generateGetConnectionKeyMethod(GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedMethod execute = connectionManagerClass.method(1, (Type)connectionKeyClass, "getConnectionKey");
        execute.annotate(Override.class);
        execute._throws(Exception.class);
        execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        execute.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"getEvaluatedConnectionKey").arg((GeneratedExpression)event));
    }

    private GeneratedClass addConnectionManagerInterfaces(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements(this.ref(Capabilities.class));
        connectionManagerClass._implements(this.ref(ConnectionManagementConnectorAdapter.class));
        if (!connectionManagerClass.implementsClass(MuleContextAware.class)) {
            connectionManagerClass._implements(this.ref(MuleContextAware.class));
        }
        connectionManagerClass._implements(this.ref(ConnectionManagementConnectionManager.class).narrow((TypeReference)connectionKeyClass).narrow(WsdlAdapter.class).narrow(this.ref(wsdlProviderComponent.asType())));
        connectionManagerClass._implements(this.ref(MetadataAware.class));
        connectionManagerClass._implements(this.ref(ProcessAdapter.class).narrow(WsdlAdapter.class));
        connectionManagerClass._implements(this.ref(Testable.class));
        connectionManagerClass._extends(ExpressionEvaluatorSupport.class);
        this.ctx().registerProduct(Product.CONNECTION_MANAGER, (Identifiable)wsdlProviderComponent, module.getName(), (Object)connectionManagerClass);
        return connectionManagerClass;
    }

    private void generateSetMuleContext(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass, GeneratedInvocation getStrategy, GeneratedInvocation getConnector) {
        wsdlProviderAdapterClass._implements(this.ref(MuleContextAware.class));
        GeneratedMethod setMuleContextMethod = wsdlProviderAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        setMuleContextMethod.annotate(Override.class);
        GeneratedVariable muleContextParam = setMuleContextMethod.param((Type)this.ref(MuleContext.class), "muleContext");
        if (wsdlProviderComponent.setMuleContext().isPresent()) {
            setMuleContextMethod.body().add((Statement)getStrategy.invoke(((Field)wsdlProviderComponent.setMuleContext().get()).getSetter().getName()).arg((GeneratedExpression)muleContextParam));
        }
        if (module.setMuleContext().isPresent()) {
            setMuleContextMethod.body().add((Statement)getConnector.invoke(((Field)module.setMuleContext().get()).getSetter().getName()).arg((GeneratedExpression)muleContextParam));
        }
    }

    private void generateStartable(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass, GeneratedInvocation getStrategy, GeneratedInvocation getConnector) {
        wsdlProviderAdapterClass._implements(this.ref(Startable.class));
        GeneratedMethod startMethod = wsdlProviderAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod.annotate(Override.class);
        startMethod._throws(this.ref(MuleException.class));
        GeneratedTry generatedTry = startMethod.body()._try();
        if (wsdlProviderComponent.startable().isPresent()) {
            generatedTry.body().add((Statement)getStrategy.invoke(((Method)wsdlProviderComponent.startable().get()).getName()));
        }
        if (module.startable().isPresent()) {
            generatedTry.body().add((Statement)getConnector.invoke(((Method)module.startable().get()).getName()));
        }
        GeneratedCatchBlock generatedCatchBlock = generatedTry._catch(this.ref(Exception.class));
        GeneratedVariable e = generatedCatchBlock.param("e");
        generatedCatchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg((GeneratedExpression)e));
    }

    private void generateStoppable(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass, GeneratedInvocation getStrategy, GeneratedInvocation getConnector) {
        wsdlProviderAdapterClass._implements(this.ref(Stoppable.class));
        GeneratedMethod stopMethod = wsdlProviderAdapterClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod.annotate(Override.class);
        stopMethod._throws(this.ref(MuleException.class));
        GeneratedTry generatedTry = stopMethod.body()._try();
        if (wsdlProviderComponent.stoppable().isPresent()) {
            generatedTry.body().add((Statement)getStrategy.invoke(((Method)wsdlProviderComponent.stoppable().get()).getName()));
        }
        if (module.stoppable().isPresent()) {
            generatedTry.body().add((Statement)getConnector.invoke(((Method)module.stoppable().get()).getName()));
        }
        GeneratedCatchBlock generatedCatchBlock = generatedTry._catch(this.ref(Exception.class));
        GeneratedVariable e = generatedCatchBlock.param("e");
        generatedCatchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg((GeneratedExpression)e));
    }

    private void generateDisposeMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField wsResolverField, GeneratedField connectorAdapter) {
        wsdlProviderAdapterClass._implements(Disposable.class);
        GeneratedMethod wsdlAdapterDisposable = wsdlProviderAdapterClass.method(1, Void.TYPE, "dispose");
        wsdlAdapterDisposable.annotate(Override.class);
        wsdlAdapterDisposable.body()._if(wsResolverField.isNotNull())._then().add((Statement)wsResolverField.invoke("dispose")).assign((AssignmentTarget)wsResolverField, ExpressionFactory._null());
        wsdlAdapterDisposable.body()._if(connectorAdapter.isNotNull())._then().add((Statement)connectorAdapter.invoke("dispose")).assign((AssignmentTarget)connectorAdapter, ExpressionFactory._null());
    }

    private void generateManagedExceptions(GeneratedClass wsdlProviderAdapterClass, Module module) {
        GeneratedMethod managedExceptionsMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(List.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "managedExceptions");
        managedExceptionsMethod.annotate(Override.class);
        LinkedList<GeneratedExpression> exceptionClasses = new LinkedList<GeneratedExpression>();
        for (AnnotationValue reconnectionException : module.reconnectOn()) {
            exceptionClasses.add(this.ref(reconnectionException.getValue().toString()).boxify().dotclass());
        }
        if (exceptionClasses.isEmpty()) {
            managedExceptionsMethod.body()._return(ExpressionFactory._null());
        } else {
            GeneratedArray newExceptionArray = ExpressionFactory.newArray((Type)this.ref(Class.class));
            for (GeneratedExpression generatedExpression : exceptionClasses) {
                newExceptionArray.add(generatedExpression);
            }
            managedExceptionsMethod.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(Class.class).narrow(this.ref(Exception.class).wildcard()).array(), (GeneratedExpression)newExceptionArray)));
        }
    }

    private void generateExceptionHandler(GeneratedClass wsdlProviderAdapterClass, Module module, GeneratedInvocation getConnector) {
        GeneratedMethod handleExceptionMethod = wsdlProviderAdapterClass.method(1, Void.TYPE, "handleException");
        handleExceptionMethod.annotate(Override.class);
        handleExceptionMethod._throws(Exception.class);
        GeneratedVariable exceptionVar = handleExceptionMethod.param((Type)this.ref(Exception.class), "e");
        if (module.manager().handlerComponent().isPresent()) {
            OnExceptionHandlerComponent onExceptionHandlerComponent = (OnExceptionHandlerComponent)module.manager().handlerComponent().get();
            Type handlerRef = this.ref(((TypeElement)onExceptionHandlerComponent.unwrap()).asType());
            GeneratedVariable handler = handleExceptionMethod.body().decl(this.ref(((TypeElement)onExceptionHandlerComponent.unwrap()).asType()), "handler", (GeneratedExpression)ExpressionFactory._new((Type)handlerRef));
            Optional moduleInjectionSetter = onExceptionHandlerComponent.getModuleInjectionSetter(module.getQualifiedName().toString());
            if (moduleInjectionSetter.isPresent()) {
                handleExceptionMethod.body().invoke((GeneratedExpression)handler, (String)moduleInjectionSetter.get()).arg((GeneratedExpression)getConnector);
            }
            handleExceptionMethod.body().invoke((GeneratedExpression)handler, onExceptionHandlerComponent.getExceptionHandle().getName()).arg((GeneratedExpression)exceptionVar);
        } else {
            handleExceptionMethod.body().add(ExpressionFactory.inlineComment((String)"No handler found"));
        }
    }

    private GeneratedMethod generateGetConnectorMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField connectorAdapter) {
        GeneratedMethod getter = wsdlProviderAdapterClass.method(1, connectorAdapter.type(), NameUtils.buildGetter((String)connectorAdapter.name()));
        getter.javadoc().add((Object)("Retrieves " + connectorAdapter.name()));
        GeneratedTry initTry = getter.body()._if(Op.eq((GeneratedExpression)connectorAdapter, (GeneratedExpression)ExpressionFactory._null()))._then()._try();
        initTry.body().invoke("initializeConnectorAdapter");
        GeneratedCatchBlock initCatchBlock = initTry._catch(this.ref(Exception.class));
        initCatchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("An error occurred while creating the connector instance").arg((GeneratedExpression)initCatchBlock.param("e")));
        getter.body()._return((GeneratedExpression)ExpressionFactory._this().ref((GeneratedVariable)connectorAdapter));
        return getter;
    }

    private void generateWsdlConfigField(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass) {
        GeneratedField configField = wsdlProviderAdapterClass.field(4, this.ref(wsdlProviderComponent.asTypeMirror()), ((Field)module.getConfigStrategy().get()).getName());
        wsdlProviderAdapterClass.getter(configField);
        wsdlProviderAdapterClass.setter(configField);
    }

    private void generateSingleServiceDefinitionId(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedMethod wsResolverMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(Optional.class).narrow(String.class), "singleServiceDefinitionId");
        wsResolverMethod.annotate(Override.class);
        wsResolverMethod._throws(Exception.class);
        GeneratedInvocation generatedExpression = wsdlProviderComponent.hasMultipleServiceDefinition() ? this.ref(Optional.class).staticInvoke("absent") : this.ref(Optional.class).staticInvoke("of").arg((GeneratedExpression)ExpressionFactory._this().invoke("wsResolver").invoke("serviceDefinitions").invoke("values").invoke("asList").invoke("get").arg(ExpressionFactory.lit((int)0)).invoke("getId"));
        wsResolverMethod.body()._return((GeneratedExpression)generatedExpression);
    }

    private void generateInitializeWsResolverMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField wsResolverField) {
        GeneratedMethod initializeWsResolverMethod = wsdlProviderAdapterClass.method(132, Void.TYPE, "initializeWsResolver");
        initializeWsResolverMethod._throws(Exception.class);
        GeneratedBlock ifNullBlock = initializeWsResolverMethod.body()._if(Op.eq((GeneratedExpression)wsResolverField, (GeneratedExpression)ExpressionFactory._null()))._then();
        ifNullBlock.assign((AssignmentTarget)wsResolverField, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultWSResolver.class)).arg(ExpressionFactory._this()));
    }

    private void generateInitializeConnectorMethod(Module module, GeneratedClass wsdlProviderAdapterClass, GeneratedField connectorAdapter, GeneratedClass processAdapter) {
        GeneratedMethod initializeWsResolverMethod = wsdlProviderAdapterClass.method(132, Void.TYPE, "initializeConnectorAdapter");
        initializeWsResolverMethod._throws(Exception.class);
        GeneratedBlock ifNullBlock = initializeWsResolverMethod.body()._if(Op.eq((GeneratedExpression)connectorAdapter, (GeneratedExpression)ExpressionFactory._null()))._then();
        ifNullBlock.assign((AssignmentTarget)connectorAdapter, (GeneratedExpression)ExpressionFactory._new((TypeReference)processAdapter.topLevelClass()));
        ifNullBlock.add((Statement)connectorAdapter.invoke(NameUtils.buildSetter((String)((Field)module.getConfigStrategy().get()).getName())).arg((GeneratedExpression)ExpressionFactory.invoke((String)NameUtils.buildGetter((String)((Field)module.getConfigStrategy().get()).getName()))));
        ifNullBlock.add((Statement)connectorAdapter.invoke("initialise"));
    }

    private void generateWsResolverMethod(GeneratedClass wsdlProviderAdapterClass, GeneratedField wsResolverField) {
        GeneratedMethod wsResolverMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(WSResolver.class), "wsResolver");
        wsResolverMethod.annotate(Override.class);
        wsResolverMethod._throws(Exception.class);
        wsResolverMethod.body().invoke("initializeWsResolver");
        wsResolverMethod.body()._return((GeneratedExpression)wsResolverField);
    }

    private void generateTransportMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedInvocation wsdlProviderCastStrategy) {
        GeneratedMethod transportMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(WsdlTransport.class), "transport");
        transportMethod.annotate(Override.class);
        GeneratedVariable serviceDefinitionParam = transportMethod.param(ServiceDefinition.class, "serviceDefinition");
        Optional transportOptional = wsdlProviderComponent.wsdlTransportResolver();
        Object transportMethodInvocation = transportOptional.isPresent() ? wsdlProviderCastStrategy.invoke(((Method)transportOptional.get()).getName()).arg((GeneratedExpression)serviceDefinitionParam) : ExpressionFactory._null();
        transportMethod.body()._return(transportMethodInvocation);
    }

    private void generateHeadersMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedInvocation wsdlProviderCastStrategy) {
        GeneratedMethod headerMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(Optional.class).narrow(this.ref(List.class).narrow(Document.class)), "headers");
        headerMethod.annotate(Override.class);
        headerMethod._throws(Exception.class);
        GeneratedVariable serviceDefinitionParam = headerMethod.param(ServiceDefinition.class, "serviceDefinition");
        GeneratedVariable operationName = headerMethod.param(String.class, "operationName");
        Optional headersMethodOptional = wsdlProviderComponent.wsdlHeadersResolver();
        Object headerMethodInvocation = headersMethodOptional.isPresent() ? wsdlProviderCastStrategy.invoke(((Method)headersMethodOptional.get()).getName()).arg((GeneratedExpression)serviceDefinitionParam).arg((GeneratedExpression)operationName) : ExpressionFactory._null();
        headerMethod.body()._return((GeneratedExpression)this.ref(Optional.class).staticInvoke("fromNullable").arg(headerMethodInvocation));
    }

    private void generateBodyEnricher(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedInvocation getStrategy) {
        GeneratedMethod bodyEnricherMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(Optional.class).narrow(this.ref(SoapBodyEnricher.class).wildcard()), "bodyEnricher");
        bodyEnricherMethod.annotate(Override.class);
        Optional wsdlPayloadEnricher = wsdlProviderComponent.wsdlBodyEnricher();
        if (wsdlPayloadEnricher.isPresent()) {
            GeneratedVariable finalConfig = bodyEnricherMethod.body().decl(8, this.ref(wsdlProviderComponent.asTypeMirror()), "config", (GeneratedExpression)getStrategy);
            GeneratedClass enricherImpl = this.ctx().getCodeModel().anonymousClass(this.ref(SoapBodyEnricher.class));
            GeneratedMethod processMethod = enricherImpl.method(1, (Type)this.ref(Document.class), "process");
            GeneratedVariable service = processMethod.param(ServiceDefinition.class, "service");
            GeneratedVariable operationName = processMethod.param(String.class, "operationName");
            GeneratedVariable body = processMethod.param(Document.class, "body");
            processMethod.body()._return((GeneratedExpression)finalConfig.invoke(((Method)wsdlPayloadEnricher.get()).getName()).arg((GeneratedExpression)service).arg((GeneratedExpression)operationName).arg((GeneratedExpression)body));
            bodyEnricherMethod.body()._return((GeneratedExpression)this.ref(Optional.class).staticInvoke("of").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)enricherImpl)));
        } else {
            bodyEnricherMethod.body()._return((GeneratedExpression)this.ref(Optional.class).staticInvoke("absent"));
        }
    }

    private void generateStrategiesMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedInvocation wsdlProviderCastStrategy) {
        GeneratedMethod getStrategiesMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(List.class).narrow(WsdlSecurityStrategy.class), "security");
        getStrategiesMethod.annotate(Override.class);
        getStrategiesMethod._throws(Exception.class);
        GeneratedVariable serviceDefinitionParam = getStrategiesMethod.param(ServiceDefinition.class, "serviceDefinition");
        GeneratedInvocation getStrategiesInvocation = wsdlProviderComponent.wsdlSecurityResolver().isPresent() ? wsdlProviderCastStrategy.invoke(((Method)wsdlProviderComponent.wsdlSecurityResolver().get()).getName()).arg((GeneratedExpression)serviceDefinitionParam) : this.ref(Collections.class).staticInvoke("emptyList");
        getStrategiesMethod.body()._return((GeneratedExpression)getStrategiesInvocation);
    }

    private void generateWsdlSeparatorMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedMethod tokenSeparatorMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(String.class), "wsdlSeparator");
        tokenSeparatorMethod.annotate(Override.class);
        GeneratedExpression tokenSeparatorInvocation = ExpressionFactory.lit((String)wsdlProviderComponent.keySeparator());
        tokenSeparatorMethod.body()._return(tokenSeparatorInvocation);
    }

    private void generateServiceEndpointMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedInvocation wsdlProviderCastStrategy) {
        GeneratedMethod endpointMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(String.class), "endpoint");
        endpointMethod.annotate(Override.class);
        endpointMethod._throws(Exception.class);
        GeneratedVariable serviceDefinitionParam = endpointMethod.param(ServiceDefinition.class, "serviceDefinition");
        endpointMethod.body()._return((GeneratedExpression)wsdlProviderCastStrategy.invoke(wsdlProviderComponent.wsdlServiceEndpointMethod().getName()).arg((GeneratedExpression)serviceDefinitionParam));
    }

    private void generateServiceDefinitionsMethod(GeneratedClass wsdlProviderAdapterClass, WsdlProviderComponent wsdlProviderComponent, GeneratedInvocation wsdlProviderCastStrategy) {
        GeneratedMethod serviceDefinitionsMethod = wsdlProviderAdapterClass.method(1, (Type)this.ref(List.class).narrow(ServiceDefinition.class), "serviceDefinitions");
        serviceDefinitionsMethod.annotate(Override.class);
        serviceDefinitionsMethod._throws(Exception.class);
        if (wsdlProviderComponent.hasMultipleServiceDefinition()) {
            serviceDefinitionsMethod.body()._return((GeneratedExpression)wsdlProviderCastStrategy.invoke(wsdlProviderComponent.wsdlServiceRetrieverMethod().getName()));
        } else {
            GeneratedInvocation servicesRetrieve = wsdlProviderCastStrategy.invoke(wsdlProviderComponent.wsdlServiceRetrieverMethod().getName());
            serviceDefinitionsMethod.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(ServiceDefinition.class)).arg((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)servicesRetrieve)));
        }
    }

    private void generateGetProcessTemplate(GeneratedClass wsdlProcessAdapterClass) {
        wsdlProcessAdapterClass._implements(this.ref(ProcessAdapter.class).narrow(WsdlAdapter.class));
        GeneratedMethod getProcessTemplate = wsdlProcessAdapterClass.method(1, ProcessTemplate.class, "getProcessTemplate");
        TypeVariable t = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)t).narrow(WsdlAdapter.class));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultProcessTemplate.class).narrow((TypeReference)t).narrow(WsdlAdapter.class)).arg(ExpressionFactory._this()));
    }

    protected void generateMetadataMethods(GeneratedClass generatedClass) {
        generatedClass._implements(this.ref(ConnectorMetaDataEnabled.class));
        this.generateGetMetaDataKeysMethod(generatedClass);
        this.generateGetMetaDataMethod(generatedClass);
    }

    protected void generateConnectionManagedMetadataMethods(GeneratedClass generatedClass, GeneratedClass connectionKeyClass) {
        ConnectorMetaDataEnabledUtilsGenerator connectorMetaDataEnabledUtilsGenerator = new ConnectorMetaDataEnabledUtilsGenerator();
        connectorMetaDataEnabledUtilsGenerator.setCtx(this.ctx());
        generatedClass._implements(this.ref(ConnectorMetaDataEnabled.class));
        this.generateConnectionManagedGetMetaDataKeysMethod(generatedClass, connectionKeyClass);
        this.generateGetMetaDataMethod(generatedClass);
    }

    private void generateGetMetaDataKeysMethod(GeneratedClass generatedClass) {
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        GeneratedVariable wsdlMetaDataResolver = getMetadataKeys.body().decl((Type)this.ref(WsdlMetaDataDescriptor.class), "wsdlMetaDataResolver", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(WsdlMetaDataDescriptor.class)));
        getMetadataKeys.body()._return((GeneratedExpression)wsdlMetaDataResolver.invoke("getMetaDataKeys").arg(ExpressionFactory._this()));
    }

    private void generateGetMetaDataMethod(GeneratedClass generatedClass) {
        GeneratedMethod getMetadata = generatedClass.method(1, (Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "getMetaData");
        getMetadata.annotate(Override.class);
        getMetadata.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        getMetadata.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(NotImplementedException.class)).arg("A Processor is required in order to fetch MetaData"));
    }

    private void generateConnectionManagedGetMetaDataKeysMethod(GeneratedClass generatedClass, GeneratedClass connectionKeyClass) {
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        GeneratedVariable connection = getMetadataKeys.body().decl((Type)generatedClass, "connection", ExpressionFactory._null());
        GeneratedVariable defaultConnectionKey = getMetadataKeys.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = getMetadataKeys.body()._try();
        GeneratedBlock bodyToResolveKeys = tryTestConnection.body();
        bodyToResolveKeys.assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        GeneratedVariable wsdlMetaDataResolver = bodyToResolveKeys.decl((Type)this.ref(WsdlMetaDataDescriptor.class), "wsdlMetaDataResolver", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(WsdlMetaDataDescriptor.class)));
        bodyToResolveKeys._return((GeneratedExpression)wsdlMetaDataResolver.invoke("getMetaDataKeys").arg((GeneratedExpression)connection));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class)), (GeneratedExpression)this.ref(ConnectivityTestingErrorHandler.class).staticInvoke("buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
    }

    private GeneratedClass createBasicAdapter(Module module, WsdlProviderComponent wsdlProviderComponent) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.adapters");
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + wsdlProviderComponent.getClassName() + "WsdlProviderAdapter");
        this.ctx().registerProduct(Product.WSDL_PROVIDER_CONNECTOR_ADAPTER, (Identifiable)wsdlProviderComponent, module.getName(), (Object)clazz);
        return clazz;
    }

    private void generateClassJavaDoc(Module module, WsdlProviderComponent wsdlProviderComponent, GeneratedClass wsdlProviderAdapterClass) {
        wsdlProviderAdapterClass.javadoc().add((Object)("A <code>" + wsdlProviderAdapterClass.name() + "</code> is a wrapper around "));
        wsdlProviderAdapterClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        wsdlProviderAdapterClass.javadoc().add((Object)" that represents the WSDL generic connector ");
        wsdlProviderAdapterClass.javadoc().add((Object)this.ref(wsdlProviderComponent.asTypeMirror()));
    }
}

