/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.utils;

import java.util.Set;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.streaming.PagingConfiguration;

public class MuleGeneratorUtils {
    private MuleGeneratorUtils() {
    }

    public static Boolean shouldSkipFieldGenerationForParameter(Class processorAnnotatedWith, Set<String> privateFieldnames, Parameter variable) {
        if (variable.asTypeMirror().toString().startsWith(SourceCallback.class.getName())) {
            return true;
        }
        if (processorAnnotatedWith != null && variable.getAnnotation(processorAnnotatedWith) == null) {
            return true;
        }
        if (privateFieldnames.contains(variable.getName())) {
            return true;
        }
        if (variable.asTypeMirror().toString().startsWith(PagingConfiguration.class.getName())) {
            return true;
        }
        return false;
    }

    public static boolean hasStrategy(Module module, ConnectStrategy strategy) {
        if (module instanceof ManagedConnectionModule) {
            if (((ManagedConnectionModule)module).getConnectMethod().getStrategy().equals((Object)strategy)) {
                return true;
            }
        } else {
            for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                if (!connectionManagementComponent.getConnectMethod().getStrategy().equals((Object)strategy)) continue;
                return true;
            }
            for (WsdlProviderComponent wsdlComponent : module.manager().wsdlProviderComponent()) {
                if (!wsdlComponent.hasConnectionManagement() || !wsdlComponent.getConnectMethod().getStrategy().equals((Object)strategy)) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeReference getPoolConfig(Module module, Context ctx) {
        if (MuleGeneratorUtils.hasStrategy(module, ConnectStrategy.SINGLE_INSTANCE)) {
            return (TypeReference)ctx.getProduct(Product.CACHE_CONFIG);
        }
        return (TypeReference)ctx.getProduct(Product.POOL_CONFIG);
    }

    public static TypeReference getPoolImpl(Module module, Context ctx) {
        if (MuleGeneratorUtils.hasStrategy(module, ConnectStrategy.SINGLE_INSTANCE)) {
            return (TypeReference)ctx.getProduct(Product.CACHE_IMPL);
        }
        return (TypeReference)ctx.getProduct(Product.POOL_IMPL);
    }

    public static TypeReference getPoolConfig(ConnectionManagementComponent connectionManagementComponent, Context ctx) {
        if (connectionManagementComponent.getConnectMethod().getStrategy().equals((Object)ConnectStrategy.SINGLE_INSTANCE)) {
            return (TypeReference)ctx.getProduct(Product.CACHE_CONFIG);
        }
        return (TypeReference)ctx.getProduct(Product.POOL_CONFIG);
    }

    public static TypeReference getPoolImpl(ConnectionManagementComponent connectionManagementComponent, Context ctx) {
        if (connectionManagementComponent.getConnectMethod().getStrategy().equals((Object)ConnectStrategy.SINGLE_INSTANCE)) {
            return (TypeReference)ctx.getProduct(Product.CACHE_IMPL);
        }
        return (TypeReference)ctx.getProduct(Product.POOL_IMPL);
    }
}

