/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring.schema.global;

import java.math.BigInteger;
import java.util.List;
import javax.xml.namespace.QName;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.connectivity.CacheConfig;
import org.mule.devkit.generation.spring.schema.RegisteredElements;
import org.mule.devkit.generation.spring.schema.global.AbstractGlobalElementSchemaBuilder;
import org.mule.devkit.generation.spring.schema.global.util.GlobalElementSchemaBuilderResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.schema.Attribute;
import org.mule.devkit.model.schema.ComplexContent;
import org.mule.devkit.model.schema.ExplicitGroup;
import org.mule.devkit.model.schema.ExtensionType;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.model.schema.TopLevelComplexType;
import org.mule.devkit.model.schema.TopLevelElement;
import org.mule.devkit.utils.NameUtils;

public class WsdlProviderSchemaResolver
extends AbstractGlobalElementSchemaBuilder {
    private RegisteredElements registeredElements;

    public WsdlProviderSchemaResolver(RegisteredElements registeredElements) {
        this.registeredElements = registeredElements;
    }

    @Override
    protected RegisteredElements getRegisteredElements() {
        return this.registeredElements;
    }

    @Override
    public void buildGlobalElementElement(Module module, Context ctx) {
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            this.registerGlobalElementElement(module, ctx, new WsdlProviderSchemaBuilderResolver(wsdlProviderComponent));
        }
    }

    @Override
    public void registerProcessorsAndSourcesAndFilters(Module module) {
        this.registerProcessorElement(false, "invoke", "WSDLInvokeType", "Starts an execution with the underlying WSC.");
        this.registerWSDLInvokeType();
    }

    private void registerWSDLInvokeType() {
        TopLevelComplexType complexType = new TopLevelComplexType();
        complexType.setName("WSDLInvokeType");
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType complexContentExtension = new ExtensionType();
        complexContentExtension.setBase(SchemaConstants.MULE_ABSTRACT_MESSAGE_PROCESSOR_TYPE);
        complexContent.setExtension(complexContentExtension);
        complexContentExtension.getAttributeOrAttributeGroup().add(this.createAttribute("type", false, SchemaTypeConversion.convertType((String)this.getSchema().getTargetNamespace(), (String)"java.lang.String"), "The representation of the WSDL file plus an operation."));
        Attribute configRefAttr = this.createAttribute("config-ref", false, SchemaConstants.STRING, "Specify which configuration to use for this invocation.");
        complexContentExtension.getAttributeOrAttributeGroup().add(configRefAttr);
        this.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
    }

    private void registerGlobalElementPoolingProfileAndReconnectStrategy(ExplicitGroup all) {
        TopLevelElement poolingProfile = new TopLevelElement();
        poolingProfile.setName("connection-pooling-profile");
        poolingProfile.setType(SchemaConstants.MULE_POOLING_PROFILE_TYPE);
        poolingProfile.setMinOccurs(BigInteger.ZERO);
        poolingProfile.setAnnotation(this.createDocAnnotation("Characteristics of the connection pool."));
        all.getParticle().add(this.getObjectFactory().createElement(poolingProfile));
        TopLevelElement abstractReconnectStrategy = new TopLevelElement();
        abstractReconnectStrategy.setRef(SchemaConstants.MULE_ABSTRACT_RECONNECTION_STRATEGY);
        abstractReconnectStrategy.setMinOccurs(BigInteger.ZERO);
        abstractReconnectStrategy.setAnnotation(this.createDocAnnotation("Reconnection strategy that defines how Mule should handle a connection failure."));
        all.getParticle().add(this.getObjectFactory().createElement(abstractReconnectStrategy));
    }

    private void registerGlobalElementCacheProfile(ExplicitGroup all, ConnectMethod connectMethod) {
        String configName = NameUtils.uncamel((String)CacheConfig.class.getSimpleName());
        Type connectConfig = connectMethod.getCacheConfig();
        String type = this.registerComplexTypeWithoutRef(connectConfig);
        TopLevelElement strategyConfigElement = new TopLevelElement();
        strategyConfigElement.setName(configName);
        strategyConfigElement.setType(new QName(this.getSchema().getTargetNamespace(), type));
        strategyConfigElement.setMinOccurs(BigInteger.ZERO);
        all.getParticle().add(this.getObjectFactory().createElement(strategyConfigElement));
        TopLevelElement abstractReconnectStrategy = new TopLevelElement();
        abstractReconnectStrategy.setRef(SchemaConstants.MULE_ABSTRACT_RECONNECTION_STRATEGY);
        abstractReconnectStrategy.setMinOccurs(BigInteger.ZERO);
        abstractReconnectStrategy.setAnnotation(this.createDocAnnotation("Reconnection strategy that defines how Mule should handle a connection failure."));
        all.getParticle().add(this.getObjectFactory().createElement(abstractReconnectStrategy));
    }

    private void registerGlobalElementConnectParameters(ConnectMethod connectMethod, ExtensionType config, ExplicitGroup all, boolean forceOptional) {
        for (Parameter parameter : connectMethod.getParameters()) {
            if (parameter.asType().isCollection()) {
                this.generateCollectionElement(all, (Variable)parameter, forceOptional);
                continue;
            }
            config.getAttributeOrAttributeGroup().add(this.createParameterAttribute((Variable)parameter, forceOptional));
        }
    }

    private class WsdlProviderSchemaBuilderResolver
    implements GlobalElementSchemaBuilderResolver {
        private WsdlProviderComponent wsdlProviderComponent;

        public WsdlProviderSchemaBuilderResolver(WsdlProviderComponent wsdlProviderComponent) {
            this.wsdlProviderComponent = wsdlProviderComponent;
        }

        @Override
        public String resolveConfigElementName(Module module) {
            return this.wsdlProviderComponent.configElementName();
        }

        @Override
        public List<Field> resolveConfigurableFields(Module module) {
            return this.wsdlProviderComponent.getConfigurableFields();
        }

        @Override
        public void resolvePostGenerationGroup(Module module, ExtensionType config, ExplicitGroup all) {
            if (this.wsdlProviderComponent.hasConnectionManagement()) {
                ConnectMethod connectMethod = this.wsdlProviderComponent.getConnectMethod();
                WsdlProviderSchemaResolver.this.registerGlobalElementConnectParameters(connectMethod, config, all, false);
                if (ConnectStrategy.MULTIPLE_INSTANCES.equals((Object)connectMethod.getStrategy())) {
                    WsdlProviderSchemaResolver.this.registerGlobalElementPoolingProfileAndReconnectStrategy(all);
                } else {
                    WsdlProviderSchemaResolver.this.registerGlobalElementCacheProfile(all, connectMethod);
                }
            }
        }

        @Override
        public String resolveJavaDocSummary(Module module) {
            return this.wsdlProviderComponent.getJavaDocSummary();
        }
    }
}

