/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.pooling;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MetadataAware;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.utils.NameUtils;
import org.mule.util.pool.DefaultLifecycleEnabledObjectPool;
import org.mule.util.pool.LifecyleEnabledObjectPool;

public class PoolManagerGenerator
extends AbstractMetadataCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.ADAPTER_FACTORY, Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.POOL_MANAGER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.usesPooling();
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass poolManagerClass = this.getPoolManagerClass(module);
        poolManagerClass.javadoc().add((Object)("A <code>" + poolManagerClass.name() + "</code> is a wrapper around "));
        poolManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        poolManagerClass.javadoc().add((Object)" that enables pooling on the POJO.");
        for (Field field : module.getConfigurableFields()) {
            GeneratedField configField = poolManagerClass.field(4, this.ref(field.asTypeMirror()), field.getName());
            poolManagerClass.setter(configField);
        }
        GeneratedField muleContext = poolManagerClass.muleContextField();
        GeneratedField flowConstruct = poolManagerClass.flowConstructField();
        GeneratedField poolingProfile = poolManagerClass.field(2, (Type)this.ref(PoolingProfile.class), "poolingProfile");
        GeneratedField lifecyleEnabledObjectPool = poolManagerClass.field(2, (Type)this.ref(LifecyleEnabledObjectPool.class), "lifecyleEnabledObjectPool");
        poolManagerClass.setter(poolingProfile);
        poolManagerClass.getter(poolingProfile);
        poolManagerClass.setter(lifecyleEnabledObjectPool);
        poolManagerClass.getter(lifecyleEnabledObjectPool);
        this.generateStartMethod(module, poolManagerClass, lifecyleEnabledObjectPool, muleContext, poolingProfile);
        this.generateStopMethod(poolManagerClass, lifecyleEnabledObjectPool);
        this.generateIsCapableOfMethod(module, poolManagerClass);
        this.generateGetProcessTemplateMethod(module, poolManagerClass, lifecyleEnabledObjectPool);
        this.generateMetadataConstantsAndGetters(module, poolManagerClass);
    }

    private void generateGetProcessTemplateMethod(Module module, GeneratedClass poolManagerClass, GeneratedField lifecyleEnabledObjectPool) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedClass poolProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.POOL_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = poolManagerClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)capabilitiesAdapterClass));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)poolProcessTemplateClass).arg((GeneratedExpression)lifecyleEnabledObjectPool));
    }

    private void generateStopMethod(GeneratedClass poolManagerClass, GeneratedField lifecyleEnabledObjectPool) {
        GeneratedMethod stopMethod = poolManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod._throws(MuleException.class);
        GeneratedBlock newBody = stopMethod.body()._if(lifecyleEnabledObjectPool.isNotNull())._then();
        newBody.add((Statement)lifecyleEnabledObjectPool.invoke("stop"));
        newBody.add((Statement)lifecyleEnabledObjectPool.invoke("close"));
        newBody.assign((AssignmentTarget)lifecyleEnabledObjectPool, ExpressionFactory._null());
    }

    private void generateStartMethod(Module module, GeneratedClass poolManagerClass, GeneratedField lifecyleEnabledObjectPool, GeneratedField muleContext, GeneratedField poolingProfile) {
        GeneratedClass objectFactory = (GeneratedClass)this.ctx().getProduct(Product.ADAPTER_FACTORY, (Identifiable)module);
        GeneratedMethod startMethod = poolManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod._throws(MuleException.class);
        GeneratedVariable objectFactoryField = startMethod.body().decl((Type)objectFactory, "objectFactory", (GeneratedExpression)ExpressionFactory._new((TypeReference)objectFactory));
        for (Field field : module.getConfigurableFields()) {
            startMethod.body().add((Statement)objectFactoryField.invoke(NameUtils.buildSetter((String)field.getName())).arg((GeneratedExpression)ExpressionFactory._this().ref(field.getName())));
        }
        GeneratedInvocation defaultLifecycleEnabledObjectPool = ExpressionFactory._new((TypeReference)this.ref(DefaultLifecycleEnabledObjectPool.class));
        defaultLifecycleEnabledObjectPool.arg((GeneratedExpression)objectFactoryField);
        defaultLifecycleEnabledObjectPool.arg((GeneratedExpression)poolingProfile);
        defaultLifecycleEnabledObjectPool.arg((GeneratedExpression)muleContext);
        startMethod.body().assign((AssignmentTarget)lifecyleEnabledObjectPool, (GeneratedExpression)defaultLifecycleEnabledObjectPool);
        startMethod.body().add((Statement)lifecyleEnabledObjectPool.invoke("initialise"));
        startMethod.body().add((Statement)lifecyleEnabledObjectPool.invoke("start"));
    }

    private GeneratedClass getPoolManagerClass(Module module) {
        GeneratedClass capabilitiesAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".generated.pooling");
        GeneratedClass clazz = pkg._class(module.getClassName() + "PoolManager");
        clazz._implements(Startable.class);
        clazz._implements(Stoppable.class);
        clazz._implements(MuleContextAware.class);
        clazz._implements(FlowConstructAware.class);
        clazz._implements(this.ref(Capabilities.class));
        clazz._implements((TypeReference)this.ctx().getProduct(Product.POOL_MANAGER_INTERFACE));
        clazz._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)capabilitiesAdapterClass));
        clazz._implements(this.ref(MetadataAware.class));
        this.ctx().registerProduct(Product.POOL_MANAGER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

