/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.apidoc;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataKeyParamAffectsType;
import org.mule.api.annotations.param.Payload;
import org.mule.devkit.generation.apidoc.SampleLoader;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.apidoc.Variable;
import org.mule.devkit.model.apidoc.config.Config;
import org.mule.devkit.model.apidoc.config.ConfigurationConfig;
import org.mule.devkit.model.apidoc.config.ConnectionManagementConfig;
import org.mule.devkit.model.apidoc.config.OAuth2Config;
import org.mule.devkit.model.apidoc.config.WsdlProviderConfig;
import org.mule.devkit.model.apidoc.operation.FilterOperation;
import org.mule.devkit.model.apidoc.operation.Operation;
import org.mule.devkit.model.apidoc.operation.ProcessorOperation;
import org.mule.devkit.model.apidoc.operation.SourceOperation;
import org.mule.devkit.model.apidoc.operation.TransformerOperation;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;

public class ApiDocsModelUtils {
    public static List<SourceOperation> getSources(Module module, SampleLoader samplesLoader) {
        ArrayList<SourceOperation> sources = new ArrayList<SourceOperation>();
        for (SourceMethod sourceMethod : module.getSourceMethods()) {
            sources.add(ApiDocsModelUtils.buildBasicOperation((Method<Type>)sourceMethod, new SourceOperation(), samplesLoader));
        }
        return sources;
    }

    public static List<TransformerOperation> getTransformers(Module module, SampleLoader samplesLoader) {
        ArrayList<TransformerOperation> transformers = new ArrayList<TransformerOperation>();
        for (TransformerMethod method : module.getTransformerMethods()) {
            TransformerOperation transformer = new TransformerOperation();
            transformers.add(ApiDocsModelUtils.buildBasicOperation((Method<Type>)method, transformer, samplesLoader));
        }
        return transformers;
    }

    public static List<FilterOperation> getFilters(Module module, SampleLoader samplesLoader) {
        ArrayList<FilterOperation> filters = new ArrayList<FilterOperation>();
        for (FilterMethod method : module.getFilterMethods()) {
            filters.add(ApiDocsModelUtils.buildBasicOperation((Method<Type>)method, new FilterOperation(), samplesLoader));
        }
        return filters;
    }

    public static List<ProcessorOperation> getProcessors(Module module, SampleLoader samplesLoader) {
        ArrayList<ProcessorOperation> processors = new ArrayList<ProcessorOperation>();
        for (ProcessorMethod method : module.getProcessorMethods()) {
            ProcessorOperation processor = new ProcessorOperation();
            processor.isBatch(Boolean.valueOf(method.isBatch()));
            processor.isPaged(Boolean.valueOf(method.isPaged()));
            processors.add(ApiDocsModelUtils.buildBasicOperation((Method<Type>)method, processor, samplesLoader));
        }
        return processors;
    }

    private static <T extends Operation> T buildBasicOperation(Method<Type> method, T operation, SampleLoader sampleLoader) {
        operation.description(method.getJavaDocSummary());
        operation.javaName(method.getName());
        operation.xsdName(method.xsdName());
        operation.apiDocUrl(method.getJavaDocTagContent("api.doc"));
        operation.friendlyName(method.friendlyName());
        operation.parameters(ApiDocsModelUtils.getParams(method));
        operation.samples(sampleLoader.loadSamples(method.xsdName()));
        Variable returnType = new Variable();
        returnType.description(method.getJavaDocTagContent("return"));
        returnType.fullQualifiedJavaTypeName(method.getReturnGenericType().fullQualifiedName());
        returnType.javaTypeName(method.getReturnGenericType().toString());
        operation.javaReturnType(returnType);
        return operation;
    }

    public static List<Config> getConnectorConfigs(Module module) {
        ArrayList<Config> configs = new ArrayList<Config>();
        for (ConfigurationComponent configuration : module.manager().configurationComponents()) {
            configs.add((Config)ApiDocsModelUtils.buildBasicConfig((ConnectionComponent)configuration, new ConfigurationConfig()));
        }
        for (ConnectionManagementComponent connectionManagement : module.manager().connectionManagementComponents()) {
            ConnectionManagementConfig config = new ConnectionManagementConfig();
            config.attributes(ApiDocsModelUtils.getParams(connectionManagement.getConnectMethod()));
            configs.add((Config)ApiDocsModelUtils.buildBasicConfig((ConnectionComponent)connectionManagement, config));
        }
        Optional oAuth2Component = module.manager().oauth2Component();
        if (oAuth2Component.isPresent()) {
            configs.add((Config)ApiDocsModelUtils.buildBasicConfig((ConnectionComponent)oAuth2Component.get(), new OAuth2Config()));
        }
        for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
            WsdlProviderConfig wsdlConfig = new WsdlProviderConfig();
            wsdlConfig.setHasMultipleServiceDefinition(wsdlProviderComponent.hasMultipleServiceDefinition());
            wsdlConfig.setKeySeparator(wsdlProviderComponent.keySeparator());
            configs.add((Config)ApiDocsModelUtils.buildBasicConfig((ConnectionComponent)wsdlProviderComponent, wsdlConfig));
        }
        return configs;
    }

    private static <T extends Config> T buildBasicConfig(ConnectionComponent component, T config) {
        config.attributes(ApiDocsModelUtils.getConfigurableFields(component));
        config.description(component.getJavaDocSummary());
        config.friendlyName(component.friendlyName());
        config.configElementName(component.configElementName());
        config.javaName(component.getName());
        return config;
    }

    public static <M extends Method<? extends Type>> List<Variable> getParams(M method) {
        ArrayList<Variable> params = new ArrayList<Variable>();
        for (Parameter param : method.getParameters()) {
            Variable var = new Variable();
            var.isRefOnly(Boolean.valueOf(param.isRefOnly()));
            var.isComplexType(Boolean.valueOf(param.asType().isComplexType()));
            var.defaultValue(param.getDefaultValue());
            var.isOptional(Boolean.valueOf(param.isOptional() || param.hasDefaultValue()));
            var.fullQualifiedJavaTypeName(param.getGenericType().fullQualifiedName());
            var.javaTypeName(param.getGenericType().toString());
            var.javaName(param.getName());
            var.metaDataKeyParam(ApiDocsModelUtils.getMetaDataKeyAffects((Parameter<? extends Method>)param));
            var.isPayload(Boolean.valueOf(param.hasAnnotation(Payload.class)));
            var.description(method.getJavaDocParameterSummary(param.getName()));
            var.setString(Boolean.valueOf(param.asType().isString()));
            var.setEnum(Boolean.valueOf(param.asType().isEnum()));
            var.setHttpCallback(Boolean.valueOf(param.asType().isHttpCallback()));
            var.setTypeMirror(param.asTypeMirror().toString());
            var.setArrayOrListOrMap(Boolean.valueOf(param.asType().isMap() || param.asType().isArrayOrList()));
            params.add(var);
        }
        return params;
    }

    public static List<Variable> getConfigurableFields(ConnectionComponent component) {
        ArrayList<Variable> configurableFields = new ArrayList<Variable>();
        for (Field field : component.getConfigurableFields()) {
            Variable var = new Variable();
            var.isRefOnly(Boolean.valueOf(field.isRefOnly()));
            var.isComplexType(Boolean.valueOf(field.asType().isComplexType()));
            var.defaultValue(field.getDefaultValue());
            var.isOptional(Boolean.valueOf(field.isOptional() || field.hasDefaultValue()));
            var.javaTypeName(ApiDocsModelUtils.typeToString((Identifiable)field));
            var.fullQualifiedJavaTypeName(field.getJavaType());
            var.javaName(field.getName());
            var.description(field.getJavaDocSummary());
            var.setString(Boolean.valueOf(field.asType().isString()));
            var.setEnum(Boolean.valueOf(field.asType().isEnum()));
            var.setHttpCallback(Boolean.valueOf(field.asType().isHttpCallback()));
            var.setTypeMirror(field.asTypeMirror().toString());
            var.setArrayOrListOrMap(Boolean.valueOf(field.asType().isMap() || field.asType().isMap()));
            configurableFields.add(var);
        }
        return configurableFields;
    }

    private static String typeToString(Identifiable field) {
        StringBuilder result = new StringBuilder();
        result.append(field.asType().getClassName());
        if (field.hasTypeArguments()) {
            result.append("<").append(ApiDocsModelUtils.genericsToString(field)).append(">");
        }
        return result.toString();
    }

    private static String genericsToString(Identifiable field) {
        StringBuilder generics = new StringBuilder();
        Iterator iterator = field.getTypeArguments().iterator();
        generics.append(ApiDocsModelUtils.typeToString((Identifiable)iterator.next()));
        while (iterator.hasNext()) {
            generics.append(",").append(ApiDocsModelUtils.typeToString((Identifiable)iterator.next()));
        }
        return generics.toString();
    }

    private static Optional<MetaDataKeyParamAffectsType> getMetaDataKeyAffects(Parameter<? extends Method> param) {
        if (param.metaDataKey().isPresent()) {
            return Optional.fromNullable((Object)((MetaDataKeyParam)param.metaDataKey().get()).affects());
        }
        if (param.metaDataStaticKey().isPresent()) {
            return Optional.fromNullable((Object)MetaDataKeyParamAffectsType.INPUT);
        }
        return Optional.absent();
    }
}

